/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.anchor;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.ChildViewsIterable;
import com.beloo.widget.chipslayoutmanager.anchor.AbstractAnchorFactory;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.layouter.ICanvas;

public class ColumnsAnchorFactory
extends AbstractAnchorFactory {
    private ChildViewsIterable childViews;

    public ColumnsAnchorFactory(RecyclerView.LayoutManager lm, ICanvas canvas) {
        super(lm, canvas);
        this.childViews = new ChildViewsIterable(lm);
    }

    @Override
    public AnchorViewState getAnchor() {
        AnchorViewState minPosView = AnchorViewState.getNotFoundState();
        int minPosition = Integer.MAX_VALUE;
        int minLeft = Integer.MAX_VALUE;
        int maxRight = Integer.MIN_VALUE;
        for (View view : this.childViews) {
            AnchorViewState anchorViewState = this.createAnchorState(view);
            int pos = this.lm.getPosition(view);
            int left = this.lm.getDecoratedLeft(view);
            int right = this.lm.getDecoratedRight(view);
            Rect viewRect = new Rect(anchorViewState.getAnchorViewRect());
            if (!this.getCanvas().isInside(viewRect) || anchorViewState.isRemoving()) continue;
            if (minPosition > pos) {
                minPosition = pos;
                minPosView = anchorViewState;
            }
            if (minLeft > left) {
                minLeft = left;
                maxRight = right;
                continue;
            }
            if (minLeft != left) continue;
            maxRight = Math.max(maxRight, right);
        }
        if (!minPosView.isNotFoundState()) {
            minPosView.getAnchorViewRect().left = minLeft;
            minPosView.getAnchorViewRect().right = maxRight;
            minPosView.setPosition(minPosition);
        }
        return minPosView;
    }

    @Override
    public void resetRowCoordinates(AnchorViewState anchorView) {
        if (!anchorView.isNotFoundState()) {
            Rect rect = anchorView.getAnchorViewRect();
            rect.top = this.getCanvas().getCanvasTopBorder();
            rect.bottom = this.getCanvas().getCanvasBottomBorder();
        }
    }
}

