/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager;

import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.ChildViewsIterable;
import com.beloo.widget.chipslayoutmanager.IDisappearingViewsManager;
import com.beloo.widget.chipslayoutmanager.layouter.ICanvas;
import com.beloo.widget.chipslayoutmanager.layouter.IStateFactory;
import java.util.List;

class DisappearingViewsManager
implements IDisappearingViewsManager {
    private ICanvas canvas;
    private ChildViewsIterable childViews;
    private IStateFactory stateFactory;
    private int deletingItemsOnScreenCount;

    DisappearingViewsManager(ICanvas canvas, ChildViewsIterable childViews, IStateFactory stateFactory) {
        this.canvas = canvas;
        this.childViews = childViews;
        this.stateFactory = stateFactory;
    }

    @Override
    public DisappearingViewsContainer getDisappearingViews(RecyclerView.Recycler recycler) {
        List scrapList = recycler.getScrapList();
        DisappearingViewsContainer container = new DisappearingViewsContainer();
        for (RecyclerView.ViewHolder holder : scrapList) {
            View child = holder.itemView;
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
            if (lp.isItemRemoved()) continue;
            if (lp.getViewAdapterPosition() < this.canvas.getMinPositionOnScreen()) {
                container.backwardViews.put(lp.getViewAdapterPosition(), (Object)child);
                continue;
            }
            if (lp.getViewAdapterPosition() <= this.canvas.getMaxPositionOnScreen()) continue;
            container.forwardViews.put(lp.getViewAdapterPosition(), (Object)child);
        }
        return container;
    }

    @Override
    public int calcDisappearingViewsLength(RecyclerView.Recycler recycler) {
        int removedLength = 0;
        Integer minStart = Integer.MAX_VALUE;
        Integer maxEnd = Integer.MIN_VALUE;
        for (View view : this.childViews) {
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)view.getLayoutParams();
            boolean probablyMovedFromScreen = false;
            if (!lp.isItemRemoved()) {
                int pos = lp.getViewLayoutPosition();
                boolean bl = probablyMovedFromScreen = (pos = recycler.convertPreLayoutPositionToPostLayout(pos)) < this.canvas.getMinPositionOnScreen() || pos > this.canvas.getMaxPositionOnScreen();
            }
            if (!lp.isItemRemoved() && !probablyMovedFromScreen) continue;
            ++this.deletingItemsOnScreenCount;
            minStart = Math.min(minStart, this.stateFactory.getStart(view));
            maxEnd = Math.max(maxEnd, this.stateFactory.getEnd(view));
        }
        if (minStart != Integer.MAX_VALUE) {
            removedLength = maxEnd - minStart;
        }
        return removedLength;
    }

    @Override
    public int getDeletingItemsOnScreenCount() {
        return this.deletingItemsOnScreenCount;
    }

    @Override
    public void reset() {
        this.deletingItemsOnScreenCount = 0;
    }

    class DisappearingViewsContainer {
        private SparseArray<View> backwardViews = new SparseArray();
        private SparseArray<View> forwardViews = new SparseArray();

        DisappearingViewsContainer() {
        }

        int size() {
            return this.backwardViews.size() + this.forwardViews.size();
        }

        SparseArray<View> getBackwardViews() {
            return this.backwardViews;
        }

        SparseArray<View> getForwardViews() {
            return this.forwardViews;
        }
    }
}

