/*
 * Decompiled with CFR 0.152.
 */
package com.bekk.boss.pluto.embedded.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PlutResourcesFilter
implements Filter {
    private ServletContext servletContext;
    private static final Calendar LAST_MODIFIED = Calendar.getInstance();

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            URL resourceUrl;
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            String resource = httpServletRequest.getServletPath();
            if (resource == null) {
                resource = httpServletRequest.getPathInfo();
            }
            if ((resourceUrl = this.servletContext.getResource(resource)) == null) {
                resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resource);
                if (resourceUrl == null && resource.startsWith("/")) {
                    resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resource.substring(1));
                }
                if (resourceUrl == null) {
                    chain.doFilter(request, response);
                } else {
                    Calendar cal = Calendar.getInstance();
                    long ifModifiedSince = 0L;
                    try {
                        ifModifiedSince = httpServletRequest.getDateHeader("If-Modified-Since");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    long lastModifiedMillis = LAST_MODIFIED.getTimeInMillis();
                    long now = cal.getTimeInMillis();
                    cal.add(5, 1);
                    long expires = cal.getTimeInMillis();
                    if (ifModifiedSince > 0L && ifModifiedSince <= lastModifiedMillis) {
                        httpServletResponse.setDateHeader("Expires", expires);
                        httpServletResponse.setStatus(304);
                    } else {
                        httpServletResponse.setDateHeader("Date", now);
                        httpServletResponse.setDateHeader("Expires", expires);
                        httpServletResponse.setDateHeader("Retry-After", expires);
                        httpServletResponse.setHeader("Cache-Control", "public");
                        httpServletResponse.setDateHeader("Last-Modified", lastModifiedMillis);
                        InputStream stream = resourceUrl.openStream();
                        ServletOutputStream out = response.getOutputStream();
                        try {
                            int read = stream.read();
                            while (read != -1) {
                                out.write(read);
                                read = stream.read();
                            }
                        }
                        finally {
                            stream.close();
                        }
                    }
                }
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterconfig) throws ServletException {
        this.servletContext = filterconfig.getServletContext();
    }
}

