/*
 * Decompiled with CFR 0.152.
 */
package com.bekk.boss.pluto.embedded.jetty.util;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.springframework.web.context.ContextLoaderListener;

public class OverrideContextLoaderListener
implements ServletContextListener {
    private ContextLoaderListener contextLoaderListener = new ContextLoaderListener();
    private static final String PLUTO_SERVICE_CONFIG_LOCATION = "classpath:pluto-portal-driver-services-config.xml";

    public void contextDestroyed(ServletContextEvent sce) {
        this.contextLoaderListener.contextDestroyed(sce);
    }

    public void contextInitialized(ServletContextEvent sce) {
        Context.SContext servletContext = (Context.SContext)sce.getServletContext();
        ContextHandler contextHandler = servletContext.getContextHandler();
        Map initParams = contextHandler.getInitParams();
        String configLocations = (String)initParams.get("contextConfigLocation");
        if (configLocations != null) {
            configLocations = configLocations + " " + PLUTO_SERVICE_CONFIG_LOCATION;
            initParams.put("contextConfigLocation", configLocations);
        } else {
            initParams.put("contextConfigLocation", PLUTO_SERVICE_CONFIG_LOCATION);
        }
        EventListener[] listeners = contextHandler.getEventListeners();
        if (listeners != null) {
            ArrayList<EventListener> newListenerList = new ArrayList<EventListener>();
            for (int i = 0; i < listeners.length; ++i) {
                EventListener listener = listeners[i];
                if (listener instanceof ContextLoaderListener) continue;
                newListenerList.add(listener);
            }
            contextHandler.setEventListeners(newListenerList.toArray(new EventListener[newListenerList.size()]));
        }
        this.contextLoaderListener.contextInitialized(sce);
    }
}

