/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.player.misc;

import java.io.IOException;
import java.io.InputStream;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;

public class StreamDataSource
implements IMediaDataSource {
    private InputStream mIs;
    private long mPosition = 0L;

    public StreamDataSource(InputStream mIs) {
        this.mIs = mIs;
    }

    @Override
    public int readAt(long position, byte[] buffer, int offset, int size) throws IOException {
        if (size <= 0) {
            return size;
        }
        if (this.mPosition != position) {
            this.mIs.reset();
            this.mPosition = this.mIs.skip(position);
        }
        int length = this.mIs.read(buffer, offset, size);
        this.mPosition += (long)length;
        return length;
    }

    @Override
    public long getSize() throws IOException {
        return this.mIs.available();
    }

    @Override
    public void close() throws IOException {
        if (this.mIs != null) {
            this.mIs.close();
        }
        this.mIs = null;
    }
}

