package com.ssqandroidweb.utils;


import android.support.annotation.Nullable;

import java.text.DecimalFormat;
import java.util.regex.Pattern;

/**
 * Created by JasonDing on 16/4/29.
 * Copyright © 2016年 bestsign.cn. All rights reserved.
 */
public class StringUtils {
    public static String hiddenPhone(String phone) {
        if (phone.length() < 11) {
            return phone;
        }
        char[] chars = phone.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            if (i >= 3 && i <= 6) {
                chars[i] = '*';
            }
        }
        return new String(chars);
    }

    public static String hiddenPhone2(String phone) {
        if (isNotBlank(phone)) {
            char[] chars = phone.toCharArray();
            for (int i = 0; i < chars.length; i++) {
                if (i >= 3 & i < 8) {
                    chars[i] = '*';
                }
            }
            return new String(chars);
        } else {
            return null;
        }
    }

    public static String hiddenEmail(String email) {
        if (isNotBlank(email)) {
            if (email.contains("@")) {
                String emails[] = email.split("@");
                char[] chars = emails[0].toCharArray();
                for (int i = 0; i < chars.length; i++) {
                    if (i >= 2) {
                        chars[i] = '*';
                    }
                }
                return new String(chars) + "@" + emails[1];
            } else {
                return email;
            }
        } else {
            return null;
        }
    }

    public static String getTwonum(double num){
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(num);
    }


    public static String getFirstName(String name) {
        if (null == name || "".equals(name)) return null;
        return name.substring(0, 1);
    }

    public static boolean isNotBlank(@Nullable CharSequence string) {
        if (string == null) {
            return false;
        } else {
            int i = 0;

            for (int n = string.length(); i < n; ++i) {
                if (!Character.isWhitespace(string.charAt(i))) {
                    return true;
                }
            }

            return false;
        }
    }

    /**
     * 去除电话电话号码中的+86 - " "
     *
     * @param phone
     * @return
     */
    public static String cleanPhoneNumber(String phone) {
        if (null == phone) return null;
        String handledStr = phone;
        if (phone.startsWith("+86") && phone.length() > 3) {
            handledStr = phone.substring(3);
        }
        String[] dividers = {"-", " "};
        for (String divider : dividers) {
            if (handledStr.contains(divider)) {
                final String[] splitString = handledStr.split(divider);
                handledStr = "";
                for (String s : splitString) {
                    handledStr += s;
                }
            }
        }
        return handledStr;
    }

    /**
     * 使用divider连接所有的part
     *
     * @param divider 分隔符
     * @param parts   需要连接的部分
     * @return 连接好的字符串
     */
    public static String combine(String divider, String... parts) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (String part : parts) {
            index++;
            sb.append(part);
            if (index != parts.length) {
                sb.append(divider);
            }

        }
        return sb.toString();
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static boolean isEmpty(CharSequence str) {
        return (str == null || str.length() == 0);
    }

    public static String indextFirst(String url) {
        String result = url.substring(0, url.lastIndexOf("/"));
        return result;
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }
}
