/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.statusbar;

import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.util.Log;
import android.view.Window;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginResult;
import org.json.JSONException;

public class StatusBar
extends CordovaPlugin {
    private static final String TAG = "StatusBar";

    public void initialize(final CordovaInterface cordova, CordovaWebView webView) {
        Log.v((String)TAG, (String)"StatusBar: initialization");
        super.initialize(cordova, webView);
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Window window = cordova.getActivity().getWindow();
                window.clearFlags(2048);
                StatusBar.this.setStatusBarBackgroundColor(StatusBar.this.preferences.getString("StatusBarBackgroundColor", "#000000"));
            }
        });
    }

    public boolean execute(String action, final CordovaArgs args, CallbackContext callbackContext) throws JSONException {
        Log.v((String)TAG, (String)("Executing action: " + action));
        Activity activity = this.cordova.getActivity();
        final Window window = activity.getWindow();
        if ("_ready".equals(action)) {
            boolean statusBarVisible = (window.getAttributes().flags & 0x400) == 0;
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, statusBarVisible));
            return true;
        }
        if ("show".equals(action)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 19) {
                        int uiOptions = window.getDecorView().getSystemUiVisibility();
                        uiOptions &= 0xFFFFFBFF;
                        window.getDecorView().setSystemUiVisibility(uiOptions &= 0xFFFFFFFB);
                        return;
                    }
                    window.clearFlags(1024);
                }
            });
            return true;
        }
        if ("hide".equals(action)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 19) {
                        int uiOptions = window.getDecorView().getSystemUiVisibility() | 0x400 | 4;
                        window.getDecorView().setSystemUiVisibility(uiOptions);
                        return;
                    }
                    window.addFlags(1024);
                }
            });
            return true;
        }
        if ("backgroundColorByHexString".equals(action)) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatusBar.this.setStatusBarBackgroundColor(args.getString(0));
                    }
                    catch (JSONException ignore) {
                        Log.e((String)StatusBar.TAG, (String)"Invalid hexString argument, use f.i. '#777777'");
                    }
                }
            });
            return true;
        }
        return false;
    }

    private void setStatusBarBackgroundColor(String colorPref) {
        if (Build.VERSION.SDK_INT >= 21 && colorPref != null && !colorPref.isEmpty()) {
            Window window = this.cordova.getActivity().getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            try {
                window.getClass().getDeclaredMethod("setStatusBarColor", Integer.TYPE).invoke((Object)window, Color.parseColor((String)colorPref));
            }
            catch (IllegalArgumentException ignore) {
                Log.e((String)TAG, (String)"Invalid hexString argument, use f.i. '#999999'");
            }
            catch (Exception ignore) {
                Log.w((String)TAG, (String)("Method window.setStatusBarColor not found for SDK level " + Build.VERSION.SDK_INT));
            }
        }
    }
}

