/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.file;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;

public class PermissionHelper {
    private static final String LOG_TAG = "CordovaPermissionHelper";

    public static void requestPermission(CordovaPlugin plugin, int requestCode, String permission2) {
        PermissionHelper.requestPermissions(plugin, requestCode, new String[]{permission2});
    }

    public static void requestPermissions(CordovaPlugin plugin, int requestCode, String[] permissions) {
        try {
            Method requestPermission = CordovaInterface.class.getDeclaredMethod("requestPermissions", CordovaPlugin.class, Integer.TYPE, String[].class);
            requestPermission.invoke((Object)plugin.cordova, plugin, requestCode, permissions);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.d((String)LOG_TAG, (String)("No need to request permissions " + Arrays.toString(permissions)));
            PermissionHelper.deliverPermissionResult(plugin, requestCode, permissions);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.e((String)LOG_TAG, (String)("IllegalAccessException when requesting permissions " + Arrays.toString(permissions)), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.e((String)LOG_TAG, (String)("invocationTargetException when requesting permissions " + Arrays.toString(permissions)), (Throwable)invocationTargetException);
        }
    }

    public static boolean hasPermission(CordovaPlugin plugin, String permission2) {
        try {
            Method hasPermission = CordovaInterface.class.getDeclaredMethod("hasPermission", String.class);
            return (Boolean)hasPermission.invoke((Object)plugin.cordova, permission2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.d((String)LOG_TAG, (String)("No need to check for permission " + permission2));
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.e((String)LOG_TAG, (String)("IllegalAccessException when checking permission " + permission2), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.e((String)LOG_TAG, (String)("invocationTargetException when checking permission " + permission2), (Throwable)invocationTargetException);
        }
        return false;
    }

    private static void deliverPermissionResult(CordovaPlugin plugin, int requestCode, String[] permissions) {
        int[] requestResults = new int[permissions.length];
        Arrays.fill(requestResults, 0);
        try {
            Method onRequestPermissionResult = CordovaPlugin.class.getDeclaredMethod("onRequestPermissionResult", Integer.TYPE, String[].class, int[].class);
            onRequestPermissionResult.invoke((Object)plugin, requestCode, permissions, requestResults);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.e((String)LOG_TAG, (String)"NoSuchMethodException when delivering permissions results", (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.e((String)LOG_TAG, (String)"IllegalAccessException when delivering permissions results", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.e((String)LOG_TAG, (String)"InvocationTargetException when delivering permissions results", (Throwable)invocationTargetException);
        }
    }
}

