/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.file;

import android.os.Environment;
import android.os.StatFs;
import java.io.File;

public class DirectoryManager {
    private static final String LOG_TAG = "DirectoryManager";

    public static boolean testFileExists(String name) {
        boolean status;
        if (DirectoryManager.testSaveLocationExists() && !name.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = DirectoryManager.constructFilePaths(path.toString(), name);
            status = newPath.exists();
        } else {
            status = false;
        }
        return status;
    }

    public static long getFreeExternalStorageSpace() {
        String status = Environment.getExternalStorageState();
        long freeSpaceInBytes = 0L;
        if (!status.equals("mounted")) {
            return -1L;
        }
        freeSpaceInBytes = DirectoryManager.getFreeSpaceInBytes(Environment.getExternalStorageDirectory().getPath());
        return freeSpaceInBytes / 1024L;
    }

    public static long getFreeSpaceInBytes(String path) {
        try {
            StatFs stat = new StatFs(path);
            long blockSize = stat.getBlockSize();
            long availableBlocks = stat.getAvailableBlocks();
            return availableBlocks * blockSize;
        }
        catch (IllegalArgumentException e) {
            return 0L;
        }
    }

    public static boolean testSaveLocationExists() {
        String sDCardStatus = Environment.getExternalStorageState();
        boolean status = sDCardStatus.equals("mounted");
        return status;
    }

    private static File constructFilePaths(String file1, String file2) {
        File newPath = file2.startsWith(file1) ? new File(file2) : new File(file1 + "/" + file2);
        return newPath;
    }
}

