/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.file;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.file.Filesystem;
import org.apache.cordova.file.LocalFilesystemURL;
import org.apache.cordova.file.NoModificationAllowedException;
import org.apache.cordova.file.TypeMismatchException;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentFilesystem
extends Filesystem {
    private final Context context;

    public ContentFilesystem(Context context, CordovaResourceApi resourceApi) {
        super(Uri.parse((String)"content://"), "content", resourceApi);
        this.context = context;
    }

    @Override
    public Uri toNativeUri(LocalFilesystemURL inputURL) {
        String frag;
        String authorityAndPath = inputURL.uri.getEncodedPath().substring(this.name.length() + 2);
        if (authorityAndPath.length() < 2) {
            return null;
        }
        String ret = "content://" + authorityAndPath;
        String query = inputURL.uri.getEncodedQuery();
        if (query != null) {
            ret = ret + '?' + query;
        }
        if ((frag = inputURL.uri.getEncodedFragment()) != null) {
            ret = ret + '#' + frag;
        }
        return Uri.parse((String)ret);
    }

    @Override
    public LocalFilesystemURL toLocalUri(Uri inputURL) {
        if (!"content".equals(inputURL.getScheme())) {
            return null;
        }
        String subPath = inputURL.getEncodedPath();
        if (subPath.length() > 0) {
            subPath = subPath.substring(1);
        }
        Uri.Builder b = new Uri.Builder().scheme("cdvfile").authority("localhost").path(this.name).appendPath(inputURL.getAuthority());
        if (subPath.length() > 0) {
            b.appendEncodedPath(subPath);
        }
        Uri localUri = b.encodedQuery(inputURL.getEncodedQuery()).encodedFragment(inputURL.getEncodedFragment()).build();
        return LocalFilesystemURL.parse(localUri);
    }

    @Override
    public JSONObject getFileForLocalURL(LocalFilesystemURL inputURL, String fileName, JSONObject options, boolean directory) throws IOException, TypeMismatchException, JSONException {
        throw new UnsupportedOperationException("getFile() not supported for content:. Use resolveLocalFileSystemURL instead.");
    }

    @Override
    public boolean removeFileAtLocalURL(LocalFilesystemURL inputURL) throws NoModificationAllowedException {
        Uri contentUri = this.toNativeUri(inputURL);
        try {
            this.context.getContentResolver().delete(contentUri, null, null);
        }
        catch (UnsupportedOperationException t) {
            throw new NoModificationAllowedException("Deleting not supported for content uri: " + contentUri);
        }
        return true;
    }

    @Override
    public boolean recursiveRemoveFileAtLocalURL(LocalFilesystemURL inputURL) throws NoModificationAllowedException {
        throw new NoModificationAllowedException("Cannot remove content url");
    }

    @Override
    public LocalFilesystemURL[] listChildren(LocalFilesystemURL inputURL) throws FileNotFoundException {
        throw new UnsupportedOperationException("readEntriesAtLocalURL() not supported for content:. Use resolveLocalFileSystemURL instead.");
    }

    @Override
    public JSONObject getFileMetadataForLocalURL(LocalFilesystemURL inputURL) throws FileNotFoundException {
        long size = -1L;
        long lastModified = 0L;
        Uri nativeUri = this.toNativeUri(inputURL);
        String mimeType = this.resourceApi.getMimeType(nativeUri);
        try (Cursor cursor = this.openCursorForURL(nativeUri);){
            if (cursor != null && cursor.moveToFirst()) {
                size = this.resourceSizeForCursor(cursor);
                Long modified = this.lastModifiedDateForCursor(cursor);
                if (modified != null) {
                    lastModified = modified;
                }
            } else {
                CordovaResourceApi.OpenForReadResult offr = this.resourceApi.openForRead(nativeUri);
                size = offr.length;
            }
        }
        JSONObject metadata = new JSONObject();
        try {
            metadata.put("size", size);
            metadata.put("type", (Object)mimeType);
            metadata.put("name", (Object)this.name);
            metadata.put("fullPath", (Object)inputURL.path);
            metadata.put("lastModifiedDate", lastModified);
        }
        catch (JSONException e) {
            return null;
        }
        return metadata;
    }

    @Override
    public long writeToFileAtURL(LocalFilesystemURL inputURL, String data, int offset, boolean isBinary) throws NoModificationAllowedException {
        throw new NoModificationAllowedException("Couldn't write to file given its content URI");
    }

    @Override
    public long truncateFileAtURL(LocalFilesystemURL inputURL, long size) throws NoModificationAllowedException {
        throw new NoModificationAllowedException("Couldn't truncate file given its content URI");
    }

    protected Cursor openCursorForURL(Uri nativeUri) {
        ContentResolver contentResolver = this.context.getContentResolver();
        try {
            return contentResolver.query(nativeUri, null, null, null, null);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    private Long resourceSizeForCursor(Cursor cursor) {
        String sizeStr;
        int columnIndex = cursor.getColumnIndex("_size");
        if (columnIndex != -1 && (sizeStr = cursor.getString(columnIndex)) != null) {
            return Long.parseLong(sizeStr);
        }
        return null;
    }

    protected Long lastModifiedDateForCursor(Cursor cursor) {
        String dateStr;
        int columnIndex = cursor.getColumnIndex("date_modified");
        if (columnIndex == -1) {
            columnIndex = cursor.getColumnIndex("last_modified");
        }
        if (columnIndex != -1 && (dateStr = cursor.getString(columnIndex)) != null) {
            return Long.parseLong(dateStr);
        }
        return null;
    }

    @Override
    public String filesystemPathForURL(LocalFilesystemURL url) {
        File f = this.resourceApi.mapUriToFile(this.toNativeUri(url));
        return f == null ? null : f.getAbsolutePath();
    }

    @Override
    public LocalFilesystemURL URLforFilesystemPath(String path) {
        return null;
    }

    @Override
    public boolean canRemoveFileAtLocalURL(LocalFilesystemURL inputURL) {
        return true;
    }
}

