/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.contacts;

import android.content.Intent;
import android.database.Cursor;
import android.os.Build;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.util.Log;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.apache.cordova.contacts.ContactAccessor;
import org.apache.cordova.contacts.ContactAccessorSdk5;
import org.apache.cordova.contacts.PermissionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContactManager
extends CordovaPlugin {
    private ContactAccessor contactAccessor;
    private CallbackContext callbackContext;
    private JSONArray executeArgs;
    private static final String LOG_TAG = "Contact Query";
    public static final int UNKNOWN_ERROR = 0;
    public static final int INVALID_ARGUMENT_ERROR = 1;
    public static final int TIMEOUT_ERROR = 2;
    public static final int PENDING_OPERATION_ERROR = 3;
    public static final int IO_ERROR = 4;
    public static final int NOT_SUPPORTED_ERROR = 5;
    public static final int OPERATION_CANCELLED_ERROR = 6;
    public static final int PERMISSION_DENIED_ERROR = 20;
    private static final int CONTACT_PICKER_RESULT = 1000;
    public static String[] permissions;
    public static final int SEARCH_REQ_CODE = 0;
    public static final int SAVE_REQ_CODE = 1;
    public static final int REMOVE_REQ_CODE = 2;
    public static final int PICK_REQ_CODE = 3;
    public static final String READ = "android.permission.READ_CONTACTS";
    public static final String WRITE = "android.permission.WRITE_CONTACTS";

    protected void getReadPermission(int requestCode) {
        PermissionHelper.requestPermission(this, requestCode, READ);
    }

    protected void getWritePermission(int requestCode) {
        PermissionHelper.requestPermission(this, requestCode, WRITE);
    }

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        this.callbackContext = callbackContext;
        this.executeArgs = args;
        if (Build.VERSION.RELEASE.startsWith("1.")) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, 5));
            return true;
        }
        if (this.contactAccessor == null) {
            this.contactAccessor = new ContactAccessorSdk5(this.cordova);
        }
        if (action.equals("search")) {
            if (PermissionHelper.hasPermission(this, READ)) {
                this.search(this.executeArgs);
            } else {
                this.getReadPermission(0);
            }
        } else if (action.equals("save")) {
            if (PermissionHelper.hasPermission(this, WRITE)) {
                this.save(this.executeArgs);
            } else {
                this.getWritePermission(1);
            }
        } else if (action.equals("remove")) {
            if (PermissionHelper.hasPermission(this, WRITE)) {
                this.remove(this.executeArgs);
            } else {
                this.getWritePermission(2);
            }
        } else if (action.equals("pickContact")) {
            if (PermissionHelper.hasPermission(this, READ)) {
                this.pickContactAsync();
            } else {
                this.getReadPermission(3);
            }
        } else {
            return false;
        }
        return true;
    }

    private void remove(JSONArray args) throws JSONException {
        final String contactId = args.getString(0);
        this.cordova.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                if (ContactManager.this.contactAccessor.remove(contactId)) {
                    ContactManager.this.callbackContext.success();
                } else {
                    ContactManager.this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, 0));
                }
            }
        });
    }

    private void save(JSONArray args) throws JSONException {
        final JSONObject contact = args.getJSONObject(0);
        this.cordova.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                JSONObject res = null;
                String id = ContactManager.this.contactAccessor.save(contact);
                if (id != null) {
                    try {
                        res = ContactManager.this.contactAccessor.getContactById(id);
                    }
                    catch (JSONException e) {
                        Log.e((String)ContactManager.LOG_TAG, (String)"JSON fail.", (Throwable)e);
                    }
                }
                if (res != null) {
                    ContactManager.this.callbackContext.success(res);
                } else {
                    ContactManager.this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, 0));
                }
            }
        });
    }

    private void search(JSONArray args) throws JSONException {
        final JSONArray filter = args.getJSONArray(0);
        final JSONObject options = args.get(1) == null ? null : args.getJSONObject(1);
        this.cordova.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                JSONArray res = ContactManager.this.contactAccessor.search(filter, options);
                ContactManager.this.callbackContext.success(res);
            }
        });
    }

    private void pickContactAsync() {
        final ContactManager plugin = this;
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                Intent contactPickerIntent = new Intent("android.intent.action.PICK", ContactsContract.Contacts.CONTENT_URI);
                plugin.cordova.startActivityForResult(plugin, contactPickerIntent, 1000);
            }
        };
        this.cordova.getThreadPool().execute(worker);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == 1000) {
            if (resultCode == -1) {
                String contactId = intent.getData().getLastPathSegment();
                Cursor c = this.cordova.getActivity().getContentResolver().query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"_id"}, "contact_id = " + contactId, null, null);
                if (!c.moveToFirst()) {
                    this.callbackContext.error("Error occured while retrieving contact raw id");
                    return;
                }
                String id = c.getString(c.getColumnIndex("_id"));
                c.close();
                try {
                    JSONObject contact = this.contactAccessor.getContactById(id);
                    this.callbackContext.success(contact);
                    return;
                }
                catch (JSONException e) {
                    Log.e((String)LOG_TAG, (String)"JSON fail.", (Throwable)e);
                }
            } else if (resultCode == 0) {
                this.callbackContext.error(6);
                return;
            }
            this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, 0));
        }
    }

    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        for (int r : grantResults) {
            if (r != -1) continue;
            this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, 20));
            return;
        }
        switch (requestCode) {
            case 0: {
                this.search(this.executeArgs);
                break;
            }
            case 1: {
                this.save(this.executeArgs);
                break;
            }
            case 2: {
                this.remove(this.executeArgs);
                break;
            }
            case 3: {
                this.pickContactAsync();
            }
        }
    }

    public void onRestoreStateForActivityResult(Bundle state, CallbackContext callbackContext) {
        this.callbackContext = callbackContext;
        this.contactAccessor = new ContactAccessorSdk5(this.cordova);
    }
}

