/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.CursorLoader;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.cordova.CordovaInterface;

public class FileHelper {
    private static final String LOG_TAG = "FileUtils";
    private static final String _DATA = "_data";

    public static String getRealPath(Uri uri, CordovaInterface cordova) {
        String realPath = null;
        realPath = Build.VERSION.SDK_INT < 11 ? FileHelper.getRealPathFromURI_BelowAPI11((Context)cordova.getActivity(), uri) : (Build.VERSION.SDK_INT < 19 ? FileHelper.getRealPathFromURI_API11to18((Context)cordova.getActivity(), uri) : FileHelper.getRealPathFromURI_API19((Context)cordova.getActivity(), uri));
        return realPath;
    }

    public static String getRealPath(String uriString, CordovaInterface cordova) {
        return FileHelper.getRealPath(Uri.parse((String)uriString), cordova);
    }

    @SuppressLint(value={"NewApi"})
    public static String getRealPathFromURI_API19(Context context, Uri uri) {
        String filePath = "";
        try {
            String wholeID = DocumentsContract.getDocumentId((Uri)uri);
            String id = wholeID.indexOf(":") > -1 ? wholeID.split(":")[1] : (wholeID.indexOf(";") > -1 ? wholeID.split(";")[1] : wholeID);
            String[] column = new String[]{_DATA};
            String sel = "_id=?";
            Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, column, sel, new String[]{id}, null);
            int columnIndex = cursor.getColumnIndex(column[0]);
            if (cursor.moveToFirst()) {
                filePath = cursor.getString(columnIndex);
            }
            cursor.close();
        }
        catch (Exception e) {
            filePath = "";
        }
        return filePath;
    }

    @SuppressLint(value={"NewApi"})
    public static String getRealPathFromURI_API11to18(Context context, Uri contentUri) {
        String[] proj = new String[]{_DATA};
        String result = null;
        try {
            CursorLoader cursorLoader = new CursorLoader(context, contentUri, proj, null, null, null);
            Cursor cursor = cursorLoader.loadInBackground();
            if (cursor != null) {
                int column_index = cursor.getColumnIndexOrThrow(_DATA);
                cursor.moveToFirst();
                result = cursor.getString(column_index);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String getRealPathFromURI_BelowAPI11(Context context, Uri contentUri) {
        String[] proj = new String[]{_DATA};
        String result = null;
        try {
            Cursor cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow(_DATA);
            cursor.moveToFirst();
            result = cursor.getString(column_index);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static InputStream getInputStreamFromUriString(String uriString, CordovaInterface cordova) throws IOException {
        InputStream returnValue = null;
        if (uriString.startsWith("content")) {
            Uri uri = Uri.parse((String)uriString);
            returnValue = cordova.getActivity().getContentResolver().openInputStream(uri);
        } else if (uriString.startsWith("file://")) {
            int question = uriString.indexOf("?");
            if (question > -1) {
                uriString = uriString.substring(0, question);
            }
            if (uriString.startsWith("file:///android_asset/")) {
                Uri uri = Uri.parse((String)uriString);
                String relativePath = uri.getPath().substring(15);
                returnValue = cordova.getActivity().getAssets().open(relativePath);
            } else {
                try {
                    returnValue = cordova.getActivity().getContentResolver().openInputStream(Uri.parse((String)uriString));
                }
                catch (Exception e) {
                    returnValue = null;
                }
                if (returnValue == null) {
                    returnValue = new FileInputStream(FileHelper.getRealPath(uriString, cordova));
                }
            }
        } else {
            returnValue = new FileInputStream(uriString);
        }
        return returnValue;
    }

    public static String stripFileProtocol(String uriString) {
        if (uriString.startsWith("file://")) {
            uriString = uriString.substring(7);
        }
        return uriString;
    }

    public static String getMimeTypeForExtension(String path) {
        String extension = path;
        int lastDot = extension.lastIndexOf(46);
        if (lastDot != -1) {
            extension = extension.substring(lastDot + 1);
        }
        if ((extension = extension.toLowerCase(Locale.getDefault())).equals("3ga")) {
            return "audio/3gpp";
        }
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
    }

    public static String getMimeType(String uriString, CordovaInterface cordova) {
        String mimeType = null;
        Uri uri = Uri.parse((String)uriString);
        mimeType = uriString.startsWith("content://") ? cordova.getActivity().getContentResolver().getType(uri) : FileHelper.getMimeTypeForExtension(uri.getPath());
        return mimeType;
    }
}

