/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.camera;

import android.content.ActivityNotFoundException;
import android.content.ContentValues;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.apache.cordova.camera.ExifHelper;
import org.apache.cordova.camera.FileHelper;
import org.apache.cordova.camera.PermissionHelper;
import org.json.JSONArray;
import org.json.JSONException;

public class CameraLauncher
extends CordovaPlugin
implements MediaScannerConnection.MediaScannerConnectionClient {
    private static final int DATA_URL = 0;
    private static final int FILE_URI = 1;
    private static final int NATIVE_URI = 2;
    private static final int PHOTOLIBRARY = 0;
    private static final int CAMERA = 1;
    private static final int SAVEDPHOTOALBUM = 2;
    private static final int PICTURE = 0;
    private static final int VIDEO = 1;
    private static final int ALLMEDIA = 2;
    private static final int JPEG = 0;
    private static final int PNG = 1;
    private static final String GET_PICTURE = "Get Picture";
    private static final String GET_VIDEO = "Get Video";
    private static final String GET_All = "Get All";
    public static final int PERMISSION_DENIED_ERROR = 20;
    public static final int TAKE_PIC_SEC = 0;
    public static final int SAVE_TO_ALBUM_SEC = 1;
    private static final String LOG_TAG = "CameraLauncher";
    private static final int CROP_CAMERA = 100;
    private int mQuality;
    private int targetWidth;
    private int targetHeight;
    private Uri imageUri;
    private int encodingType;
    private int mediaType;
    private int destType;
    private int srcType;
    private boolean saveToPhotoAlbum;
    private boolean correctOrientation;
    private boolean orientationCorrected;
    private boolean allowEdit;
    protected static final String[] permissions = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
    public CallbackContext callbackContext;
    private int numPics;
    private MediaScannerConnection conn;
    private Uri scanMe;
    private Uri croppedUri;

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        this.callbackContext = callbackContext;
        if (action.equals("takePicture")) {
            this.srcType = 1;
            this.destType = 1;
            this.saveToPhotoAlbum = false;
            this.targetHeight = 0;
            this.targetWidth = 0;
            this.encodingType = 0;
            this.mediaType = 0;
            this.mQuality = 80;
            this.destType = args.getInt(1);
            this.srcType = args.getInt(2);
            this.mQuality = args.getInt(0);
            this.targetWidth = args.getInt(3);
            this.targetHeight = args.getInt(4);
            this.encodingType = args.getInt(5);
            this.mediaType = args.getInt(6);
            this.allowEdit = args.getBoolean(7);
            this.correctOrientation = args.getBoolean(8);
            this.saveToPhotoAlbum = args.getBoolean(9);
            if (this.targetWidth < 1) {
                this.targetWidth = -1;
            }
            if (this.targetHeight < 1) {
                this.targetHeight = -1;
            }
            if (this.targetHeight == -1 && this.targetWidth == -1 && this.mQuality == 100 && !this.correctOrientation && this.encodingType == 1 && this.srcType == 1) {
                this.encodingType = 0;
            }
            try {
                if (this.srcType == 1) {
                    this.callTakePicture(this.destType, this.encodingType);
                } else if (this.srcType == 0 || this.srcType == 2) {
                    if (this.mediaType == 0 && (this.destType == 1 || this.destType == 2) && this.fileWillBeModified() && !PermissionHelper.hasPermission(this, permissions[0])) {
                        PermissionHelper.requestPermission(this, 1, "android.permission.READ_EXTERNAL_STORAGE");
                    } else {
                        this.getImage(this.srcType, this.destType, this.encodingType);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                callbackContext.error("Illegal Argument Exception");
                PluginResult r = new PluginResult(PluginResult.Status.ERROR);
                callbackContext.sendPluginResult(r);
                return true;
            }
            PluginResult r = new PluginResult(PluginResult.Status.NO_RESULT);
            r.setKeepCallback(true);
            callbackContext.sendPluginResult(r);
            return true;
        }
        return false;
    }

    private String getTempDirectoryPath() {
        File cache = null;
        cache = Environment.getExternalStorageState().equals("mounted") ? this.cordova.getActivity().getExternalCacheDir() : this.cordova.getActivity().getCacheDir();
        cache.mkdirs();
        return cache.getAbsolutePath();
    }

    public void callTakePicture(int returnType, int encodingType) {
        if (PermissionHelper.hasPermission(this, permissions[0])) {
            this.takePicture(returnType, encodingType);
        } else {
            PermissionHelper.requestPermission(this, 0, "android.permission.READ_EXTERNAL_STORAGE");
        }
    }

    public void takePicture(int returnType, int encodingType) {
        this.numPics = this.queryImgDB(this.whichContentStore()).getCount();
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File photo = this.createCaptureFile(encodingType);
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)photo));
        this.imageUri = Uri.fromFile((File)photo);
        if (this.cordova != null) {
            PackageManager mPm = this.cordova.getActivity().getPackageManager();
            if (intent.resolveActivity(mPm) != null) {
                this.cordova.startActivityForResult((CordovaPlugin)this, intent, 32 + returnType + 1);
            } else {
                LOG.d((String)LOG_TAG, (String)"Error: You don't have a default camera.  Your device may not be CTS complaint.");
            }
        }
    }

    private File createCaptureFile(int encodingType) {
        return this.createCaptureFile(encodingType, "");
    }

    private File createCaptureFile(int encodingType, String fileName) {
        if (fileName.isEmpty()) {
            fileName = ".Pic";
        }
        if (encodingType == 0) {
            fileName = fileName + ".jpg";
        } else if (encodingType == 1) {
            fileName = fileName + ".png";
        } else {
            throw new IllegalArgumentException("Invalid Encoding Type: " + encodingType);
        }
        return new File(this.getTempDirectoryPath(), fileName);
    }

    public void getImage(int srcType, int returnType, int encodingType) {
        Intent intent = new Intent();
        String title = GET_PICTURE;
        this.croppedUri = null;
        if (this.mediaType == 0) {
            intent.setType("image/*");
            if (this.allowEdit) {
                intent.setAction("android.intent.action.PICK");
                intent.putExtra("crop", "true");
                if (this.targetWidth > 0) {
                    intent.putExtra("outputX", this.targetWidth);
                }
                if (this.targetHeight > 0) {
                    intent.putExtra("outputY", this.targetHeight);
                }
                if (this.targetHeight > 0 && this.targetWidth > 0 && this.targetWidth == this.targetHeight) {
                    intent.putExtra("aspectX", 1);
                    intent.putExtra("aspectY", 1);
                }
                File photo = this.createCaptureFile(encodingType);
                this.croppedUri = Uri.fromFile((File)photo);
                intent.putExtra("output", (Parcelable)this.croppedUri);
            } else {
                intent.setAction("android.intent.action.GET_CONTENT");
                intent.addCategory("android.intent.category.OPENABLE");
            }
        } else if (this.mediaType == 1) {
            intent.setType("video/*");
            title = GET_VIDEO;
            intent.setAction("android.intent.action.GET_CONTENT");
            intent.addCategory("android.intent.category.OPENABLE");
        } else if (this.mediaType == 2) {
            intent.setType("*/*");
            title = GET_All;
            intent.setAction("android.intent.action.GET_CONTENT");
            intent.addCategory("android.intent.category.OPENABLE");
        }
        if (this.cordova != null) {
            this.cordova.startActivityForResult((CordovaPlugin)this, Intent.createChooser((Intent)intent, (CharSequence)new String(title)), (srcType + 1) * 16 + returnType + 1);
        }
    }

    private void performCrop(Uri picUri, int destType, Intent cameraIntent) {
        try {
            Intent cropIntent = new Intent("com.android.camera.action.CROP");
            cropIntent.setDataAndType(picUri, "image/*");
            cropIntent.putExtra("crop", "true");
            if (this.targetWidth > 0) {
                cropIntent.putExtra("outputX", this.targetWidth);
            }
            if (this.targetHeight > 0) {
                cropIntent.putExtra("outputY", this.targetHeight);
            }
            if (this.targetHeight > 0 && this.targetWidth > 0 && this.targetWidth == this.targetHeight) {
                cropIntent.putExtra("aspectX", 1);
                cropIntent.putExtra("aspectY", 1);
            }
            this.croppedUri = Uri.fromFile((File)this.createCaptureFile(this.encodingType, System.currentTimeMillis() + ""));
            cropIntent.putExtra("output", (Parcelable)this.croppedUri);
            if (this.cordova != null) {
                this.cordova.startActivityForResult((CordovaPlugin)this, cropIntent, 100 + destType);
            }
        }
        catch (ActivityNotFoundException anfe) {
            Log.e((String)LOG_TAG, (String)"Crop operation not supported on this device");
            try {
                this.processResultFromCamera(destType, cameraIntent);
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.e((String)LOG_TAG, (String)"Unable to write to file");
            }
        }
    }

    private void processResultFromCamera(int destType, Intent intent) throws IOException {
        String sourcePath;
        int rotate = 0;
        ExifHelper exif = new ExifHelper();
        String string = sourcePath = this.allowEdit && this.croppedUri != null ? FileHelper.stripFileProtocol(this.croppedUri.toString()) : FileHelper.stripFileProtocol(this.imageUri.toString());
        if (this.encodingType == 0) {
            try {
                exif.createInFile(sourcePath);
                exif.readExifData();
                rotate = exif.getOrientation();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Bitmap bitmap = null;
        Uri galleryUri = null;
        if (this.saveToPhotoAlbum) {
            galleryUri = Uri.fromFile((File)new File(this.getPicutresPath()));
            if (this.allowEdit && this.croppedUri != null) {
                this.writeUncompressedImage(this.croppedUri, galleryUri);
            } else {
                this.writeUncompressedImage(this.imageUri, galleryUri);
            }
            this.refreshGallery(galleryUri);
        }
        if (destType == 0) {
            bitmap = this.getScaledBitmap(sourcePath);
            if (bitmap == null) {
                bitmap = (Bitmap)intent.getExtras().get("data");
            }
            if (bitmap == null) {
                Log.d((String)LOG_TAG, (String)"I either have a null image path or bitmap");
                this.failPicture("Unable to create bitmap!");
                return;
            }
            if (rotate != 0 && this.correctOrientation) {
                bitmap = this.getRotatedBitmap(rotate, bitmap, exif);
            }
            this.processPicture(bitmap, this.encodingType);
            if (!this.saveToPhotoAlbum) {
                this.checkForDuplicateImage(0);
            }
        } else if (destType == 1 || destType == 2) {
            if (this.targetHeight == -1 && this.targetWidth == -1 && this.mQuality == 100 && !this.correctOrientation) {
                if (this.saveToPhotoAlbum) {
                    this.callbackContext.success(galleryUri.toString());
                } else {
                    Uri uri = Uri.fromFile((File)this.createCaptureFile(this.encodingType, System.currentTimeMillis() + ""));
                    if (this.allowEdit && this.croppedUri != null) {
                        this.writeUncompressedImage(this.croppedUri, uri);
                    } else {
                        this.writeUncompressedImage(this.imageUri, uri);
                    }
                    this.callbackContext.success(uri.toString());
                }
            } else {
                Uri uri = Uri.fromFile((File)this.createCaptureFile(this.encodingType, System.currentTimeMillis() + ""));
                bitmap = this.getScaledBitmap(sourcePath);
                if (bitmap == null) {
                    Log.d((String)LOG_TAG, (String)"I either have a null image path or bitmap");
                    this.failPicture("Unable to create bitmap!");
                    return;
                }
                if (rotate != 0 && this.correctOrientation) {
                    bitmap = this.getRotatedBitmap(rotate, bitmap, exif);
                }
                OutputStream os = this.cordova.getActivity().getContentResolver().openOutputStream(uri);
                Bitmap.CompressFormat compressFormat = this.encodingType == 0 ? Bitmap.CompressFormat.JPEG : Bitmap.CompressFormat.PNG;
                bitmap.compress(compressFormat, this.mQuality, os);
                os.close();
                if (this.encodingType == 0) {
                    String exifPath = uri.getPath();
                    exif.createOutFile(exifPath);
                    exif.writeExifData();
                }
                this.callbackContext.success(uri.toString());
            }
        } else {
            throw new IllegalStateException();
        }
        this.cleanup(1, this.imageUri, galleryUri, bitmap);
        bitmap = null;
    }

    private String getPicutresPath() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "IMG_" + timeStamp + (this.encodingType == 0 ? ".jpg" : ".png");
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        String galleryPath = storageDir.getAbsolutePath() + "/" + imageFileName;
        return galleryPath;
    }

    private void refreshGallery(Uri contentUri) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        mediaScanIntent.setData(contentUri);
        this.cordova.getActivity().sendBroadcast(mediaScanIntent);
    }

    private String ouputModifiedBitmap(Bitmap bitmap, Uri uri) throws IOException {
        String realPath = FileHelper.getRealPath(uri, this.cordova);
        String fileName = realPath != null ? realPath.substring(realPath.lastIndexOf(47) + 1) : "modified." + (this.encodingType == 0 ? "jpg" : "png");
        String modifiedPath = this.getTempDirectoryPath() + "/" + fileName;
        FileOutputStream os = new FileOutputStream(modifiedPath);
        Bitmap.CompressFormat compressFormat = this.encodingType == 0 ? Bitmap.CompressFormat.JPEG : Bitmap.CompressFormat.PNG;
        bitmap.compress(compressFormat, this.mQuality, (OutputStream)os);
        ((OutputStream)os).close();
        if (realPath != null && this.encodingType == 0) {
            ExifHelper exif = new ExifHelper();
            try {
                exif.createInFile(realPath);
                exif.readExifData();
                if (this.correctOrientation && this.orientationCorrected) {
                    exif.resetOrientation();
                }
                exif.createOutFile(modifiedPath);
                exif.writeExifData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return modifiedPath;
    }

    private void processResultFromGallery(int destType, Intent intent) {
        Uri uri = intent.getData();
        if (uri == null) {
            if (this.croppedUri != null) {
                uri = this.croppedUri;
            } else {
                this.failPicture("null data from photo library");
                return;
            }
        }
        int rotate = 0;
        String fileLocation = FileHelper.getRealPath(uri, this.cordova);
        Log.d((String)LOG_TAG, (String)("File locaton is: " + fileLocation));
        if (this.mediaType != 0) {
            this.callbackContext.success(fileLocation);
        } else if (!(this.targetHeight != -1 || this.targetWidth != -1 || destType != 1 && destType != 2 || this.correctOrientation)) {
            this.callbackContext.success(uri.toString());
        } else {
            String uriString = uri.toString();
            String mimeType = FileHelper.getMimeType(uriString, this.cordova);
            if (!"image/jpeg".equalsIgnoreCase(mimeType) && !"image/png".equalsIgnoreCase(mimeType)) {
                Log.d((String)LOG_TAG, (String)"I either have a null image path or bitmap");
                this.failPicture("Unable to retrieve path to picture!");
                return;
            }
            Bitmap bitmap = null;
            try {
                bitmap = this.getScaledBitmap(uriString);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (bitmap == null) {
                Log.d((String)LOG_TAG, (String)"I either have a null image path or bitmap");
                this.failPicture("Unable to create bitmap!");
                return;
            }
            if (this.correctOrientation && (rotate = this.getImageOrientation(uri)) != 0) {
                Matrix matrix = new Matrix();
                matrix.setRotate((float)rotate);
                try {
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    this.orientationCorrected = true;
                }
                catch (OutOfMemoryError oom) {
                    this.orientationCorrected = false;
                }
            }
            if (destType == 0) {
                this.processPicture(bitmap, this.encodingType);
            } else if (destType == 1 || destType == 2) {
                if (this.targetHeight > 0 && this.targetWidth > 0 || this.correctOrientation && this.orientationCorrected) {
                    try {
                        String modifiedPath = this.ouputModifiedBitmap(bitmap, uri);
                        this.callbackContext.success("file://" + modifiedPath + "?" + System.currentTimeMillis());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.failPicture("Error retrieving image.");
                    }
                } else {
                    this.callbackContext.success(fileLocation);
                }
            }
            if (bitmap != null) {
                bitmap.recycle();
                bitmap = null;
            }
            System.gc();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        block22: {
            int srcType = requestCode / 16 - 1;
            int destType = requestCode % 16 - 1;
            if (requestCode >= 100) {
                if (resultCode == -1) {
                    destType = requestCode - 100;
                    try {
                        this.processResultFromCamera(destType, intent);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Log.e((String)LOG_TAG, (String)"Unable to write to file");
                    }
                } else if (resultCode == 0) {
                    this.failPicture("Camera cancelled.");
                } else {
                    this.failPicture("Did not complete!");
                }
            } else if (srcType == 1) {
                if (resultCode == -1) {
                    try {
                        if (this.allowEdit) {
                            Uri tmpFile = Uri.fromFile((File)this.createCaptureFile(this.encodingType));
                            this.performCrop(tmpFile, destType, intent);
                            break block22;
                        }
                        this.processResultFromCamera(destType, intent);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.failPicture("Error capturing image.");
                    }
                } else if (resultCode == 0) {
                    this.failPicture("Camera cancelled.");
                } else {
                    this.failPicture("Did not complete!");
                }
            } else if (srcType == 0 || srcType == 2) {
                if (resultCode == -1 && intent != null) {
                    final Intent i = intent;
                    final int finalDestType = destType;
                    this.cordova.getThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            CameraLauncher.this.processResultFromGallery(finalDestType, i);
                        }
                    });
                } else if (resultCode == 0) {
                    this.failPicture("Selection cancelled.");
                } else {
                    this.failPicture("Selection did not complete!");
                }
            }
        }
    }

    private int getImageOrientation(Uri uri) {
        int rotate = 0;
        String[] cols = new String[]{"orientation"};
        try {
            Cursor cursor = this.cordova.getActivity().getContentResolver().query(uri, cols, null, null, null);
            if (cursor != null) {
                cursor.moveToPosition(0);
                rotate = cursor.getInt(0);
                cursor.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rotate;
    }

    private Bitmap getRotatedBitmap(int rotate, Bitmap bitmap, ExifHelper exif) {
        Matrix matrix = new Matrix();
        if (rotate == 180) {
            matrix.setRotate((float)rotate);
        } else {
            matrix.setRotate((float)rotate, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
        }
        try {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            exif.resetOrientation();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUncompressedImage(Uri src, Uri dest) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        OutputStream os = null;
        try {
            int len;
            fis = new FileInputStream(FileHelper.stripFileProtocol(src.toString()));
            os = this.cordova.getActivity().getContentResolver().openOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((len = fis.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            os.flush();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOG.d((String)LOG_TAG, (String)"Exception while closing output stream.");
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.d((String)LOG_TAG, (String)"Exception while closing file input stream.");
                }
            }
        }
    }

    private Uri getUriFromMediaStore() {
        Uri uri;
        ContentValues values = new ContentValues();
        values.put("mime_type", "image/jpeg");
        try {
            uri = this.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        catch (RuntimeException e) {
            LOG.d((String)LOG_TAG, (String)"Can't write to external media storage.");
            try {
                uri = this.cordova.getActivity().getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
            }
            catch (RuntimeException ex) {
                LOG.d((String)LOG_TAG, (String)"Can't write to internal media storage.");
                return null;
            }
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap getScaledBitmap(String imageUrl) throws IOException {
        if (this.targetWidth <= 0 && this.targetHeight <= 0) {
            InputStream fileStream = null;
            Bitmap image = null;
            try {
                fileStream = FileHelper.getInputStreamFromUriString(imageUrl, this.cordova);
                image = BitmapFactory.decodeStream((InputStream)fileStream);
            }
            finally {
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException e) {
                        LOG.d((String)LOG_TAG, (String)"Exception while closing file input stream.");
                    }
                }
            }
            return image;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream fileStream = null;
        try {
            fileStream = FileHelper.getInputStreamFromUriString(imageUrl, this.cordova);
            BitmapFactory.decodeStream((InputStream)fileStream, null, (BitmapFactory.Options)options);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    LOG.d((String)LOG_TAG, (String)"Exception while closing file input stream.");
                }
            }
        }
        if (options.outWidth == 0 || options.outHeight == 0) {
            return null;
        }
        int[] widthHeight = this.calculateAspectRatio(options.outWidth, options.outHeight);
        options.inJustDecodeBounds = false;
        options.inSampleSize = CameraLauncher.calculateSampleSize(options.outWidth, options.outHeight, this.targetWidth, this.targetHeight);
        Bitmap unscaledBitmap = null;
        try {
            fileStream = FileHelper.getInputStreamFromUriString(imageUrl, this.cordova);
            unscaledBitmap = BitmapFactory.decodeStream((InputStream)fileStream, null, (BitmapFactory.Options)options);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    LOG.d((String)LOG_TAG, (String)"Exception while closing file input stream.");
                }
            }
        }
        if (unscaledBitmap == null) {
            return null;
        }
        return Bitmap.createScaledBitmap((Bitmap)unscaledBitmap, (int)widthHeight[0], (int)widthHeight[1], (boolean)true);
    }

    public int[] calculateAspectRatio(int origWidth, int origHeight) {
        int newWidth = this.targetWidth;
        int newHeight = this.targetHeight;
        if (newWidth <= 0 && newHeight <= 0) {
            newWidth = origWidth;
            newHeight = origHeight;
        } else if (newWidth > 0 && newHeight <= 0) {
            newHeight = newWidth * origHeight / origWidth;
        } else if (newWidth <= 0 && newHeight > 0) {
            newWidth = newHeight * origWidth / origHeight;
        } else {
            double origRatio = (double)origWidth / (double)origHeight;
            double newRatio = (double)newWidth / (double)newHeight;
            if (origRatio > newRatio) {
                newHeight = newWidth * origHeight / origWidth;
            } else if (origRatio < newRatio) {
                newWidth = newHeight * origWidth / origHeight;
            }
        }
        int[] retval = new int[]{newWidth, newHeight};
        return retval;
    }

    public static int calculateSampleSize(int srcWidth, int srcHeight, int dstWidth, int dstHeight) {
        float srcAspect = (float)srcWidth / (float)srcHeight;
        float dstAspect = (float)dstWidth / (float)dstHeight;
        if (srcAspect > dstAspect) {
            return srcWidth / dstWidth;
        }
        return srcHeight / dstHeight;
    }

    private Cursor queryImgDB(Uri contentStore) {
        return this.cordova.getActivity().getContentResolver().query(contentStore, new String[]{"_id"}, null, null, null);
    }

    private void cleanup(int imageType, Uri oldImage, Uri newImage, Bitmap bitmap) {
        if (bitmap != null) {
            bitmap.recycle();
        }
        new File(FileHelper.stripFileProtocol(oldImage.toString())).delete();
        this.checkForDuplicateImage(imageType);
        if (this.saveToPhotoAlbum && newImage != null) {
            this.scanForGallery(newImage);
        }
        System.gc();
    }

    private void checkForDuplicateImage(int type) {
        int diff = 1;
        Uri contentStore = this.whichContentStore();
        Cursor cursor = this.queryImgDB(contentStore);
        int currentNumOfImages = cursor.getCount();
        if (type == 1 && this.saveToPhotoAlbum) {
            diff = 2;
        }
        if (currentNumOfImages - this.numPics == diff) {
            cursor.moveToLast();
            int id = Integer.valueOf(cursor.getString(cursor.getColumnIndex("_id")));
            if (diff == 2) {
                --id;
            }
            Uri uri = Uri.parse((String)(contentStore + "/" + id));
            this.cordova.getActivity().getContentResolver().delete(uri, null, null);
            cursor.close();
        }
    }

    private Uri whichContentStore() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        }
        return MediaStore.Images.Media.INTERNAL_CONTENT_URI;
    }

    public void processPicture(Bitmap bitmap, int encodingType) {
        ByteArrayOutputStream jpeg_data = new ByteArrayOutputStream();
        Bitmap.CompressFormat compressFormat = encodingType == 0 ? Bitmap.CompressFormat.JPEG : Bitmap.CompressFormat.PNG;
        try {
            if (bitmap.compress(compressFormat, this.mQuality, (OutputStream)jpeg_data)) {
                byte[] code = jpeg_data.toByteArray();
                byte[] output = Base64.encode((byte[])code, (int)2);
                String js_out = new String(output);
                this.callbackContext.success(js_out);
                js_out = null;
                output = null;
                code = null;
            }
        }
        catch (Exception e) {
            this.failPicture("Error compressing image.");
        }
        jpeg_data = null;
    }

    public void failPicture(String err) {
        this.callbackContext.error(err);
    }

    private void scanForGallery(Uri newImage) {
        this.scanMe = newImage;
        if (this.conn != null) {
            this.conn.disconnect();
        }
        this.conn = new MediaScannerConnection(this.cordova.getActivity().getApplicationContext(), (MediaScannerConnection.MediaScannerConnectionClient)this);
        this.conn.connect();
    }

    public void onMediaScannerConnected() {
        try {
            this.conn.scanFile(this.scanMe.toString(), "image/*");
        }
        catch (IllegalStateException e) {
            LOG.e((String)LOG_TAG, (String)"Can't scan file in MediaScanner after taking picture");
        }
    }

    public void onScanCompleted(String path, Uri uri) {
        this.conn.disconnect();
    }

    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        for (int r : grantResults) {
            if (r != -1) continue;
            this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, 20));
            return;
        }
        switch (requestCode) {
            case 0: {
                this.takePicture(this.destType, this.encodingType);
                break;
            }
            case 1: {
                this.getImage(this.srcType, this.destType, this.encodingType);
            }
        }
    }

    private boolean fileWillBeModified() {
        return this.targetWidth > 0 && this.targetHeight > 0 || this.correctOrientation || this.allowEdit;
    }

    public Bundle onSaveInstanceState() {
        Bundle state = new Bundle();
        state.putInt("destType", this.destType);
        state.putInt("srcType", this.srcType);
        state.putInt("mQuality", this.mQuality);
        state.putInt("targetWidth", this.targetWidth);
        state.putInt("targetHeight", this.targetHeight);
        state.putInt("encodingType", this.encodingType);
        state.putInt("mediaType", this.mediaType);
        state.putInt("numPics", this.numPics);
        state.putBoolean("allowEdit", this.allowEdit);
        state.putBoolean("correctOrientation", this.correctOrientation);
        state.putBoolean("saveToPhotoAlbum", this.saveToPhotoAlbum);
        if (this.croppedUri != null) {
            state.putString("croppedUri", this.croppedUri.toString());
        }
        if (this.imageUri != null) {
            state.putString("imageUri", this.imageUri.toString());
        }
        return state;
    }

    public void onRestoreStateForActivityResult(Bundle state, CallbackContext callbackContext) {
        this.destType = state.getInt("destType");
        this.srcType = state.getInt("srcType");
        this.mQuality = state.getInt("mQuality");
        this.targetWidth = state.getInt("targetWidth");
        this.targetHeight = state.getInt("targetHeight");
        this.encodingType = state.getInt("encodingType");
        this.mediaType = state.getInt("mediaType");
        this.numPics = state.getInt("numPics");
        this.allowEdit = state.getBoolean("allowEdit");
        this.correctOrientation = state.getBoolean("correctOrientation");
        this.saveToPhotoAlbum = state.getBoolean("saveToPhotoAlbum");
        if (state.containsKey("croppedUri")) {
            this.croppedUri = Uri.parse((String)state.getString("croppedUri"));
        }
        if (state.containsKey("imageUri")) {
            this.imageUri = Uri.parse((String)state.getString("imageUri"));
        }
        this.callbackContext = callbackContext;
    }
}

