/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.geolocation;

import android.util.Log;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.apache.cordova.file.PermissionHelper;
import org.json.JSONArray;
import org.json.JSONException;

public class Geolocation
extends CordovaPlugin {
    String TAG = "GeolocationPlugin";
    CallbackContext context;
    String[] permissions = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        Log.d((String)this.TAG, (String)"We are entering execute");
        this.context = callbackContext;
        if (action.equals("getPermission")) {
            if (this.hasPermisssion()) {
                PluginResult r = new PluginResult(PluginResult.Status.OK);
                this.context.sendPluginResult(r);
                return true;
            }
            PermissionHelper.requestPermissions(this, 0, this.permissions);
            return true;
        }
        return false;
    }

    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        if (this.context != null) {
            for (int r : grantResults) {
                if (r != -1) continue;
                LOG.d((String)this.TAG, (String)"Permission Denied!");
                PluginResult result = new PluginResult(PluginResult.Status.ILLEGAL_ACCESS_EXCEPTION);
                this.context.sendPluginResult(result);
                return;
            }
            PluginResult result = new PluginResult(PluginResult.Status.OK);
            this.context.sendPluginResult(result);
        }
    }

    public boolean hasPermisssion() {
        for (String p : this.permissions) {
            if (PermissionHelper.hasPermission(this, p)) continue;
            return false;
        }
        return true;
    }

    public void requestPermissions(int requestCode) {
        PermissionHelper.requestPermissions(this, requestCode, this.permissions);
    }
}

