/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.file;

import android.content.res.AssetManager;
import android.net.Uri;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.file.EncodingException;
import org.apache.cordova.file.FileExistsException;
import org.apache.cordova.file.Filesystem;
import org.apache.cordova.file.InvalidModificationException;
import org.apache.cordova.file.LocalFilesystemURL;
import org.apache.cordova.file.NoModificationAllowedException;
import org.apache.cordova.file.TypeMismatchException;
import org.json.JSONException;
import org.json.JSONObject;

public class AssetFilesystem
extends Filesystem {
    private final AssetManager assetManager;
    private static Object listCacheLock = new Object();
    private static boolean listCacheFromFile;
    private static Map<String, String[]> listCache;
    private static Map<String, Long> lengthCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitCaches() {
        Object object = listCacheLock;
        synchronized (object) {
            if (listCache == null) {
                ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream(this.assetManager.open("cdvasset.manifest"));
                    listCache = (Map)ois.readObject();
                    lengthCache = (Map)ois.readObject();
                    listCacheFromFile = true;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException iOException) {
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (listCache == null) {
                    Log.w((String)"AssetFilesystem", (String)"Asset manifest not found. Recursive copies and directory listing will be slow.");
                    listCache = new HashMap<String, String[]>();
                }
            }
        }
    }

    private String[] listAssets(String assetPath) throws IOException {
        if (assetPath.startsWith("/")) {
            assetPath = assetPath.substring(1);
        }
        if (assetPath.endsWith("/")) {
            assetPath = assetPath.substring(0, assetPath.length() - 1);
        }
        this.lazyInitCaches();
        String[] ret = listCache.get(assetPath);
        if (ret == null) {
            if (listCacheFromFile) {
                ret = new String[]{};
            } else {
                ret = this.assetManager.list(assetPath);
                listCache.put(assetPath, ret);
            }
        }
        return ret;
    }

    private long getAssetSize(String assetPath) throws FileNotFoundException {
        if (assetPath.startsWith("/")) {
            assetPath = assetPath.substring(1);
        }
        this.lazyInitCaches();
        if (lengthCache != null) {
            Long ret = lengthCache.get(assetPath);
            if (ret == null) {
                throw new FileNotFoundException("Asset not found: " + assetPath);
            }
            return ret;
        }
        CordovaResourceApi.OpenForReadResult offr = null;
        try {
            offr = this.resourceApi.openForRead(this.nativeUriForFullPath(assetPath));
            long length = offr.length;
            if (length < 0L) {
                length = offr.inputStream.available();
            }
            long l = length;
            return l;
        }
        catch (IOException e) {
            throw new FileNotFoundException("File not found: " + assetPath);
        }
        finally {
            if (offr != null) {
                try {
                    offr.inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public AssetFilesystem(AssetManager assetManager, CordovaResourceApi resourceApi) {
        super(Uri.parse((String)"file:///android_asset/"), "assets", resourceApi);
        this.assetManager = assetManager;
    }

    @Override
    public Uri toNativeUri(LocalFilesystemURL inputURL) {
        return this.nativeUriForFullPath(inputURL.path);
    }

    @Override
    public LocalFilesystemURL toLocalUri(Uri inputURL) {
        if (!"file".equals(inputURL.getScheme())) {
            return null;
        }
        File f = new File(inputURL.getPath());
        Uri resolvedUri = Uri.fromFile((File)f);
        String rootUriNoTrailingSlash = this.rootUri.getEncodedPath();
        rootUriNoTrailingSlash = rootUriNoTrailingSlash.substring(0, rootUriNoTrailingSlash.length() - 1);
        if (!resolvedUri.getEncodedPath().startsWith(rootUriNoTrailingSlash)) {
            return null;
        }
        String subPath = resolvedUri.getEncodedPath().substring(rootUriNoTrailingSlash.length());
        if (!subPath.isEmpty()) {
            subPath = subPath.substring(1);
        }
        Uri.Builder b = new Uri.Builder().scheme("cdvfile").authority("localhost").path(this.name);
        if (!subPath.isEmpty()) {
            b.appendEncodedPath(subPath);
        }
        if (this.isDirectory(subPath) || inputURL.getPath().endsWith("/")) {
            b.appendEncodedPath("");
        }
        return LocalFilesystemURL.parse(b.build());
    }

    private boolean isDirectory(String assetPath) {
        try {
            return this.listAssets(assetPath).length != 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public LocalFilesystemURL[] listChildren(LocalFilesystemURL inputURL) throws FileNotFoundException {
        String[] files;
        String pathNoSlashes = inputURL.path.substring(1);
        if (pathNoSlashes.endsWith("/")) {
            pathNoSlashes = pathNoSlashes.substring(0, pathNoSlashes.length() - 1);
        }
        try {
            files = this.listAssets(pathNoSlashes);
        }
        catch (IOException e) {
            throw new FileNotFoundException();
        }
        LocalFilesystemURL[] entries = new LocalFilesystemURL[files.length];
        for (int i = 0; i < files.length; ++i) {
            entries[i] = this.localUrlforFullPath(new File(inputURL.path, files[i]).getPath());
        }
        return entries;
    }

    @Override
    public JSONObject getFileForLocalURL(LocalFilesystemURL inputURL, String path, JSONObject options, boolean directory) throws FileExistsException, IOException, TypeMismatchException, EncodingException, JSONException {
        if (options != null && options.optBoolean("create")) {
            throw new UnsupportedOperationException("Assets are read-only");
        }
        if (directory && !path.endsWith("/")) {
            path = path + "/";
        }
        LocalFilesystemURL requestedURL = path.startsWith("/") ? this.localUrlforFullPath(AssetFilesystem.normalizePath(path)) : this.localUrlforFullPath(AssetFilesystem.normalizePath(inputURL.path + "/" + path));
        this.getFileMetadataForLocalURL(requestedURL);
        boolean isDir = this.isDirectory(requestedURL.path);
        if (directory && !isDir) {
            throw new TypeMismatchException("path doesn't exist or is file");
        }
        if (!directory && isDir) {
            throw new TypeMismatchException("path doesn't exist or is directory");
        }
        return this.makeEntryForURL(requestedURL);
    }

    @Override
    public JSONObject getFileMetadataForLocalURL(LocalFilesystemURL inputURL) throws FileNotFoundException {
        JSONObject metadata = new JSONObject();
        long size = inputURL.isDirectory ? 0L : this.getAssetSize(inputURL.path);
        try {
            metadata.put("size", size);
            metadata.put("type", (Object)(inputURL.isDirectory ? "text/directory" : this.resourceApi.getMimeType(this.toNativeUri(inputURL))));
            metadata.put("name", (Object)new File(inputURL.path).getName());
            metadata.put("fullPath", (Object)inputURL.path);
            metadata.put("lastModifiedDate", 0);
        }
        catch (JSONException e) {
            return null;
        }
        return metadata;
    }

    @Override
    public boolean canRemoveFileAtLocalURL(LocalFilesystemURL inputURL) {
        return false;
    }

    @Override
    long writeToFileAtURL(LocalFilesystemURL inputURL, String data, int offset, boolean isBinary) throws NoModificationAllowedException, IOException {
        throw new NoModificationAllowedException("Assets are read-only");
    }

    @Override
    long truncateFileAtURL(LocalFilesystemURL inputURL, long size) throws IOException, NoModificationAllowedException {
        throw new NoModificationAllowedException("Assets are read-only");
    }

    @Override
    String filesystemPathForURL(LocalFilesystemURL url) {
        return null;
    }

    @Override
    LocalFilesystemURL URLforFilesystemPath(String path) {
        return null;
    }

    @Override
    boolean removeFileAtLocalURL(LocalFilesystemURL inputURL) throws InvalidModificationException, NoModificationAllowedException {
        throw new NoModificationAllowedException("Assets are read-only");
    }

    @Override
    boolean recursiveRemoveFileAtLocalURL(LocalFilesystemURL inputURL) throws NoModificationAllowedException {
        throw new NoModificationAllowedException("Assets are read-only");
    }
}

