/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.beatop.btopusercenter.R;

public class CustomDialog
extends Dialog {
    public CustomDialog(Context context) {
        super(context);
    }

    public CustomDialog(Context context, int theme) {
        super(context, theme);
    }

    public static class Builder {
        private Context context;
        private String title;
        private String message;
        private String positiveButtonText;
        private String negativeButtonText;
        private View contentView;
        private DialogInterface.OnClickListener positiveButtonClickListener;
        private DialogInterface.OnClickListener negativeButtonClickListener;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(int message) {
            this.message = (String)this.context.getText(message);
            return this;
        }

        public Builder setTitle(int title) {
            this.title = (String)this.context.getText(title);
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setContentView(View v) {
            this.contentView = v;
            return this;
        }

        public Builder setPositiveButton(int positiveButtonText, DialogInterface.OnClickListener listener) {
            this.positiveButtonText = (String)this.context.getText(positiveButtonText);
            this.positiveButtonClickListener = listener;
            return this;
        }

        public Builder setPositiveButton(String positiveButtonText, DialogInterface.OnClickListener listener) {
            this.positiveButtonText = positiveButtonText;
            this.positiveButtonClickListener = listener;
            return this;
        }

        public Builder setNegativeButton(int negativeButtonText, DialogInterface.OnClickListener listener) {
            this.negativeButtonText = (String)this.context.getText(negativeButtonText);
            this.negativeButtonClickListener = listener;
            return this;
        }

        public Builder setNegativeButton(String negativeButtonText, DialogInterface.OnClickListener listener) {
            this.negativeButtonText = negativeButtonText;
            this.negativeButtonClickListener = listener;
            return this;
        }

        public CustomDialog create() {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            View view = inflater.inflate(R.layout.btuser_dialog_confirm_logout, null);
            View divider_v = view.findViewById(R.id.view_divider);
            final CustomDialog dialog = new CustomDialog(this.context, R.style.Dialog);
            dialog.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
            if (!TextUtils.isEmpty((CharSequence)this.message)) {
                TextView msg = (TextView)view.findViewById(R.id.tv_alert_note);
                msg.setText((CharSequence)this.message);
            }
            if (!TextUtils.isEmpty((CharSequence)this.positiveButtonText)) {
                TextView positive = (TextView)view.findViewById(R.id.tv_confirm);
                positive.setText((CharSequence)this.positiveButtonText);
                if (this.positiveButtonClickListener != null) {
                    positive.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Builder.this.positiveButtonClickListener.onClick((DialogInterface)dialog, -1);
                        }
                    });
                } else {
                    positive.setVisibility(8);
                    divider_v.setVisibility(8);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)this.negativeButtonText)) {
                TextView negative = (TextView)view.findViewById(R.id.tv_cancel);
                negative.setText((CharSequence)this.negativeButtonText);
                if (this.negativeButtonClickListener != null) {
                    negative.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Builder.this.negativeButtonClickListener.onClick((DialogInterface)dialog, -2);
                        }
                    });
                }
            }
            return dialog;
        }
    }
}

