/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.OnChildActivityResult;
import com.beatop.btopbase.utils.Router;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopbase.view.CircleImageView;
import com.beatop.btopusercenter.R;
import com.beatop.btopusercenter.ui.BTFeedbackActivity;
import com.beatop.btopusercenter.ui.BTSecurityActivity;
import com.beatop.btopusercenter.ui.BTSettingActivity;
import com.beatop.btopusercenter.ui.BTUserInfoActivity;

public class BTUserCenterActivity
extends BTBaseActivity
implements View.OnClickListener,
OnChildActivityResult {
    private LinearLayout userPhoto;
    private CircleImageView userPhotoCircleIv;
    private TextView userNameTv;
    private RelativeLayout orderList;
    private TextView orderListTv;
    private RelativeLayout accountSafe;
    private TextView accountSafeTv;
    private RelativeLayout feedback;
    private TextView feedbackTv;
    private RelativeLayout setting;
    private TextView settingTv;
    private boolean isLogin;
    private String loginNote;
    public static final String STATUS_UPDATE = "com.beatop.usercenter.status.update";
    public final int USER_INFO_LOGIN = 31;
    public final int ORDER_INFO_LOGIN = 32;
    public final int SECURITY_INFO_LOGIN = 33;
    private BroadcastReceiver receiver;
    private Activity context;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btuser_activity_usercenter);
        this.isLogin = SPHelper.isLogin();
        this.context = this.getParent() != null ? this.getParent() : this;
        this.initView();
        this.receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals(BTUserCenterActivity.STATUS_UPDATE)) {
                    BTUserCenterActivity.this.setUserInfo();
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction(STATUS_UPDATE);
        this.registerReceiver(this.receiver, filter);
    }

    protected void onLanguageChanged() {
        this.setText();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.receiver);
    }

    private void findView() {
        this.userPhoto = (LinearLayout)this.findViewById(R.id.user_info);
        this.userPhoto.setOnClickListener((View.OnClickListener)this);
        this.userNameTv = (TextView)this.findViewById(R.id.tv_user_name);
        this.userPhotoCircleIv = (CircleImageView)this.findViewById(R.id.iv_user_photo);
        this.orderList = (RelativeLayout)this.findViewById(R.id.booking_list);
        this.orderList.setOnClickListener((View.OnClickListener)this);
        this.orderListTv = (TextView)this.findViewById(R.id.tv_booking_list);
        this.accountSafe = (RelativeLayout)this.findViewById(R.id.account_safe);
        this.accountSafe.setOnClickListener((View.OnClickListener)this);
        this.accountSafeTv = (TextView)this.findViewById(R.id.tv_account_safe);
        this.feedback = (RelativeLayout)this.findViewById(R.id.feed_back);
        this.feedback.setOnClickListener((View.OnClickListener)this);
        this.feedbackTv = (TextView)this.findViewById(R.id.tv_feed_back);
        this.setting = (RelativeLayout)this.findViewById(R.id.app_setting);
        this.setting.setOnClickListener((View.OnClickListener)this);
        this.settingTv = (TextView)this.findViewById(R.id.tv_app_setting);
    }

    private void initView() {
        this.findView();
        this.setText();
        this.setUserInfo();
    }

    private void setText() {
        if (this.isZh) {
            this.loginNote = this.resources.getString(R.string.btuser_user_login_zh);
            this.orderListTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_orders_zh));
            this.accountSafeTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_safe_zh));
            this.feedbackTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_feedback_zh));
            this.settingTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_setting_zh));
        } else {
            this.loginNote = this.resources.getString(R.string.btuser_user_login_en);
            this.orderListTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_orders_en));
            this.accountSafeTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_safe_en));
            this.feedbackTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_feedback_en));
            this.settingTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_setting_en));
        }
        if (!this.isLogin) {
            this.userNameTv.setText((CharSequence)this.loginNote);
        }
    }

    private void setUserInfo() {
        userInfo = SPHelper.getUserInfo();
        this.isLogin = SPHelper.isLogin();
        if (!this.isLogin) {
            this.userPhotoCircleIv.setImageResource(R.mipmap.btbase_user_photo);
            this.userNameTv.setText((CharSequence)this.loginNote);
        } else {
            if (userInfo.getProfile() != null && !TextUtils.isEmpty((CharSequence)userInfo.getProfile().getAvatar())) {
                imageLoader.displayImage(userInfo.getProfile().getAvatar(), (ImageView)this.userPhotoCircleIv, options);
                Log.e((String)this.TAG, (String)("setUserInfo: " + userInfo.getProfile().getAvatar()));
            } else {
                this.userPhotoCircleIv.setImageResource(R.mipmap.btbase_user_photo);
            }
            if (!TextUtils.isEmpty((CharSequence)userInfo.getNickname())) {
                this.userNameTv.setText((CharSequence)userInfo.getNickname());
            } else {
                this.userNameTv.setText((CharSequence)userInfo.getMobile());
            }
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.user_info) {
            if (this.isLogin) {
                Intent it = new Intent((Context)this, BTUserInfoActivity.class);
                this.startActivity(it);
            } else {
                Router.sharedRouter().openForResult("btop://login/btlogin", 31, this.context);
            }
        } else if (id2 == R.id.booking_list) {
            if (this.isLogin) {
                Bundle bundle = new Bundle();
                bundle.putString("url", String.format(ORDER_URL, userInfo.get_Akey(), SPHelper.getLanguageSetting()));
                Router.sharedRouter().open("btop://web/btTitleWebActivity", bundle);
            } else {
                Router.sharedRouter().openForResult("btop://login/btlogin", 32, this.context);
            }
        } else if (id2 == R.id.account_safe) {
            if (this.isLogin) {
                Intent it = new Intent((Context)this, BTSecurityActivity.class);
                this.startActivity(it);
            } else {
                Router.sharedRouter().openForResult("btop://login/btlogin", 33, this.context);
            }
        } else if (id2 == R.id.feed_back) {
            Intent it = new Intent((Context)this, BTFeedbackActivity.class);
            this.startActivity(it);
        } else if (id2 == R.id.app_setting) {
            Intent it = new Intent((Context)this, BTSettingActivity.class);
            this.startActivity(it);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            this.isLogin = SPHelper.isLogin();
            this.setUserInfo();
            switch (requestCode) {
                case 31: {
                    break;
                }
                case 32: {
                    break;
                }
                case 33: {
                    break;
                }
            }
        }
    }

    public void onChildActivityResult(int requestCode, int resultCode, Intent data) {
        this.onActivityResult(requestCode, resultCode, data);
    }
}

