/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.webkit.CookieManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.LogoutResultEntity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopbase.utils.Router;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopusercenter.R;
import com.beatop.btopusercenter.ui.BTChangeLanguageActivity;
import com.beatop.btopusercenter.ui.CustomDialog;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTSettingActivity
extends BTBaseActivity {
    private TextView title;
    private ImageView back;
    private RelativeLayout setLanguage;
    private TextView languageKeyTv;
    private TextView languageValueTv;
    private RelativeLayout privacy;
    private TextView privacyKeyTv;
    private RelativeLayout aboutUs;
    private TextView aboutUsKeyTv;
    private TextView logoutTv;
    private String logoutSuccessNote;
    private String confirm;
    private String cancel;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btuser_activity_setting);
        this.initView();
    }

    private void initView() {
        this.title = (TextView)this.findViewById(R.id.title);
        this.back = (ImageView)this.findViewById(R.id.back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTSettingActivity.this.onBackPressed();
            }
        });
        this.setLanguage = (RelativeLayout)this.findViewById(R.id.app_language);
        this.setLanguage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent it = new Intent((Context)BTSettingActivity.this, BTChangeLanguageActivity.class);
                BTSettingActivity.this.startActivity(it);
            }
        });
        this.languageKeyTv = (TextView)this.findViewById(R.id.tv_app_language_key);
        this.languageValueTv = (TextView)this.findViewById(R.id.tv_app_language_value);
        this.privacy = (RelativeLayout)this.findViewById(R.id.app_private);
        this.privacy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = new Bundle();
                if (BTSettingActivity.this.isZh) {
                    bundle.putString("url", String.format(BTBaseActivity.PRIVACY_URL, "zh"));
                    bundle.putString("title", BTSettingActivity.this.resources.getString(R.string.btuser_setting_privacy_zh));
                } else {
                    bundle.putString("url", String.format(BTBaseActivity.PRIVACY_URL, "en"));
                    bundle.putString("title", BTSettingActivity.this.resources.getString(R.string.btuser_setting_privacy_en));
                }
                Router.sharedRouter().open("btop://web/btTitleWebActivity", bundle);
            }
        });
        this.privacyKeyTv = (TextView)this.findViewById(R.id.tv_app_private_key);
        this.aboutUs = (RelativeLayout)this.findViewById(R.id.app_about_us);
        this.aboutUs.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = new Bundle();
                if (BTSettingActivity.this.isZh) {
                    bundle.putString("url", String.format(BTBaseActivity.ABOUT_US_URL, "zh"));
                    bundle.putString("title", BTSettingActivity.this.resources.getString(R.string.btuser_setting_about_zh));
                } else {
                    bundle.putString("url", String.format(BTBaseActivity.ABOUT_US_URL, "en"));
                    bundle.putString("title", BTSettingActivity.this.resources.getString(R.string.btuser_setting_about_en));
                }
                Router.sharedRouter().open("btop://web/btTitleWebActivity", bundle);
            }
        });
        this.aboutUsKeyTv = (TextView)this.findViewById(R.id.tv_app_about_us_key);
        this.logoutTv = (TextView)this.findViewById(R.id.tv_logout);
        if (!SPHelper.isLogin()) {
            this.logoutTv.setVisibility(8);
        }
        this.logoutTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTSettingActivity.this.showAlertDialog();
            }
        });
        this.setText();
    }

    private void setText() {
        if (this.isZh) {
            this.title.setText((CharSequence)this.resources.getString(R.string.btuser_setting_title_zh));
            this.languageKeyTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_language_key_zh));
            this.languageValueTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_language_value_zh));
            this.privacyKeyTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_privacy_zh));
            this.aboutUsKeyTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_about_zh));
            this.logoutTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_logout_zh));
            this.logoutSuccessNote = this.resources.getString(R.string.btuser_setting_logout_success_note_zh);
            this.confirm = this.resources.getString(R.string.btuser_confirm_zh);
            this.cancel = this.resources.getString(R.string.btuser_cancel_zh);
        } else {
            this.title.setText((CharSequence)this.resources.getString(R.string.btuser_setting_title_en));
            this.languageKeyTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_language_key_en));
            this.languageValueTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_language_value_en));
            this.privacyKeyTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_privacy_en));
            this.aboutUsKeyTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_about_en));
            this.logoutTv.setText((CharSequence)this.resources.getString(R.string.btuser_setting_logout_en));
            this.logoutSuccessNote = this.resources.getString(R.string.btuser_setting_logout_success_note_en);
            this.confirm = this.resources.getString(R.string.btuser_confirm_en);
            this.cancel = this.resources.getString(R.string.btuser_cancel_en);
        }
    }

    private void logout(final DialogInterface dialog) {
        netWorkServer.logout(userInfo.get_Akey()).enqueue((Callback)new Callback<LogoutResultEntity>(){

            public void onResponse(Call<LogoutResultEntity> call, Response<LogoutResultEntity> response) {
                if (((LogoutResultEntity)response.body()).getError() != null) {
                    BTSettingActivity.this.showMsg(((LogoutResultEntity)response.body()).getError().getMessage());
                } else {
                    SPHelper.saveLoginStatus((boolean)false);
                    SPHelper.saveUserInfo((UserInfoEntity)new UserInfoEntity());
                    BTSettingActivity.this.showMsg(BTSettingActivity.this.logoutSuccessNote);
                    Intent intent = new Intent();
                    intent.setAction("com.beatop.usercenter.status.update");
                    BTSettingActivity.this.sendBroadcast(intent);
                    BTSettingActivity.this.logoutTv.setVisibility(8);
                    CookieManager.getInstance().removeAllCookie();
                    dialog.dismiss();
                }
            }

            public void onFailure(Call<LogoutResultEntity> call, Throwable t) {
                BTSettingActivity.this.showMsg(BTSettingActivity.this.netErrorNote);
            }
        });
    }

    protected void onLanguageChanged() {
        this.setText();
    }

    private void showAlertDialog() {
        CustomDialog.Builder builder = new CustomDialog.Builder((Context)this).setMessage(this.logoutTv.getText().toString()).setTitle(null).setNegativeButton(this.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setPositiveButton(this.confirm, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                BTSettingActivity.this.logout(dialog);
            }
        });
        builder.create().show();
    }
}

