/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.os.Bundle;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.FeedbackResultEntity;
import com.beatop.btopbase.utils.StringHelper;
import com.beatop.btopusercenter.R;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTFeedbackActivity
extends BTBaseActivity {
    private ImageView back;
    private TextView title;
    private RadioButton problemRb;
    private RadioButton suggestionRb;
    private RadioButton codeErrorRb;
    private RadioButton selectedRb;
    private EditText suggestionEt;
    private ImageView uploadPicIv;
    private TextView suggestTextCountTv;
    private EditText contactEt;
    private TextView submitTv;
    private final String PROBLEM_TYPE = "problem";
    private final String SUGGEST_TYPE = "sugg";
    private final String CODE_ERROR_TYPE = "error";
    private int textCount = 0;
    private final int MAX_SUGGEST_TEXT = 200;
    private CharSequence temp;
    private String successNote;
    private String typeEmptyNote;
    private String suggestionEmptyNote;
    private String contactEmptyNote;
    private String contactErrorNote;
    private String suggestionTooLongNote;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btuser_activity_feedback);
        this.initView();
    }

    private void initView() {
        this.back = (ImageView)this.findViewById(R.id.back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTFeedbackActivity.this.onBackPressed();
            }
        });
        this.title = (TextView)this.findViewById(R.id.title);
        this.problemRb = (RadioButton)this.findViewById(R.id.rb_use_problem);
        this.problemRb.setTag((Object)"problem");
        this.problemRb.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTFeedbackActivity.this.selectedRb = null;
                if (BTFeedbackActivity.this.problemRb.isChecked()) {
                    BTFeedbackActivity.this.selectedRb = BTFeedbackActivity.this.problemRb;
                }
            }
        });
        this.suggestionRb = (RadioButton)this.findViewById(R.id.rb_suggestion);
        this.suggestionRb.setTag((Object)"sugg");
        this.suggestionRb.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTFeedbackActivity.this.selectedRb = null;
                if (BTFeedbackActivity.this.suggestionRb.isChecked()) {
                    BTFeedbackActivity.this.selectedRb = BTFeedbackActivity.this.suggestionRb;
                }
            }
        });
        this.codeErrorRb = (RadioButton)this.findViewById(R.id.rb_code_error);
        this.codeErrorRb.setTag((Object)"error");
        this.codeErrorRb.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTFeedbackActivity.this.selectedRb = null;
                if (BTFeedbackActivity.this.codeErrorRb.isChecked()) {
                    BTFeedbackActivity.this.selectedRb = BTFeedbackActivity.this.codeErrorRb;
                }
            }
        });
        this.suggestionEt = (EditText)this.findViewById(R.id.et_suggest);
        this.suggestionEt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                BTFeedbackActivity.this.temp = s;
            }

            public void afterTextChanged(Editable s) {
                BTFeedbackActivity.this.textCount = s.toString().length();
                if (BTFeedbackActivity.this.textCount > 200) {
                    BTFeedbackActivity.this.suggestionEt.setText(BTFeedbackActivity.this.temp);
                    BTFeedbackActivity.this.textCount = BTFeedbackActivity.this.temp.length();
                    Editable text = BTFeedbackActivity.this.suggestionEt.getText();
                    if (text instanceof Spannable) {
                        Spannable spannable = (Spannable)text;
                        Selection.setSelection((Spannable)spannable, (int)text.length());
                    }
                }
                BTFeedbackActivity.this.suggestTextCountTv.setText((CharSequence)String.format("%1$d/%2$d", BTFeedbackActivity.this.textCount, 200));
            }
        });
        this.suggestTextCountTv = (TextView)this.findViewById(R.id.tv_suggest_count);
        this.uploadPicIv = (ImageView)this.findViewById(R.id.iv_pic_upload);
        this.uploadPicIv.setVisibility(4);
        this.submitTv = (TextView)this.findViewById(R.id.tv_submit);
        this.submitTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTFeedbackActivity.this.feedback();
            }
        });
        this.contactEt = (EditText)this.findViewById(R.id.et_contact);
        this.setText();
    }

    private void setText() {
        if (this.isZh) {
            this.title.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_title_zh));
            this.problemRb.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_question_zh));
            this.suggestionRb.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_suggest_zh));
            this.codeErrorRb.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_crash_zh));
            this.suggestionEt.setHint(R.string.btuser_feedback_hint_zh);
            this.contactEt.setHint(R.string.btuser_feedback_contact_hint_zh);
            this.submitTv.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_submit_zh));
            this.successNote = this.resources.getString(R.string.btuser_feedback_success_note_zh);
            this.typeEmptyNote = this.resources.getString(R.string.btuser_feedback_type_empty_note_zh);
            this.suggestionEmptyNote = this.resources.getString(R.string.btuser_feedback_sug_empty_note_zh);
            this.contactEmptyNote = this.resources.getString(R.string.btuser_feedback_contact_empty_note_zh);
            this.contactErrorNote = this.resources.getString(R.string.btuser_feedback_contact_error_note_zh);
            this.uploadPicIv.setImageResource(R.mipmap.btbase_upload_pic_zh);
        } else {
            this.title.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_title_en));
            this.problemRb.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_question_en));
            this.suggestionRb.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_suggest_en));
            this.codeErrorRb.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_crash_en));
            this.suggestionEt.setHint(R.string.btuser_feedback_hint_en);
            this.contactEt.setHint(R.string.btuser_feedback_contact_hint_en);
            this.submitTv.setText((CharSequence)this.resources.getString(R.string.btuser_feedback_submit_en));
            this.successNote = this.resources.getString(R.string.btuser_feedback_success_note_en);
            this.typeEmptyNote = this.resources.getString(R.string.btuser_feedback_type_empty_note_en);
            this.suggestionEmptyNote = this.resources.getString(R.string.btuser_feedback_sug_empty_note_en);
            this.contactEmptyNote = this.resources.getString(R.string.btuser_feedback_contact_empty_note_en);
            this.contactErrorNote = this.resources.getString(R.string.btuser_feedback_contact_error_note_en);
            this.uploadPicIv.setImageResource(R.mipmap.btbase_upload_pic_en);
        }
    }

    private void feedback() {
        if (this.selectedRb == null) {
            this.showMsg(this.typeEmptyNote);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.suggestionEt.getText().toString())) {
            this.showMsg(this.suggestionEmptyNote);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.contactEt.getText().toString())) {
            this.showMsg(this.contactEmptyNote);
            return;
        }
        if (!StringHelper.checkMobile((String)userInfo.getArea_code(), (String)this.contactEt.getText().toString()) && !StringHelper.checkEmail((String)this.contactEt.getText().toString())) {
            this.showMsg(this.contactErrorNote);
            return;
        }
        netWorkServer.feedback(this.contactEt.getText().toString(), (String)this.selectedRb.getTag(), this.suggestionEt.getText().toString(), null).enqueue((Callback)new Callback<FeedbackResultEntity>(){

            public void onResponse(Call<FeedbackResultEntity> call, Response<FeedbackResultEntity> response) {
                if (((FeedbackResultEntity)response.body()).getError() != null) {
                    BTFeedbackActivity.this.showMsg(((FeedbackResultEntity)response.body()).getError().getMessage());
                } else {
                    BTFeedbackActivity.this.showMsg(BTFeedbackActivity.this.successNote);
                }
            }

            public void onFailure(Call<FeedbackResultEntity> call, Throwable t) {
                BTFeedbackActivity.this.showMsg(BTFeedbackActivity.this.netErrorNote);
            }
        });
    }

    protected void onLanguageChanged() {
        this.setText();
    }
}

