/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopusercenter.R;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTEditNameActivity
extends BTBaseActivity {
    private TextView cancelTv;
    private TextView title;
    private TextView saveTv;
    private EditText nickNameEt;
    private String errorNote;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btuser_edit_activity);
        this.initView();
    }

    private void initView() {
        this.cancelTv = (TextView)this.findViewById(R.id.tv_cancel);
        this.cancelTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTEditNameActivity.this.onBackPressed();
            }
        });
        this.title = (TextView)this.findViewById(R.id.title);
        this.saveTv = (TextView)this.findViewById(R.id.tv_save);
        this.saveTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TextUtils.isEmpty((CharSequence)BTEditNameActivity.this.nickNameEt.getText().toString())) {
                    Toast.makeText((Context)BTEditNameActivity.this, (CharSequence)BTEditNameActivity.this.errorNote, (int)0).show();
                } else {
                    netWorkServer.updateUserInfo(userInfo.get_Akey(), BTEditNameActivity.this.nickNameEt.getText().toString(), userInfo.getGender(), userInfo.getBirthday(), userInfo.getProfile().getAvatar()).enqueue((Callback)new Callback<UserInfoEntity>(){

                        public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                            if (((UserInfoEntity)response.body()).getError() != null) {
                                BTEditNameActivity.this.showMsg(((UserInfoEntity)response.body()).getError().getMessage());
                            } else {
                                userInfo.setNickname(BTEditNameActivity.this.nickNameEt.getText().toString());
                                SPHelper.saveUserInfo((UserInfoEntity)userInfo);
                                Intent intent = new Intent();
                                intent.setAction("com.beatop.usercenter.status.update");
                                BTEditNameActivity.this.sendBroadcast(intent);
                                Intent it = new Intent();
                                it.putExtra("nickname", BTEditNameActivity.this.nickNameEt.getText().toString());
                                BTEditNameActivity.this.setResult(-1, it);
                                BTEditNameActivity.this.finish();
                            }
                        }

                        public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                            BTEditNameActivity.this.showMsg(BTEditNameActivity.this.netErrorNote);
                        }
                    });
                }
            }
        });
        this.nickNameEt = (EditText)this.findViewById(R.id.et_nickname);
        this.setText();
    }

    private void setText() {
        if (this.isZh) {
            this.title.setText((CharSequence)this.resources.getString(R.string.btuser_edit_title_zh));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_zh));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_zh));
            this.nickNameEt.setHint(R.string.btuser_edit_note_zh);
            this.errorNote = this.resources.getString(R.string.btuser_edit_error_note_zh);
        } else {
            this.title.setText((CharSequence)this.resources.getString(R.string.btuser_edit_title_en));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_en));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_en));
            this.nickNameEt.setHint(R.string.btuser_edit_note_en);
            this.errorNote = this.resources.getString(R.string.btuser_edit_error_note_en);
        }
    }

    protected void onLanguageChanged() {
        this.setText();
    }
}

