package com.beatop.btopusercenter.ui;

import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.webkit.CookieManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.LogoutResultEntity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopbase.utils.Router;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopusercenter.R;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Administrator on 2016/9/29.
 */
public class BTSettingActivity extends BTBaseActivity {

    private TextView title;
    private ImageView back;
    private RelativeLayout setLanguage;
    private TextView languageKeyTv;
    private TextView languageValueTv;


    private RelativeLayout privacy;
    private TextView privacyKeyTv;


    private RelativeLayout aboutUs;
    private TextView aboutUsKeyTv;


    private TextView logoutTv;
    private String logoutSuccessNote;

    private String confirm;
    private String cancel;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_activity_setting);
        initView();
    }

    private void initView() {
        title = (TextView) findViewById(R.id.title);
        back = (ImageView) findViewById(R.id.back);
        back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });

        setLanguage = (RelativeLayout) findViewById(R.id.app_language);
        setLanguage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent it = new Intent(BTSettingActivity.this, BTChangeLanguageActivity.class);
                startActivity(it);
            }
        });
        languageKeyTv = (TextView) findViewById(R.id.tv_app_language_key);
        languageValueTv = (TextView) findViewById(R.id.tv_app_language_value);

        privacy = (RelativeLayout) findViewById(R.id.app_private);
        privacy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Bundle bundle = new Bundle();
                if (isZh) {
                    bundle.putString("url", String.format(PRIVACY_URL, "zh"));
                    bundle.putString("title", resources.getString(R.string.btuser_setting_privacy_zh));
                } else {
                    bundle.putString("url", String.format(PRIVACY_URL, "en"));
                    bundle.putString("title", resources.getString(R.string.btuser_setting_privacy_en));
                }
                Router.sharedRouter().open("btop://web/btTitleWebActivity", bundle);
            }
        });
        privacyKeyTv = (TextView) findViewById(R.id.tv_app_private_key);

        aboutUs = (RelativeLayout) findViewById(R.id.app_about_us);
        aboutUs.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Bundle bundle = new Bundle();
                if (isZh) {
                    bundle.putString("url", String.format(ABOUT_US_URL, "zh"));
                    bundle.putString("title", resources.getString(R.string.btuser_setting_about_zh));
                } else {
                    bundle.putString("url", String.format(ABOUT_US_URL, "en"));
                    bundle.putString("title", resources.getString(R.string.btuser_setting_about_en));
                }
                Router.sharedRouter().open("btop://web/btTitleWebActivity", bundle);
            }
        });
        aboutUsKeyTv = (TextView) findViewById(R.id.tv_app_about_us_key);

        logoutTv = (TextView) findViewById(R.id.tv_logout);
        if (!SPHelper.isLogin()) {
            logoutTv.setVisibility(View.GONE);
        }
        logoutTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showAlertDialog();
            }
        });
        setText();
    }

    private void setText() {

        if (isZh) {
            title.setText(resources.getString(R.string.btuser_setting_title_zh));
            languageKeyTv.setText(resources.getString(R.string.btuser_setting_language_key_zh));
            languageValueTv.setText(resources.getString(R.string.btuser_setting_language_value_zh));
            privacyKeyTv.setText(resources.getString(R.string.btuser_setting_privacy_zh));
            aboutUsKeyTv.setText(resources.getString(R.string.btuser_setting_about_zh));
            logoutTv.setText(resources.getString(R.string.btuser_setting_logout_zh));
            logoutSuccessNote = resources.getString(R.string.btuser_setting_logout_success_note_zh);
            confirm = resources.getString(R.string.btuser_confirm_zh);
            cancel = resources.getString(R.string.btuser_cancel_zh);

        } else {
            title.setText(resources.getString(R.string.btuser_setting_title_en));
            languageKeyTv.setText(resources.getString(R.string.btuser_setting_language_key_en));
            languageValueTv.setText(resources.getString(R.string.btuser_setting_language_value_en));
            privacyKeyTv.setText(resources.getString(R.string.btuser_setting_privacy_en));
            aboutUsKeyTv.setText(resources.getString(R.string.btuser_setting_about_en));
            logoutTv.setText(resources.getString(R.string.btuser_setting_logout_en));
            logoutSuccessNote = resources.getString(R.string.btuser_setting_logout_success_note_en);
            confirm = resources.getString(R.string.btuser_confirm_en);
            cancel = resources.getString(R.string.btuser_cancel_en);
        }
    }

    private void logout(final DialogInterface dialog) {
        netWorkServer.logout(userInfo.get_Akey()).enqueue(new Callback<LogoutResultEntity>() {
            @Override
            public void onResponse(Call<LogoutResultEntity> call, Response<LogoutResultEntity> response) {
                if (response.body().getError() != null) {
                    showMsg(response.body().getError().getMessage());
                } else {
                    SPHelper.saveLoginStatus(false);
                    SPHelper.saveUserInfo(new UserInfoEntity());
                    showMsg(logoutSuccessNote);
                    Intent intent = new Intent();
                    intent.setAction(BTUserCenterActivity.STATUS_UPDATE);
                    sendBroadcast(intent);
                    logoutTv.setVisibility(View.GONE);
//                    getApplicationContext().deleteDatabase("webview.db");
//                    getApplicationContext().deleteDatabase("webviewCache.db");
                    CookieManager.getInstance().removeAllCookie();
                    dialog.dismiss();
                    //   finish();
                }
            }

            @Override
            public void onFailure(Call<LogoutResultEntity> call, Throwable t) {
                showMsg(netErrorNote);
            }
        });

    }

    @Override
    protected void onLanguageChanged() {
        setText();
    }

    private void showAlertDialog() {
        CustomDialog.Builder builder = new CustomDialog.Builder(this)
                .setMessage(logoutTv.getText().toString())
                .setTitle(null)
                .setNegativeButton(cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                }).setPositiveButton(confirm, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        logout(dialog);
                    }
                });
        builder.create().show();
    }
}
