package com.beatop.btopusercenter.ui;

import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopusercenter.R;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Administrator on 2016/9/29.
 */
public class BTChangePwdActivity extends BTBaseActivity {


    private TextView cancelTv;
    private TextView titleTv;
    private TextView saveTv;

    private EditText oldPwdEt;
    private EditText newPwdEt;
    private EditText confirmPwdEt;

    private String paramErrorNote;
    private String paramEmptyNote;
    private String langErrorNote;
    private String successNote;
    private String failNote;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_activity_changepwd);
        initView();
    }


    private void initView() {
        cancelTv = (TextView) findViewById(R.id.tv_cancel);
        cancelTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        saveTv = (TextView) findViewById(R.id.tv_save);
        saveTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                changePwd();
            }
        });
        titleTv = (TextView) findViewById(R.id.title);
        oldPwdEt = (EditText) findViewById(R.id.et_old_pwd);
        oldPwdEt.setTypeface(Typeface.SANS_SERIF);
        newPwdEt = (EditText) findViewById(R.id.et_new_pwd);
        newPwdEt.setTypeface(Typeface.SANS_SERIF);
        confirmPwdEt = (EditText) findViewById(R.id.et_confirm_new_pwd);
        confirmPwdEt.setTypeface(Typeface.SANS_SERIF);
        setText();
    }

    private void setText() {
        if (isZh) {
            titleTv.setText(resources.getString(R.string.btuser_pwd_title_zh));
            cancelTv.setText(resources.getString(R.string.btuser_cancel_zh));
            saveTv.setText(resources.getString(R.string.btuser_save_zh));

            oldPwdEt.setHint(R.string.btuser_pwd_old_hint_zh);
            newPwdEt.setHint(R.string.btuser_pwd_new_hint_zh);
            confirmPwdEt.setHint(R.string.btuser_pwd_confirm_hint_zh);

            paramEmptyNote = resources.getString(R.string.btuser_pwd_param_empty_note_zh);
            langErrorNote = resources.getString(R.string.btuser_pwd_lang_error_note_zh);
            paramErrorNote = resources.getString(R.string.btuser_pwd_param_error_note_zh);
            successNote = resources.getString(R.string.btuser_pwd_success_note_zh);
            failNote = resources.getString(R.string.btuser_pwd_fail_note_zh);


        } else {
            titleTv.setText(resources.getString(R.string.btuser_pwd_title_en));
            cancelTv.setText(resources.getString(R.string.btuser_cancel_en));
            saveTv.setText(resources.getString(R.string.btuser_save_en));

            oldPwdEt.setHint(R.string.btuser_pwd_old_hint_en);
            newPwdEt.setHint(R.string.btuser_pwd_new_hint_en);
            confirmPwdEt.setHint(R.string.btuser_pwd_confirm_hint_en);

            paramEmptyNote = resources.getString(R.string.btuser_pwd_param_empty_note_en);
            langErrorNote = resources.getString(R.string.btuser_pwd_lang_error_note_en);
            paramErrorNote = resources.getString(R.string.btuser_pwd_param_error_note_en);

            successNote = resources.getString(R.string.btuser_pwd_success_note_en);
            failNote = resources.getString(R.string.btuser_pwd_fail_note_en);


        }


    }

    @Override
    protected void onLanguageChanged() {
        setText();
    }

    private void changePwd() {
        String oldPassword = oldPwdEt.getText().toString();
        String newPassword = newPwdEt.getText().toString();
        String confirmPassword = confirmPwdEt.getText().toString();
        //step 1 :check params if empty
        //step 2: check new pwd ,length and two inputs are equal.
        //step 3: set new pwd to server,and wait result;
        //step 4: show result to user;
        if (TextUtils.isEmpty(oldPassword) || TextUtils.isEmpty(newPassword) || TextUtils.isEmpty(confirmPassword)) {
            showMsg(paramEmptyNote);
            return;
        }
        if (newPassword.length() < 6) {
            showMsg(langErrorNote);
            return;
        }
        if (!newPassword.equals(confirmPassword)) {
            showMsg(paramErrorNote);
            return;
        }
        netWorkServer.changePwd(userInfo.get_Akey(), oldPassword, newPassword, "signup").enqueue(new Callback<UserInfoEntity>() {
            @Override
            public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                if (response.body().getError() != null) {
                    showMsg(response.body().getError().getMessage());
                } else {
                    showMsg(successNote);
                    //    SPHelper.saveUserInfo(response.body());
                    //    userInfo = response.body();
                    finish();
                }
            }

            @Override
            public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                showMsg(netErrorNote);
            }
        });

    }
}
