package com.beatop.btopusercenter.ui;

import android.content.Intent;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.BTCountryListActivity;
import com.beatop.btopbase.module.CaptchaResultEntity;
import com.beatop.btopbase.module.ChangePhoneResultEntity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopbase.utils.StringHelper;
import com.beatop.btopusercenter.R;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Administrator on 2016/9/29.
 */
public class BTChangePhoneActivity extends BTBaseActivity {
//tv_get_verification

    private TextView currentPhoneTv;
    private TextView areaCodeTv;
    private TextView getVerificationTV;


    private EditText newNumberEt;
    private EditText verificationCodeEt;

    private String phoneErrorNote;
    private String paramEmptyNote;


    private TextView cancelTv;
    private TextView titleTv;
    private TextView saveTv;

    private String getVerificationNote;
    private String waitNote;

    private CountDownTimer timeCount;
    private String currentPhone;
    private String successNote;

    private boolean isBounded = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_activity_changephone);
        initView();
    }


    private void initView() {
        cancelTv = (TextView) findViewById(R.id.tv_cancel);
        cancelTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        saveTv = (TextView) findViewById(R.id.tv_save);
        saveTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                changePhoneNumber();
            }
        });
        titleTv = (TextView) findViewById(R.id.title);

        currentPhoneTv = (TextView) findViewById(R.id.tv_current_phone);

        areaCodeTv = (TextView) findViewById(R.id.tv_area_code);
        areaCodeTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent it = new Intent(BTChangePhoneActivity.this, BTCountryListActivity.class);
                startActivityForResult(it, 1);
            }
        });
        newNumberEt = (EditText) findViewById(R.id.et_edit_phone);
        verificationCodeEt = (EditText) findViewById(R.id.et_edit_verification);
        getVerificationTV = (TextView) findViewById(R.id.tv_get_verification);

        getVerificationTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getVerification();
            }
        });
        if (!TextUtils.isEmpty(userInfo.getMobile()) && userInfo.getVerified() != null && userInfo.getVerified().getMobile() == 0) {
            newNumberEt.setText(userInfo.getMobile());
        }

        setText();
        initTimer();
        Intent it = getIntent();
        String currentMobile = it.getStringExtra("phone");
        isBounded = it.getBooleanExtra("bound", false);
        if (TextUtils.isEmpty(currentMobile)) {
            currentPhoneTv.setVisibility(View.GONE);
        } else {
            currentPhoneTv.setText(String.format(currentPhone, it.getStringExtra("phone")));
        }


    }

    private void setText() {
        if (isZh) {
            titleTv.setText(resources.getString(R.string.btuser_phone_title_zh));
            cancelTv.setText(resources.getString(R.string.btuser_cancel_zh));
            saveTv.setText(resources.getString(R.string.btuser_save_zh));

            currentPhone = resources.getString(R.string.btuser_phone_key_zh);
            newNumberEt.setHint(R.string.btuser_phone_number_hint_zh);
            verificationCodeEt.setHint(R.string.btuser_phone_verification_hint_zh);
            getVerificationNote = resources.getString(R.string.btuser_phone_get_zh);
            waitNote = resources.getString(R.string.btuser_phone_wait_zh);
            phoneErrorNote = resources.getString(R.string.btuser_phone_error_zh);
            paramEmptyNote = resources.getString(R.string.btuser_pwd_param_empty_note_zh);
            successNote = resources.getString(R.string.btuser_change_success_note_zh);
        } else {
            titleTv.setText(resources.getString(R.string.btuser_phone_title_en));
            cancelTv.setText(resources.getString(R.string.btuser_cancel_en));
            saveTv.setText(resources.getString(R.string.btuser_save_en));
            phoneErrorNote = resources.getString(R.string.btuser_phone_error_en);

            currentPhone = resources.getString(R.string.btuser_phone_key_en);
            newNumberEt.setHint(R.string.btuser_phone_number_hint_en);
            verificationCodeEt.setHint(R.string.btuser_phone_verification_hint_en);
            getVerificationNote = resources.getString(R.string.btuser_phone_get_en);
            waitNote = resources.getString(R.string.btuser_phone_wait_en);
            paramEmptyNote = resources.getString(R.string.btuser_pwd_param_empty_note_en);
            successNote = resources.getString(R.string.btuser_change_success_note_en);
        }

        getVerificationTV.setText(getVerificationNote);
    }

    @Override
    protected void onLanguageChanged() {
        setText();
    }

    private void changePhoneNumber() {
        // step 0:check if new number and verification code are empty
        //step 1: check mobile number
        // step 2:send phone number and verification to server and wait return
        // step 3:finish this page.
        if (!StringHelper.checkMobile(areaCodeTv.getText().toString(), newNumberEt.getText().toString())) {
            showMsg(phoneErrorNote);
            return;
        }
        if (TextUtils.isEmpty(verificationCodeEt.getText().toString())) {
            showMsg(paramEmptyNote);
            return;
        }
        netWorkServer.updateMobile(userInfo.get_Akey(), areaCodeTv.getText().toString().substring(1), newNumberEt.getText().toString(), verificationCodeEt.getText().toString(), "up")
                .enqueue(new Callback<UserInfoEntity>() {
                    @Override
                    public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                        if (response.isSuccessful()) {
                            if (response.body().getError() == null) {
                                showMsg(successNote);
                                userInfo.setMobile(response.body().getMobile());
                                userInfo.setVerified(response.body().getVerified());
                                SPHelper.saveUserInfo(userInfo);
                                Intent it = new Intent();
                                it.putExtra("phone", newNumberEt.getText().toString());
                                setResult(RESULT_OK, it);
                                finish();
                            } else {
                                showMsg(response.body().getError().getMessage());
                            }
                        } else {
                            showMsg(netErrorNote);
                        }
                    }

                    @Override
                    public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                        showMsg(netErrorNote);
                    }
                });

    }

    private void getVerification() {
        if (!StringHelper.checkMobile(areaCodeTv.getText().toString(), newNumberEt.getText().toString())) {
            showMsg(phoneErrorNote);
            return;
        }
        getVerificationTV.setClickable(false);
        String use;
        if (!TextUtils.isEmpty(userInfo.getMobile()) && newNumberEt.equals(userInfo.getMobile())) {
            use = "bind";
        } else {
            use = "signup";
        }
        netWorkServer.getCaptcha(areaCodeTv.getText().toString().substring(1), newNumberEt.getText().toString(), use).enqueue(new Callback<CaptchaResultEntity>() {
            @Override
            public void onResponse(Call<CaptchaResultEntity> call, Response<CaptchaResultEntity> response) {
                if (response.body().getError() != null) {
                    showMsg(response.body().getError().getMessage());
                    getVerificationTV.setClickable(true);
                } else {
                    getVerificationTV.setTextColor(resources.getColor(R.color.color_text_gray));
                    getVerificationTV.setClickable(false);
                    getVerificationTV.setBackgroundResource(R.drawable.btuser_redio_rect_disable);
                    Log.d(TAG, "onResponse: " + response.body().getCaptcha());
                    timeCount.start();
                }
            }

            @Override
            public void onFailure(Call<CaptchaResultEntity> call, Throwable t) {
                showMsg(netErrorNote);
                getVerificationTV.setClickable(true);
            }
        });
    }

    private void initTimer() {
        timeCount = new CountDownTimer(60 * 1000, 1000) {
            @Override
            public void onTick(long millisUntilFinished) {
                int time = (int) (millisUntilFinished / 1000);
                getVerificationTV.setText(String.format(waitNote, time));
            }

            @Override
            public void onFinish() {
                getVerificationTV.setText(getVerificationNote);
                getVerificationTV.setTextColor(resources.getColor(R.color.color_main_green));
                getVerificationTV.setBackgroundResource(R.drawable.btuser_redio_rect);
                getVerificationTV.setClickable(true);
            }
        };
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK && requestCode == 1) {
            areaCodeTv.setText(data.getStringExtra("area_code"));
        }
    }
}
