package com.beatop.btopusercenter.ui;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.SetLanguageResultEntity;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopusercenter.R;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Administrator on 2016/9/29.
 */
public class BTChangeLanguageActivity extends BTBaseActivity {

    private TextView cancelTv;
    private TextView title;
    private TextView saveTv;

    private ImageView languageEnIv;
    private ImageView languageZhIv;

    private TextView chineseTv;
    private TextView englishTv;

    private String currentLanguage;
    private String newLanguage;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_activity_changelanguage);
        initView();
    }

    private void initView() {

        cancelTv = (TextView) findViewById(R.id.tv_cancel);
        cancelTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });

        title = (TextView) findViewById(R.id.title);

        saveTv = (TextView) findViewById(R.id.tv_save);
        saveTv.setOnClickListener(new View.OnClickListener() {
                                      @Override
                                      public void onClick(View v) {
                                          // if (!currentLanguage.equals(newLanguage)) {
                                          netWorkServer.changeLanguage(userInfo.get_Akey(), newLanguage).enqueue(new Callback<SetLanguageResultEntity>() {
                                              @Override
                                              public void onResponse(Call<SetLanguageResultEntity> call, Response<SetLanguageResultEntity> response) {
                                                  if (response.body().getError() != null) {
                                                      showMsg(response.body().getError().getMessage());
                                                  } else {
                                                      SPHelper.saveLanguageSetting(newLanguage);
                                                      Intent intent = new Intent();
                                                      intent.setAction(LANGUAGE_CHANGE_BROADCAST);
                                                      sendBroadcast(intent);
                                                      finish();
                                                  }
                                              }

                                              @Override
                                              public void onFailure(Call<SetLanguageResultEntity> call, Throwable t) {
                                                  showMsg(netErrorNote);
                                              }
                                          });
                                      }

                                  }
                //    }
        );
        languageEnIv = (ImageView) findViewById(R.id.iv_language_en);
        languageZhIv = (ImageView) findViewById(R.id.iv_language_zh);

        languageEnIv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int id = (int) languageEnIv.getTag();
                if (id == R.mipmap.btbase_item_unselected) {
                    newLanguage = "en";
                    languageEnIv.setImageResource(R.mipmap.btbase_item_selected);
                    languageEnIv.setTag(R.mipmap.btbase_item_selected);
                    languageZhIv.setImageResource(R.mipmap.btbase_item_unselected);
                    languageZhIv.setTag(R.mipmap.btbase_item_unselected);
                }
            }
        });

        languageZhIv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int id = (int) languageZhIv.getTag();
                if (id == R.mipmap.btbase_item_unselected) {
                    newLanguage = "zh";
                    languageZhIv.setImageResource(R.mipmap.btbase_item_selected);
                    languageZhIv.setTag(R.mipmap.btbase_item_selected);
                    languageEnIv.setImageResource(R.mipmap.btbase_item_unselected);
                    languageEnIv.setTag(R.mipmap.btbase_item_unselected);
                }
            }
        });
        chineseTv = (TextView) findViewById(R.id.tv_language_zh);
        englishTv = (TextView) findViewById(R.id.tv_language_en);
        setText();
    }

    private void setText() {
        if (isZh) {
            currentLanguage = "zh";
            newLanguage = "zh";
            languageEnIv.setImageResource(R.mipmap.btbase_item_unselected);
            languageEnIv.setTag(R.mipmap.btbase_item_unselected);
            languageZhIv.setImageResource(R.mipmap.btbase_item_selected);
            languageZhIv.setTag(R.mipmap.btbase_item_selected);
            chineseTv.setText(resources.getString(R.string.btuse_language_china_zh));
            title.setText(resources.getString(R.string.btuser_language_title_zh));
            englishTv.setText(resources.getString(R.string.btuser_language_english_zh));
            cancelTv.setText(resources.getString(R.string.btuser_cancel_zh));
            saveTv.setText(resources.getString(R.string.btuser_save_zh));
        } else {
            currentLanguage = "en";
            newLanguage = "en";
            languageEnIv.setImageResource(R.mipmap.btbase_item_selected);
            languageEnIv.setTag(R.mipmap.btbase_item_selected);
            languageZhIv.setImageResource(R.mipmap.btbase_item_unselected);
            languageZhIv.setTag(R.mipmap.btbase_item_unselected);

            chineseTv.setText(resources.getString(R.string.btuse_language_china_en));
            title.setText(resources.getString(R.string.btuser_language_title_en));
            englishTv.setText(resources.getString(R.string.btuser_language_english_en));
            cancelTv.setText(resources.getString(R.string.btuser_cancel_en));
            saveTv.setText(resources.getString(R.string.btuser_save_en));
        }
    }

    @Override
    protected void onLanguageChanged() {
        setText();

    }

}
