/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopusercenter.R;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTChangePwdActivity
extends BTBaseActivity {
    private TextView cancelTv;
    private TextView titleTv;
    private TextView saveTv;
    private EditText oldPwdEt;
    private EditText newPwdEt;
    private EditText confirmPwdEt;
    private String paramErrorNote;
    private String paramEmptyNote;
    private String langErrorNote;
    private String successNote;
    private String failNote;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btuser_activity_changepwd);
        this.initView();
    }

    private void initView() {
        this.cancelTv = (TextView)this.findViewById(R.id.tv_cancel);
        this.cancelTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTChangePwdActivity.this.onBackPressed();
            }
        });
        this.saveTv = (TextView)this.findViewById(R.id.tv_save);
        this.saveTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTChangePwdActivity.this.changePwd();
            }
        });
        this.titleTv = (TextView)this.findViewById(R.id.title);
        this.oldPwdEt = (EditText)this.findViewById(R.id.et_old_pwd);
        this.oldPwdEt.setTypeface(Typeface.SANS_SERIF);
        this.newPwdEt = (EditText)this.findViewById(R.id.et_new_pwd);
        this.newPwdEt.setTypeface(Typeface.SANS_SERIF);
        this.confirmPwdEt = (EditText)this.findViewById(R.id.et_confirm_new_pwd);
        this.confirmPwdEt.setTypeface(Typeface.SANS_SERIF);
        this.setText();
    }

    private void setText() {
        if (this.isZh) {
            this.titleTv.setText((CharSequence)this.resources.getString(R.string.btuser_pwd_title_zh));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_zh));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_zh));
            this.oldPwdEt.setHint(R.string.btuser_pwd_old_hint_zh);
            this.newPwdEt.setHint(R.string.btuser_pwd_new_hint_zh);
            this.confirmPwdEt.setHint(R.string.btuser_pwd_confirm_hint_zh);
            this.paramEmptyNote = this.resources.getString(R.string.btuser_pwd_param_empty_note_zh);
            this.langErrorNote = this.resources.getString(R.string.btuser_pwd_lang_error_note_zh);
            this.paramErrorNote = this.resources.getString(R.string.btuser_pwd_param_error_note_zh);
            this.successNote = this.resources.getString(R.string.btuser_pwd_success_note_zh);
            this.failNote = this.resources.getString(R.string.btuser_pwd_fail_note_zh);
        } else {
            this.titleTv.setText((CharSequence)this.resources.getString(R.string.btuser_pwd_title_en));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_en));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_en));
            this.oldPwdEt.setHint(R.string.btuser_pwd_old_hint_en);
            this.newPwdEt.setHint(R.string.btuser_pwd_new_hint_en);
            this.confirmPwdEt.setHint(R.string.btuser_pwd_confirm_hint_en);
            this.paramEmptyNote = this.resources.getString(R.string.btuser_pwd_param_empty_note_en);
            this.langErrorNote = this.resources.getString(R.string.btuser_pwd_lang_error_note_en);
            this.paramErrorNote = this.resources.getString(R.string.btuser_pwd_param_error_note_en);
            this.successNote = this.resources.getString(R.string.btuser_pwd_success_note_en);
            this.failNote = this.resources.getString(R.string.btuser_pwd_fail_note_en);
        }
    }

    protected void onLanguageChanged() {
        this.setText();
    }

    private void changePwd() {
        String oldPassword = this.oldPwdEt.getText().toString();
        String newPassword = this.newPwdEt.getText().toString();
        String confirmPassword = this.confirmPwdEt.getText().toString();
        if (TextUtils.isEmpty((CharSequence)oldPassword) || TextUtils.isEmpty((CharSequence)newPassword) || TextUtils.isEmpty((CharSequence)confirmPassword)) {
            this.showMsg(this.paramEmptyNote);
            return;
        }
        if (newPassword.length() < 6) {
            this.showMsg(this.langErrorNote);
            return;
        }
        if (!newPassword.equals(confirmPassword)) {
            this.showMsg(this.paramErrorNote);
            return;
        }
        netWorkServer.changePwd(userInfo.get_Akey(), oldPassword, newPassword, "signup").enqueue((Callback)new Callback<UserInfoEntity>(){

            public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                if (((UserInfoEntity)response.body()).getError() != null) {
                    BTChangePwdActivity.this.showMsg(((UserInfoEntity)response.body()).getError().getMessage());
                } else {
                    BTChangePwdActivity.this.showMsg(BTChangePwdActivity.this.successNote);
                    BTChangePwdActivity.this.finish();
                }
            }

            public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                BTChangePwdActivity.this.showMsg(BTChangePwdActivity.this.netErrorNote);
            }
        });
    }
}

