/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.BTCountryListActivity;
import com.beatop.btopbase.module.CaptchaResultEntity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopbase.utils.StringHelper;
import com.beatop.btopusercenter.R;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTChangePhoneActivity
extends BTBaseActivity {
    private TextView currentPhoneTv;
    private TextView areaCodeTv;
    private TextView getVerificationTV;
    private EditText newNumberEt;
    private EditText verificationCodeEt;
    private String phoneErrorNote;
    private String paramEmptyNote;
    private TextView cancelTv;
    private TextView titleTv;
    private TextView saveTv;
    private String getVerificationNote;
    private String waitNote;
    private CountDownTimer timeCount;
    private String currentPhone;
    private String successNote;
    private boolean isBounded = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btuser_activity_changephone);
        this.initView();
    }

    private void initView() {
        this.cancelTv = (TextView)this.findViewById(R.id.tv_cancel);
        this.cancelTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTChangePhoneActivity.this.onBackPressed();
            }
        });
        this.saveTv = (TextView)this.findViewById(R.id.tv_save);
        this.saveTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTChangePhoneActivity.this.changePhoneNumber();
            }
        });
        this.titleTv = (TextView)this.findViewById(R.id.title);
        this.currentPhoneTv = (TextView)this.findViewById(R.id.tv_current_phone);
        this.areaCodeTv = (TextView)this.findViewById(R.id.tv_area_code);
        this.areaCodeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent it = new Intent((Context)BTChangePhoneActivity.this, BTCountryListActivity.class);
                BTChangePhoneActivity.this.startActivityForResult(it, 1);
            }
        });
        this.newNumberEt = (EditText)this.findViewById(R.id.et_edit_phone);
        this.verificationCodeEt = (EditText)this.findViewById(R.id.et_edit_verification);
        this.getVerificationTV = (TextView)this.findViewById(R.id.tv_get_verification);
        this.getVerificationTV.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTChangePhoneActivity.this.getVerification();
            }
        });
        if (!TextUtils.isEmpty((CharSequence)userInfo.getMobile()) && userInfo.getVerified() != null && userInfo.getVerified().getMobile() == 0) {
            this.newNumberEt.setText((CharSequence)userInfo.getMobile());
        }
        this.setText();
        this.initTimer();
        Intent it = this.getIntent();
        String currentMobile = it.getStringExtra("phone");
        this.isBounded = it.getBooleanExtra("bound", false);
        if (TextUtils.isEmpty((CharSequence)currentMobile)) {
            this.currentPhoneTv.setVisibility(8);
        } else {
            this.currentPhoneTv.setText((CharSequence)String.format(this.currentPhone, it.getStringExtra("phone")));
        }
    }

    private void setText() {
        if (this.isZh) {
            this.titleTv.setText((CharSequence)this.resources.getString(R.string.btuser_phone_title_zh));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_zh));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_zh));
            this.currentPhone = this.resources.getString(R.string.btuser_phone_key_zh);
            this.newNumberEt.setHint(R.string.btuser_phone_number_hint_zh);
            this.verificationCodeEt.setHint(R.string.btuser_phone_verification_hint_zh);
            this.getVerificationNote = this.resources.getString(R.string.btuser_phone_get_zh);
            this.waitNote = this.resources.getString(R.string.btuser_phone_wait_zh);
            this.phoneErrorNote = this.resources.getString(R.string.btuser_phone_error_zh);
            this.paramEmptyNote = this.resources.getString(R.string.btuser_pwd_param_empty_note_zh);
            this.successNote = this.resources.getString(R.string.btuser_change_success_note_zh);
        } else {
            this.titleTv.setText((CharSequence)this.resources.getString(R.string.btuser_phone_title_en));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_en));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_en));
            this.phoneErrorNote = this.resources.getString(R.string.btuser_phone_error_en);
            this.currentPhone = this.resources.getString(R.string.btuser_phone_key_en);
            this.newNumberEt.setHint(R.string.btuser_phone_number_hint_en);
            this.verificationCodeEt.setHint(R.string.btuser_phone_verification_hint_en);
            this.getVerificationNote = this.resources.getString(R.string.btuser_phone_get_en);
            this.waitNote = this.resources.getString(R.string.btuser_phone_wait_en);
            this.paramEmptyNote = this.resources.getString(R.string.btuser_pwd_param_empty_note_en);
            this.successNote = this.resources.getString(R.string.btuser_change_success_note_en);
        }
        this.getVerificationTV.setText((CharSequence)this.getVerificationNote);
    }

    protected void onLanguageChanged() {
        this.setText();
    }

    private void changePhoneNumber() {
        if (!StringHelper.checkMobile((String)this.areaCodeTv.getText().toString(), (String)this.newNumberEt.getText().toString())) {
            this.showMsg(this.phoneErrorNote);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.verificationCodeEt.getText().toString())) {
            this.showMsg(this.paramEmptyNote);
            return;
        }
        netWorkServer.updateMobile(userInfo.get_Akey(), this.areaCodeTv.getText().toString().substring(1), this.newNumberEt.getText().toString(), this.verificationCodeEt.getText().toString(), "up").enqueue((Callback)new Callback<UserInfoEntity>(){

            public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                if (response.isSuccessful()) {
                    if (((UserInfoEntity)response.body()).getError() == null) {
                        BTChangePhoneActivity.this.showMsg(BTChangePhoneActivity.this.successNote);
                        userInfo.setMobile(((UserInfoEntity)response.body()).getMobile());
                        userInfo.setVerified(((UserInfoEntity)response.body()).getVerified());
                        SPHelper.saveUserInfo((UserInfoEntity)userInfo);
                        Intent it = new Intent();
                        it.putExtra("phone", BTChangePhoneActivity.this.newNumberEt.getText().toString());
                        BTChangePhoneActivity.this.setResult(-1, it);
                        BTChangePhoneActivity.this.finish();
                    } else {
                        BTChangePhoneActivity.this.showMsg(((UserInfoEntity)response.body()).getError().getMessage());
                    }
                } else {
                    BTChangePhoneActivity.this.showMsg(BTChangePhoneActivity.this.netErrorNote);
                }
            }

            public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                BTChangePhoneActivity.this.showMsg(BTChangePhoneActivity.this.netErrorNote);
            }
        });
    }

    private void getVerification() {
        if (!StringHelper.checkMobile((String)this.areaCodeTv.getText().toString(), (String)this.newNumberEt.getText().toString())) {
            this.showMsg(this.phoneErrorNote);
            return;
        }
        this.getVerificationTV.setClickable(false);
        String use = !TextUtils.isEmpty((CharSequence)userInfo.getMobile()) && this.newNumberEt.equals(userInfo.getMobile()) ? "bind" : "signup";
        netWorkServer.getCaptcha(this.areaCodeTv.getText().toString().substring(1), this.newNumberEt.getText().toString(), use).enqueue((Callback)new Callback<CaptchaResultEntity>(){

            public void onResponse(Call<CaptchaResultEntity> call, Response<CaptchaResultEntity> response) {
                if (((CaptchaResultEntity)response.body()).getError() != null) {
                    BTChangePhoneActivity.this.showMsg(((CaptchaResultEntity)response.body()).getError().getMessage());
                    BTChangePhoneActivity.this.getVerificationTV.setClickable(true);
                } else {
                    BTChangePhoneActivity.this.getVerificationTV.setTextColor(BTChangePhoneActivity.this.resources.getColor(R.color.color_text_gray));
                    BTChangePhoneActivity.this.getVerificationTV.setClickable(false);
                    BTChangePhoneActivity.this.getVerificationTV.setBackgroundResource(R.drawable.btuser_redio_rect_disable);
                    Log.d((String)BTChangePhoneActivity.this.TAG, (String)("onResponse: " + ((CaptchaResultEntity)response.body()).getCaptcha()));
                    BTChangePhoneActivity.this.timeCount.start();
                }
            }

            public void onFailure(Call<CaptchaResultEntity> call, Throwable t) {
                BTChangePhoneActivity.this.showMsg(BTChangePhoneActivity.this.netErrorNote);
                BTChangePhoneActivity.this.getVerificationTV.setClickable(true);
            }
        });
    }

    private void initTimer() {
        this.timeCount = new CountDownTimer(60000L, 1000L){

            public void onTick(long millisUntilFinished) {
                int time = (int)(millisUntilFinished / 1000L);
                BTChangePhoneActivity.this.getVerificationTV.setText((CharSequence)String.format(BTChangePhoneActivity.this.waitNote, time));
            }

            public void onFinish() {
                BTChangePhoneActivity.this.getVerificationTV.setText((CharSequence)BTChangePhoneActivity.this.getVerificationNote);
                BTChangePhoneActivity.this.getVerificationTV.setTextColor(BTChangePhoneActivity.this.resources.getColor(R.color.color_main_green));
                BTChangePhoneActivity.this.getVerificationTV.setBackgroundResource(R.drawable.btuser_redio_rect);
                BTChangePhoneActivity.this.getVerificationTV.setClickable(true);
            }
        };
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && requestCode == 1) {
            this.areaCodeTv.setText((CharSequence)data.getStringExtra("area_code"));
        }
    }
}

