/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.SetLanguageResultEntity;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopusercenter.R;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTChangeLanguageActivity
extends BTBaseActivity {
    private TextView cancelTv;
    private TextView title;
    private TextView saveTv;
    private ImageView languageEnIv;
    private ImageView languageZhIv;
    private TextView chineseTv;
    private TextView englishTv;
    private String currentLanguage;
    private String newLanguage;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btuser_activity_changelanguage);
        this.initView();
    }

    private void initView() {
        this.cancelTv = (TextView)this.findViewById(R.id.tv_cancel);
        this.cancelTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTChangeLanguageActivity.this.onBackPressed();
            }
        });
        this.title = (TextView)this.findViewById(R.id.title);
        this.saveTv = (TextView)this.findViewById(R.id.tv_save);
        this.saveTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                netWorkServer.changeLanguage(userInfo.get_Akey(), BTChangeLanguageActivity.this.newLanguage).enqueue((Callback)new Callback<SetLanguageResultEntity>(){

                    public void onResponse(Call<SetLanguageResultEntity> call, Response<SetLanguageResultEntity> response) {
                        if (((SetLanguageResultEntity)response.body()).getError() != null) {
                            BTChangeLanguageActivity.this.showMsg(((SetLanguageResultEntity)response.body()).getError().getMessage());
                        } else {
                            SPHelper.saveLanguageSetting((String)BTChangeLanguageActivity.this.newLanguage);
                            Intent intent = new Intent();
                            intent.setAction("change_language_broadcast");
                            BTChangeLanguageActivity.this.sendBroadcast(intent);
                            BTChangeLanguageActivity.this.finish();
                        }
                    }

                    public void onFailure(Call<SetLanguageResultEntity> call, Throwable t) {
                        BTChangeLanguageActivity.this.showMsg(BTChangeLanguageActivity.this.netErrorNote);
                    }
                });
            }
        });
        this.languageEnIv = (ImageView)this.findViewById(R.id.iv_language_en);
        this.languageZhIv = (ImageView)this.findViewById(R.id.iv_language_zh);
        this.languageEnIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int id2 = (Integer)BTChangeLanguageActivity.this.languageEnIv.getTag();
                if (id2 == R.mipmap.btbase_item_unselected) {
                    BTChangeLanguageActivity.this.newLanguage = "en";
                    BTChangeLanguageActivity.this.languageEnIv.setImageResource(R.mipmap.btbase_item_selected);
                    BTChangeLanguageActivity.this.languageEnIv.setTag((Object)R.mipmap.btbase_item_selected);
                    BTChangeLanguageActivity.this.languageZhIv.setImageResource(R.mipmap.btbase_item_unselected);
                    BTChangeLanguageActivity.this.languageZhIv.setTag((Object)R.mipmap.btbase_item_unselected);
                }
            }
        });
        this.languageZhIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int id2 = (Integer)BTChangeLanguageActivity.this.languageZhIv.getTag();
                if (id2 == R.mipmap.btbase_item_unselected) {
                    BTChangeLanguageActivity.this.newLanguage = "zh";
                    BTChangeLanguageActivity.this.languageZhIv.setImageResource(R.mipmap.btbase_item_selected);
                    BTChangeLanguageActivity.this.languageZhIv.setTag((Object)R.mipmap.btbase_item_selected);
                    BTChangeLanguageActivity.this.languageEnIv.setImageResource(R.mipmap.btbase_item_unselected);
                    BTChangeLanguageActivity.this.languageEnIv.setTag((Object)R.mipmap.btbase_item_unselected);
                }
            }
        });
        this.chineseTv = (TextView)this.findViewById(R.id.tv_language_zh);
        this.englishTv = (TextView)this.findViewById(R.id.tv_language_en);
        this.setText();
    }

    private void setText() {
        if (this.isZh) {
            this.currentLanguage = "zh";
            this.newLanguage = "zh";
            this.languageEnIv.setImageResource(R.mipmap.btbase_item_unselected);
            this.languageEnIv.setTag((Object)R.mipmap.btbase_item_unselected);
            this.languageZhIv.setImageResource(R.mipmap.btbase_item_selected);
            this.languageZhIv.setTag((Object)R.mipmap.btbase_item_selected);
            this.chineseTv.setText((CharSequence)this.resources.getString(R.string.btuse_language_china_zh));
            this.title.setText((CharSequence)this.resources.getString(R.string.btuser_language_title_zh));
            this.englishTv.setText((CharSequence)this.resources.getString(R.string.btuser_language_english_zh));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_zh));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_zh));
        } else {
            this.currentLanguage = "en";
            this.newLanguage = "en";
            this.languageEnIv.setImageResource(R.mipmap.btbase_item_selected);
            this.languageEnIv.setTag((Object)R.mipmap.btbase_item_selected);
            this.languageZhIv.setImageResource(R.mipmap.btbase_item_unselected);
            this.languageZhIv.setTag((Object)R.mipmap.btbase_item_unselected);
            this.chineseTv.setText((CharSequence)this.resources.getString(R.string.btuse_language_china_en));
            this.title.setText((CharSequence)this.resources.getString(R.string.btuser_language_title_en));
            this.englishTv.setText((CharSequence)this.resources.getString(R.string.btuser_language_english_en));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_en));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_en));
        }
    }

    protected void onLanguageChanged() {
        this.setText();
    }
}

