/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.content.Intent;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.CaptchaResultEntity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopbase.utils.StringHelper;
import com.beatop.btopusercenter.R;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTChangeEmailActivity
extends BTBaseActivity {
    private TextView currentPhoneTv;
    private TextView getVerificationTV;
    private EditText newNumberEt;
    private EditText verificationCodeEt;
    private String phoneErrorNote;
    private TextView cancelTv;
    private TextView titleTv;
    private TextView saveTv;
    private String getVerificationNote;
    private String waitNote;
    private CountDownTimer timeCount;
    private String currentPhone;
    private String paramErrorNote;
    private String paramEmptyNote;
    private String successNote;
    private boolean isBounded = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btuser_activity_chageemail);
        this.initView();
    }

    private void initView() {
        this.cancelTv = (TextView)this.findViewById(R.id.tv_cancel);
        this.cancelTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTChangeEmailActivity.this.onBackPressed();
            }
        });
        this.saveTv = (TextView)this.findViewById(R.id.tv_save);
        this.saveTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTChangeEmailActivity.this.changeEmail();
            }
        });
        this.titleTv = (TextView)this.findViewById(R.id.title);
        this.currentPhoneTv = (TextView)this.findViewById(R.id.tv_current_phone);
        this.newNumberEt = (EditText)this.findViewById(R.id.et_edit_phone);
        if (!TextUtils.isEmpty((CharSequence)userInfo.getEmail()) && userInfo.getVerified() != null && userInfo.getVerified().getEmail() == 0) {
            this.newNumberEt.setText((CharSequence)userInfo.getEmail());
        }
        this.verificationCodeEt = (EditText)this.findViewById(R.id.et_edit_verification);
        this.getVerificationTV = (TextView)this.findViewById(R.id.tv_get_verification);
        this.getVerificationTV.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTChangeEmailActivity.this.getVerification();
            }
        });
        this.setText();
        this.initTimer();
        Intent it = this.getIntent();
        String currentMobile = it.getStringExtra("email");
        this.isBounded = it.getBooleanExtra("bound", false);
        if (TextUtils.isEmpty((CharSequence)currentMobile)) {
            this.currentPhoneTv.setVisibility(8);
        } else {
            this.currentPhoneTv.setText((CharSequence)String.format(this.currentPhone, it.getStringExtra("email")));
        }
    }

    private void setText() {
        if (this.isZh) {
            this.titleTv.setText((CharSequence)this.resources.getString(R.string.btuser_email_title_zh));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_zh));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_zh));
            this.currentPhone = this.resources.getString(R.string.btuser_email_key_zh);
            this.newNumberEt.setHint(R.string.btuser_email_number_hint_zh);
            this.verificationCodeEt.setHint(R.string.btuser_phone_verification_hint_zh);
            this.getVerificationNote = this.resources.getString(R.string.btuser_phone_get_zh);
            this.waitNote = this.resources.getString(R.string.btuser_phone_wait_zh);
            this.phoneErrorNote = this.resources.getString(R.string.btuser_email_error_zh);
            this.paramEmptyNote = this.resources.getString(R.string.btuser_pwd_param_empty_note_zh);
            this.successNote = this.resources.getString(R.string.btuser_change_success_note_zh);
        } else {
            this.titleTv.setText((CharSequence)this.resources.getString(R.string.btuser_email_title_en));
            this.cancelTv.setText((CharSequence)this.resources.getString(R.string.btuser_cancel_en));
            this.saveTv.setText((CharSequence)this.resources.getString(R.string.btuser_save_en));
            this.phoneErrorNote = this.resources.getString(R.string.btuser_email_error_en);
            this.currentPhone = this.resources.getString(R.string.btuser_email_key_en);
            this.newNumberEt.setHint(R.string.btuser_phone_number_hint_en);
            this.verificationCodeEt.setHint(R.string.btuser_phone_verification_hint_en);
            this.getVerificationNote = this.resources.getString(R.string.btuser_phone_get_en);
            this.waitNote = this.resources.getString(R.string.btuser_phone_wait_en);
            this.paramEmptyNote = this.resources.getString(R.string.btuser_pwd_param_empty_note_en);
            this.successNote = this.resources.getString(R.string.btuser_change_success_note_en);
        }
        this.getVerificationTV.setText((CharSequence)this.getVerificationNote);
    }

    protected void onLanguageChanged() {
        this.setText();
    }

    private void changeEmail() {
        if (!StringHelper.checkEmail((String)this.newNumberEt.getText().toString())) {
            this.showMsg(this.phoneErrorNote);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.verificationCodeEt.getText().toString())) {
            this.showMsg(this.paramEmptyNote);
            return;
        }
        netWorkServer.updateEmail(userInfo.get_Akey(), this.newNumberEt.getText().toString(), this.verificationCodeEt.getText().toString(), "up").enqueue((Callback)new Callback<UserInfoEntity>(){

            public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                if (response.isSuccessful()) {
                    if (((UserInfoEntity)response.body()).getError() == null) {
                        BTChangeEmailActivity.this.showMsg(BTChangeEmailActivity.this.successNote);
                        Intent intent = new Intent();
                        intent.putExtra("email", BTChangeEmailActivity.this.newNumberEt.getText().toString());
                        userInfo.setEmail(BTChangeEmailActivity.this.newNumberEt.getText().toString());
                        SPHelper.saveUserInfo((UserInfoEntity)userInfo);
                        BTChangeEmailActivity.this.setResult(-1, intent);
                        BTChangeEmailActivity.this.finish();
                    } else {
                        BTChangeEmailActivity.this.showMsg(((UserInfoEntity)response.body()).getError().getMessage());
                    }
                } else {
                    BTChangeEmailActivity.this.showMsg(BTChangeEmailActivity.this.netErrorNote);
                }
            }

            public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                BTChangeEmailActivity.this.showMsg(BTChangeEmailActivity.this.netErrorNote);
            }
        });
    }

    private void getVerification() {
        if (!StringHelper.checkEmail((String)this.newNumberEt.getText().toString())) {
            this.showMsg(this.phoneErrorNote);
            return;
        }
        this.getVerificationTV.setClickable(false);
        String use = !TextUtils.isEmpty((CharSequence)userInfo.getEmail()) && this.newNumberEt.getText().toString().equals(userInfo.getEmail()) ? "bind" : "signup";
        netWorkServer.getCaptcha("", this.newNumberEt.getText().toString(), use).enqueue((Callback)new Callback<CaptchaResultEntity>(){

            public void onResponse(Call<CaptchaResultEntity> call, Response<CaptchaResultEntity> response) {
                if (((CaptchaResultEntity)response.body()).getError() != null) {
                    BTChangeEmailActivity.this.showMsg(((CaptchaResultEntity)response.body()).getError().getMessage());
                    BTChangeEmailActivity.this.getVerificationTV.setClickable(true);
                } else {
                    BTChangeEmailActivity.this.getVerificationTV.setTextColor(BTChangeEmailActivity.this.resources.getColor(R.color.color_text_gray));
                    BTChangeEmailActivity.this.getVerificationTV.setClickable(false);
                    BTChangeEmailActivity.this.getVerificationTV.setBackgroundResource(R.drawable.btuser_redio_rect_disable);
                    Log.d((String)BTChangeEmailActivity.this.TAG, (String)("onResponse: " + ((CaptchaResultEntity)response.body()).getCaptcha()));
                    BTChangeEmailActivity.this.timeCount.start();
                }
            }

            public void onFailure(Call<CaptchaResultEntity> call, Throwable t) {
                BTChangeEmailActivity.this.showMsg(BTChangeEmailActivity.this.netErrorNote);
                BTChangeEmailActivity.this.getVerificationTV.setClickable(true);
            }
        });
    }

    private void initTimer() {
        this.timeCount = new CountDownTimer(60000L, 1000L){

            public void onTick(long millisUntilFinished) {
                int time = (int)(millisUntilFinished / 1000L);
                BTChangeEmailActivity.this.getVerificationTV.setText((CharSequence)String.format(BTChangeEmailActivity.this.waitNote, time));
            }

            public void onFinish() {
                BTChangeEmailActivity.this.getVerificationTV.setText((CharSequence)BTChangeEmailActivity.this.getVerificationNote);
                BTChangeEmailActivity.this.getVerificationTV.setTextColor(BTChangeEmailActivity.this.resources.getColor(R.color.color_main_green));
                BTChangeEmailActivity.this.getVerificationTV.setBackgroundResource(R.drawable.btuser_redio_rect);
                BTChangeEmailActivity.this.getVerificationTV.setClickable(true);
            }
        };
    }
}

