package com.beatop.btopusercenter.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.OnChildActivityResult;
import com.beatop.btopbase.utils.Router;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopbase.view.CircleImageView;
import com.beatop.btopusercenter.R;

/**
 * Created by Administrator on 2016/9/28.
 */
public class BTUserCenterActivity extends BTBaseActivity implements View.OnClickListener, OnChildActivityResult {
    private LinearLayout userPhoto;
    private CircleImageView userPhotoCircleIv;
    private TextView userNameTv;

    private RelativeLayout orderList;
    private TextView orderListTv;

    private RelativeLayout accountSafe;
    private TextView accountSafeTv;


    private RelativeLayout feedback;
    private TextView feedbackTv;

    private RelativeLayout setting;
    private TextView settingTv;

    private boolean isLogin;
    private String loginNote;

    //   private final String ORDER_URL = "http://www.cheesedu.com/my/order?_Akey=%1$s&_lang=%2$s";
    public static final String STATUS_UPDATE = "com.beatop.usercenter.status.update";

    public final int USER_INFO_LOGIN = 31;
    public final int ORDER_INFO_LOGIN = 32;
    public final int SECURITY_INFO_LOGIN = 33;
    private BroadcastReceiver receiver;

    private Activity context;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_activity_usercenter);
        isLogin = SPHelper.isLogin();
        if (getParent() != null) {
            context = getParent();
        } else {
            context = this;
        }
        initView();
        receiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals(STATUS_UPDATE)) {
                    setUserInfo();
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction(STATUS_UPDATE);
        registerReceiver(receiver, filter);
    }

    @Override
    protected void onLanguageChanged() {
        setText();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        unregisterReceiver(receiver);
    }

    private void findView() {
        userPhoto = (LinearLayout) findViewById(R.id.user_info);
        userPhoto.setOnClickListener(this);
        userNameTv = (TextView) findViewById(R.id.tv_user_name);
        userPhotoCircleIv = (CircleImageView) findViewById(R.id.iv_user_photo);

        orderList = (RelativeLayout) findViewById(R.id.booking_list);
        orderList.setOnClickListener(this);
        orderListTv = (TextView) findViewById(R.id.tv_booking_list);

        accountSafe = (RelativeLayout) findViewById(R.id.account_safe);
        accountSafe.setOnClickListener(this);
        accountSafeTv = (TextView) findViewById(R.id.tv_account_safe);

        feedback = (RelativeLayout) findViewById(R.id.feed_back);
        feedback.setOnClickListener(this);
        feedbackTv = (TextView) findViewById(R.id.tv_feed_back);

        setting = (RelativeLayout) findViewById(R.id.app_setting);
        setting.setOnClickListener(this);
        settingTv = (TextView) findViewById(R.id.tv_app_setting);

    }

    private void initView() {
        findView();
        setText();
        setUserInfo();
    }

    private void setText() {
        if (isZh) {
            loginNote = resources.getString(R.string.btuser_user_login_zh);
            orderListTv.setText(resources.getString(R.string.btuser_user_orders_zh));
            accountSafeTv.setText(resources.getString(R.string.btuser_user_safe_zh));
            feedbackTv.setText(resources.getString(R.string.btuser_user_feedback_zh));
            settingTv.setText(resources.getString(R.string.btuser_user_setting_zh));
        } else {
            loginNote = resources.getString(R.string.btuser_user_login_en);
            orderListTv.setText(resources.getString(R.string.btuser_user_orders_en));
            accountSafeTv.setText(resources.getString(R.string.btuser_user_safe_en));
            feedbackTv.setText(resources.getString(R.string.btuser_user_feedback_en));
            settingTv.setText(resources.getString(R.string.btuser_user_setting_en));
        }
        if (!isLogin) {
            userNameTv.setText(loginNote);
        }
    }

    private void setUserInfo() {
        userInfo = SPHelper.getUserInfo();
        isLogin = SPHelper.isLogin();
        if (!isLogin) {
            userPhotoCircleIv.setImageResource(R.mipmap.btbase_user_photo);
            userNameTv.setText(loginNote);
//            imageLoader.displayImage("http://wx.qlogo.cn/mmopen/Upc4r7JkFLKSupjwzpY4qCmABPurLy1dN0Tjyc4bepG7taibzlfVbMwicVF1EyPPf2saIGhUOMH77hh%20rxO3Zia8icjib0wa1VWm4ia/0"
//                    , userPhotoCircleIv, options);
        } else {
            if (userInfo.getProfile() != null && !TextUtils.isEmpty(userInfo.getProfile().getAvatar())) {
                imageLoader.displayImage(userInfo.getProfile().getAvatar(), userPhotoCircleIv, options);
                Log.e(TAG, "setUserInfo: " + userInfo.getProfile().getAvatar());
            } else {
                userPhotoCircleIv.setImageResource(R.mipmap.btbase_user_photo);
            }
            if (!TextUtils.isEmpty(userInfo.getNickname())) {
                userNameTv.setText(userInfo.getNickname());
            } else {
                userNameTv.setText(userInfo.getMobile());
            }
        }

    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.user_info) {
            if (isLogin) {
                Intent it = new Intent(BTUserCenterActivity.this, BTUserInfoActivity.class);
                startActivity(it);
            } else {
                Router.sharedRouter().openForResult("btop://login/btlogin", USER_INFO_LOGIN, context);
            }
        } else if (id == R.id.booking_list) {
            if (isLogin) {
                Bundle bundle = new Bundle();
                bundle.putString("url", String.format(ORDER_URL, userInfo.get_Akey(), SPHelper.getLanguageSetting()));
                Router.sharedRouter().open("btop://web/btTitleWebActivity", bundle);
            } else {
                Router.sharedRouter().openForResult("btop://login/btlogin", ORDER_INFO_LOGIN, context);
                //   Intent it = new Intent(BTUserCenterActivity.this, BTLoginActivity.class);
                //   startActivityForResult(it, ORDER_INFO_LOGIN);
            }
        } else if (id == R.id.account_safe) {
            if (isLogin) {
                Intent it = new Intent(BTUserCenterActivity.this, BTSecurityActivity.class);
                startActivity(it);
            } else {
                Router.sharedRouter().openForResult("btop://login/btlogin", SECURITY_INFO_LOGIN, context);
                //   Intent it = new Intent(BTUserCenterActivity.this, BTLoginActivity.class);
                //   startActivityForResult(it, SECURITY_INFO_LOGIN);
            }
        } else if (id == R.id.feed_back) {
            Intent it = new Intent(BTUserCenterActivity.this, BTFeedbackActivity.class);
            startActivity(it);
        } else if (id == R.id.app_setting) {
            Intent it = new Intent(BTUserCenterActivity.this, BTSettingActivity.class);
            startActivity(it);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK) {
            isLogin = SPHelper.isLogin();
            setUserInfo();
            switch (requestCode) {
                case USER_INFO_LOGIN:
//                    Intent it = new Intent(BTUserCenterActivity.this, BTUserInfoActivity.class);
//                    startActivity(it);
                    break;
                case ORDER_INFO_LOGIN:
                    //   Bundle bundle = new Bundle();
                    ///  bundle.putString("url", String.format(ORDER_URL, userInfo.get_Akey(), SPHelper.getLanguageSetting()));
                    //   Router.sharedRouter().open("btop://web/btTitleWebActivity", bundle);
                    break;
                case SECURITY_INFO_LOGIN:
                    //  Intent intent = new Intent(BTUserCenterActivity.this, BTSecurityActivity.class);
                    // startActivity(intent);
                    break;
                default:
                    break;

            }
        }
    }

    @Override
    public void onChildActivityResult(int requestCode, int resultCode, Intent data) {
        onActivityResult(requestCode, resultCode, data);
    }
}
