package com.beatop.btopusercenter.ui;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopusercenter.R;

/**
 * Created by Administrator on 2016/9/29.
 */
public class BTSecurityActivity extends BTBaseActivity {

    private TextView title;
    private ImageView back;

    private RelativeLayout userPhone;
    private TextView userPhoneKey;
    private TextView userPhoneValue;

    private RelativeLayout userEmail;
    private TextView userEmailKey;
    private TextView userEmailValue;

    private RelativeLayout userPwd;
    private TextView userPwdKey;

    private String unboundNote;

    private final int EDIT_PHONE = 1;
    private final int EDIT_EMAIL = 2;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_activity_security);
        initView();
    }


    private void initView() {
        title = (TextView) findViewById(R.id.title);
        back = (ImageView) findViewById(R.id.back);
        back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });

        userPhone = (RelativeLayout) findViewById(R.id.user_phone);
        userPhone.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent it = new Intent(BTSecurityActivity.this, BTChangePhoneActivity.class);
                if (!userPhoneValue.getText().toString().equals(unboundNote))
                    it.putExtra("phone", userPhoneValue.getText().toString());
                startActivityForResult(it, EDIT_PHONE);
            }
        });
        userPhoneKey = (TextView) findViewById(R.id.tv_user_phone_key);
        userPhoneValue = (TextView) findViewById(R.id.tv_user_phone_value);

        userEmail = (RelativeLayout) findViewById(R.id.user_email);
        userEmail.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent it = new Intent(BTSecurityActivity.this, BTChangeEmailActivity.class);
                if (!userEmailValue.getText().toString().equals(unboundNote))
                    it.putExtra("email", userEmailValue.getText().toString());
                startActivityForResult(it, EDIT_EMAIL);
            }
        });
        userEmailKey = (TextView) findViewById(R.id.tv_user_email_key);
        userEmailValue = (TextView) findViewById(R.id.tv_user_email_value);
        userPwd = (RelativeLayout) findViewById(R.id.user_password);
        userPwd.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent it = new Intent(BTSecurityActivity.this, BTChangePwdActivity.class);
                startActivity(it);
            }
        });
        userPwdKey = (TextView) findViewById(R.id.tv_user_password_key);
        setText();
        if (TextUtils.isEmpty(userInfo.getMobile()) || userInfo.getVerified() == null || userInfo.getVerified().getMobile() == 0) {
            userPhoneValue.setText(unboundNote);
            userPhoneValue.setTextColor(resources.getColor(R.color.color_error));
        } else {
            userPhoneValue.setText(userInfo.getMobile());
            userPhoneValue.setTextColor(resources.getColor(R.color.color_text_gray));
        }
        if (TextUtils.isEmpty(userInfo.getEmail()) || userInfo.getVerified() == null || userInfo.getVerified().getEmail() == 0) {
            userEmailValue.setText(unboundNote);
            userEmailValue.setTextColor(resources.getColor(R.color.color_error));
        } else {
            userEmailValue.setText(userInfo.getEmail());
            userEmailValue.setTextColor(resources.getColor(R.color.color_text_gray));
        }
//        if (userInfo.getVerified() != null) {
//            if (userInfo.getVerified().getMobile() == 0) {
//                userPhoneValue.setText(unboundNote);
//                userPhoneValue.setTextColor(resources.getColor(R.color.color_error));
//            } else {
//                userPhoneValue.setText(userInfo.getMobile());
//                userPhoneValue.setTextColor(resources.getColor(R.color.color_text_gray));
//            }
//            if (userInfo.getVerified().getEmail() == 0) {
//                userEmailValue.setText(unboundNote);
//                userEmailValue.setTextColor(resources.getColor(R.color.color_error));
//            } else {
//                userEmailValue.setText(userInfo.getEmail());
//                userEmailValue.setTextColor(resources.getColor(R.color.color_text_gray));
//            }
//        }

    }

    private void setText() {
        if (isZh) {
            title.setText(resources.getString(R.string.btuser_security_title_zh));
            userEmailKey.setText(resources.getString(R.string.btuser_security_email_zh));
            userPwdKey.setText(resources.getString(R.string.btuser_security_pwd_zh));
            userPhoneKey.setText(resources.getString(R.string.btuser_security_phone_zh));
            unboundNote = resources.getString(R.string.btuser_security_error_note_zh);
        } else {
            title.setText(resources.getString(R.string.btuser_security_title_en));
            userEmailKey.setText(resources.getString(R.string.btuser_security_email_en));
            userPwdKey.setText(resources.getString(R.string.btuser_security_pwd_en));
            userPhoneKey.setText(resources.getString(R.string.btuser_security_phone_en));
            unboundNote = resources.getString(R.string.btuser_security_error_note_en);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK) {
            if (requestCode == EDIT_PHONE) {
                userPhoneValue.setText(data.getStringExtra("phone"));
                userPhoneValue.setTextColor(resources.getColor(R.color.color_text_gray));
            } else if (requestCode == EDIT_EMAIL) {
                userEmailValue.setText(data.getStringExtra("email"));
                userEmailValue.setTextColor(resources.getColor(R.color.color_text_gray));
            }
        }
    }

    @Override
    protected void onLanguageChanged() {
        setText();
    }
}
