package com.beatop.btopusercenter.ui;

import android.os.Bundle;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.FeedbackResultEntity;
import com.beatop.btopbase.utils.StringHelper;
import com.beatop.btopusercenter.R;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Administrator on 2016/9/29.
 */
public class BTFeedbackActivity extends BTBaseActivity {
    private ImageView back;
    private TextView title;
    private RadioButton problemRb;
    private RadioButton suggestionRb;
    private RadioButton codeErrorRb;

    private RadioButton selectedRb;

    private EditText suggestionEt;
    private ImageView uploadPicIv;
    private TextView suggestTextCountTv;
    private EditText contactEt;
    private TextView submitTv;

    private final String PROBLEM_TYPE = "problem";
    private final String SUGGEST_TYPE = "sugg";
    private final String CODE_ERROR_TYPE = "error";

    private int textCount = 0;
    private final int MAX_SUGGEST_TEXT = 200;
    private CharSequence temp;

    private String successNote;
    private String typeEmptyNote;
    private String suggestionEmptyNote;
    private String contactEmptyNote;
    private String contactErrorNote;
    private String suggestionTooLongNote;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_activity_feedback);
        initView();

    }

    private void initView() {

        back = (ImageView) findViewById(R.id.back);
        back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        title = (TextView) findViewById(R.id.title);
        problemRb = (RadioButton) findViewById(R.id.rb_use_problem);
        problemRb.setTag(PROBLEM_TYPE);
        problemRb.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectedRb = null;
                if (problemRb.isChecked()) {
                    selectedRb = problemRb;
                }
            }
        });
        suggestionRb = (RadioButton) findViewById(R.id.rb_suggestion);
        suggestionRb.setTag(SUGGEST_TYPE);
        suggestionRb.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectedRb = null;
                if (suggestionRb.isChecked())
                    selectedRb = suggestionRb;
            }
        });
        codeErrorRb = (RadioButton) findViewById(R.id.rb_code_error);
        codeErrorRb.setTag(CODE_ERROR_TYPE);
        codeErrorRb.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectedRb = null;
                if (codeErrorRb.isChecked())
                    selectedRb = codeErrorRb;
            }
        });
        suggestionEt = (EditText) findViewById(R.id.et_suggest);
        suggestionEt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                //   Log.d(TAG, "beforeTextChanged: " + s.toString());
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                // Log.d(TAG, "onTextChanged: " + s.toString());
                temp = s;
            }

            @Override
            public void afterTextChanged(Editable s) {
                // Log.d(TAG, "afterTextChanged: " + s.toString());
                textCount = s.toString().length();
                if (textCount > 200) {
                    suggestionEt.setText(temp);
                    textCount = temp.length();
                    CharSequence text = suggestionEt.getText();
                    if (text instanceof Spannable) {
                        Spannable spannable = (Spannable) text;
                        Selection.setSelection(spannable, text.length());
                    }
                }
                suggestTextCountTv.setText(String.format("%1$d/%2$d", textCount, MAX_SUGGEST_TEXT));
            }
        });
        suggestTextCountTv = (TextView) findViewById(R.id.tv_suggest_count);
        uploadPicIv = (ImageView) findViewById(R.id.iv_pic_upload);
        uploadPicIv.setVisibility(View.INVISIBLE);
        submitTv = (TextView) findViewById(R.id.tv_submit);
        submitTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                feedback();
            }
        });
        contactEt = (EditText) findViewById(R.id.et_contact);
        setText();
    }

    private void setText() {
        if (isZh) {
            title.setText(resources.getString(R.string.btuser_feedback_title_zh));
            problemRb.setText(resources.getString(R.string.btuser_feedback_question_zh));
            suggestionRb.setText(resources.getString(R.string.btuser_feedback_suggest_zh));
            codeErrorRb.setText(resources.getString(R.string.btuser_feedback_crash_zh));
            suggestionEt.setHint(R.string.btuser_feedback_hint_zh);
            contactEt.setHint(R.string.btuser_feedback_contact_hint_zh);
            submitTv.setText(resources.getString(R.string.btuser_feedback_submit_zh));
            successNote = resources.getString(R.string.btuser_feedback_success_note_zh);
            typeEmptyNote = resources.getString(R.string.btuser_feedback_type_empty_note_zh);
            suggestionEmptyNote = resources.getString(R.string.btuser_feedback_sug_empty_note_zh);
            contactEmptyNote = resources.getString(R.string.btuser_feedback_contact_empty_note_zh);
            contactErrorNote = resources.getString(R.string.btuser_feedback_contact_error_note_zh);
            uploadPicIv.setImageResource(R.mipmap.btbase_upload_pic_zh);
        } else {
            title.setText(resources.getString(R.string.btuser_feedback_title_en));
            problemRb.setText(resources.getString(R.string.btuser_feedback_question_en));
            suggestionRb.setText(resources.getString(R.string.btuser_feedback_suggest_en));
            codeErrorRb.setText(resources.getString(R.string.btuser_feedback_crash_en));
            suggestionEt.setHint(R.string.btuser_feedback_hint_en);
            contactEt.setHint(R.string.btuser_feedback_contact_hint_en);
            submitTv.setText(resources.getString(R.string.btuser_feedback_submit_en));
            successNote = resources.getString(R.string.btuser_feedback_success_note_en);
            typeEmptyNote = resources.getString(R.string.btuser_feedback_type_empty_note_en);
            suggestionEmptyNote = resources.getString(R.string.btuser_feedback_sug_empty_note_en);
            contactEmptyNote = resources.getString(R.string.btuser_feedback_contact_empty_note_en);
            contactErrorNote = resources.getString(R.string.btuser_feedback_contact_error_note_en);
            uploadPicIv.setImageResource(R.mipmap.btbase_upload_pic_en);
        }

    }

    private void feedback() {
        if (selectedRb == null) {
            showMsg(typeEmptyNote);//must select a type
            return;
        }
        if (TextUtils.isEmpty(suggestionEt.getText().toString())) {
            showMsg(suggestionEmptyNote);//suggestion can not be empty
            return;
        }
        if (TextUtils.isEmpty(contactEt.getText().toString())) {
            showMsg(contactEmptyNote);//contact can not be empty
            return;
        }
        if (!StringHelper.checkMobile(userInfo.getArea_code(), contactEt.getText().toString()) && !StringHelper.checkEmail(contactEt.getText().toString())) {
            showMsg(contactErrorNote);
            return;
        }
        netWorkServer.feedback(contactEt.getText().toString(), (String) selectedRb.getTag(), suggestionEt.getText().toString(), null).enqueue(new Callback<FeedbackResultEntity>() {
            @Override
            public void onResponse(Call<FeedbackResultEntity> call, Response<FeedbackResultEntity> response) {
                if (response.body().getError() != null) {
                    showMsg(response.body().getError().getMessage());
                } else {
                    showMsg(successNote);
                }
            }

            @Override
            public void onFailure(Call<FeedbackResultEntity> call, Throwable t) {
                showMsg(netErrorNote);
            }
        });
    }

    @Override
    protected void onLanguageChanged() {
        setText();
    }


}
