/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopusercenter.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopbase.view.CircleImageView;
import com.beatop.btopusercenter.R;
import com.beatop.btopusercenter.ui.BTUserInfoActivity;

public class BTUserCenterActivity
extends BTBaseActivity
implements View.OnClickListener {
    private LinearLayout userPhoto;
    private CircleImageView userPhotoCircleIv;
    private TextView userNameTv;
    private RelativeLayout orderList;
    private TextView orderListTv;
    private RelativeLayout accountSafe;
    private TextView accountSafeTv;
    private RelativeLayout feedback;
    private TextView feedbackTv;
    private RelativeLayout setting;
    private TextView settingTv;
    private boolean isLogin;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btuser_activity_usercenter);
        this.isLogin = SPHelper.isLogin();
        this.initView();
    }

    protected void onLanguageChanged() {
        this.setText();
    }

    private void findView() {
        this.userPhoto = (LinearLayout)this.findViewById(R.id.user_info);
        this.userPhoto.setOnClickListener((View.OnClickListener)this);
        this.userNameTv = (TextView)this.findViewById(R.id.tv_user_name);
        this.userPhotoCircleIv = (CircleImageView)this.findViewById(R.id.iv_user_photo);
        this.orderList = (RelativeLayout)this.findViewById(R.id.booking_list);
        this.orderList.setOnClickListener((View.OnClickListener)this);
        this.orderListTv = (TextView)this.findViewById(R.id.tv_booking_list);
        this.accountSafe = (RelativeLayout)this.findViewById(R.id.account_safe);
        this.accountSafe.setOnClickListener((View.OnClickListener)this);
        this.accountSafeTv = (TextView)this.findViewById(R.id.tv_account_safe);
        this.feedback = (RelativeLayout)this.findViewById(R.id.feed_back);
        this.feedback.setOnClickListener((View.OnClickListener)this);
        this.feedbackTv = (TextView)this.findViewById(R.id.tv_feed_back);
        this.setting = (RelativeLayout)this.findViewById(R.id.app_setting);
        this.setting.setOnClickListener((View.OnClickListener)this);
        this.settingTv = (TextView)this.findViewById(R.id.tv_app_setting);
    }

    private void initView() {
        this.findView();
        this.setText();
        this.setUserInfo();
    }

    private void setText() {
        if (this.isZh) {
            this.orderListTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_orders_zh));
            this.accountSafeTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_safe_zh));
            this.feedbackTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_feedback_zh));
            this.settingTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_setting_zh));
        } else {
            this.orderListTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_orders_en));
            this.accountSafeTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_safe_en));
            this.feedbackTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_feedback_en));
            this.settingTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_setting_en));
        }
    }

    private void setUserInfo() {
        if (!this.isLogin) {
            this.userPhotoCircleIv.setImageResource(R.mipmap.btbase_user_photo);
            if (this.isZh) {
                this.userNameTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_login_zh));
            } else {
                this.userNameTv.setText((CharSequence)this.resources.getString(R.string.btuser_user_login_en));
            }
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isLogin != SPHelper.isLogin()) {
            this.isLogin = SPHelper.isLogin();
            this.setUserInfo();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.user_info) {
            Intent it = new Intent((Context)this, BTUserInfoActivity.class);
            this.startActivity(it);
            if (!this.isLogin) return;
        }
        if (!(id2 == R.id.booking_list ? this.isLogin : (id2 == R.id.account_safe ? this.isLogin : id2 == R.id.feed_back || id2 == R.id.app_setting))) return;
    }
}

