package com.beatop.btopusercenter.ui;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopusercenter.R;

/**
 * Created by Administrator on 2016/9/28.
 */
public class BTUserInfoActivity extends BTBaseActivity {
    private TextView title;
    private ImageView back;

    private RelativeLayout nickname;
    private TextView nicknameValueTv;
    private TextView nicknameKeyTv;

    private TextView userPhotoTv;
    private RelativeLayout userPhoto;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_activity_userinfo);
        initView();
    }

    @Override
    protected void onLanguageChanged() {
        setText();
    }

    private void initView() {
        title = (TextView) findViewById(R.id.title);
        back = (ImageView) findViewById(R.id.back);
        back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        nickname = (RelativeLayout) findViewById(R.id.user_nickname);
        nickname.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent it = new Intent(BTUserInfoActivity.this, BTEditNameActivity.class);
                startActivityForResult(it, 1);
            }
        });
        nicknameKeyTv = (TextView) findViewById(R.id.tv_user_nickname_title);
        nicknameValueTv = (TextView) findViewById(R.id.tv_user_nickname);


        userPhoto = (RelativeLayout) findViewById(R.id.user_photo);
        userPhoto.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
        userPhotoTv = (TextView) findViewById(R.id.tv_user_photo);
        setText();
    }

    private void setText() {
        if (isZh) {
            title.setText(resources.getString(R.string.btuser_info_title_zh));
            userPhotoTv.setText(resources.getString(R.string.btuser_info_photo_zh));
            nicknameKeyTv.setText(resources.getString(R.string.btuser_info_nickname_zh));
        } else {
            title.setText(resources.getString(R.string.btuser_info_title_en));
            userPhotoTv.setText(resources.getString(R.string.btuser_info_photo_en));
            nicknameKeyTv.setText(resources.getString(R.string.btuser_info_nickname_en));
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK && requestCode == 1) {
            nicknameValueTv.setText(data.getStringExtra("nickname"));
        }
    }
}
