package com.beatop.btopusercenter.ui;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopbase.view.CircleImageView;
import com.beatop.btopusercenter.R;

/**
 * Created by Administrator on 2016/9/28.
 */
public class BTUserCenterActivity extends BTBaseActivity implements View.OnClickListener {
    private LinearLayout userPhoto;
    private CircleImageView userPhotoCircleIv;
    private TextView userNameTv;

    private RelativeLayout orderList;
    private TextView orderListTv;

    private RelativeLayout accountSafe;
    private TextView accountSafeTv;


    private RelativeLayout feedback;
    private TextView feedbackTv;

    private RelativeLayout setting;
    private TextView settingTv;

    private boolean isLogin;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_activity_usercenter);
        isLogin = SPHelper.isLogin();
        initView();
    }

    @Override
    protected void onLanguageChanged() {
        setText();
    }

    private void findView() {
        userPhoto = (LinearLayout) findViewById(R.id.user_info);
        userPhoto.setOnClickListener(this);
        userNameTv = (TextView) findViewById(R.id.tv_user_name);
        userPhotoCircleIv = (CircleImageView) findViewById(R.id.iv_user_photo);

        orderList = (RelativeLayout) findViewById(R.id.booking_list);
        orderList.setOnClickListener(this);
        orderListTv = (TextView) findViewById(R.id.tv_booking_list);

        accountSafe = (RelativeLayout) findViewById(R.id.account_safe);
        accountSafe.setOnClickListener(this);
        accountSafeTv = (TextView) findViewById(R.id.tv_account_safe);

        feedback = (RelativeLayout) findViewById(R.id.feed_back);
        feedback.setOnClickListener(this);
        feedbackTv = (TextView) findViewById(R.id.tv_feed_back);

        setting = (RelativeLayout) findViewById(R.id.app_setting);
        setting.setOnClickListener(this);
        settingTv = (TextView) findViewById(R.id.tv_app_setting);

    }

    private void initView() {
        findView();
        setText();
        setUserInfo();
    }

    private void setText() {
        if (isZh) {
            orderListTv.setText(resources.getString(R.string.btuser_user_orders_zh));
            accountSafeTv.setText(resources.getString(R.string.btuser_user_safe_zh));
            feedbackTv.setText(resources.getString(R.string.btuser_user_feedback_zh));
            settingTv.setText(resources.getString(R.string.btuser_user_setting_zh));
        } else {
            orderListTv.setText(resources.getString(R.string.btuser_user_orders_en));
            accountSafeTv.setText(resources.getString(R.string.btuser_user_safe_en));
            feedbackTv.setText(resources.getString(R.string.btuser_user_feedback_en));
            settingTv.setText(resources.getString(R.string.btuser_user_setting_en));
        }
    }

    private void setUserInfo() {
        if (!isLogin) {
            userPhotoCircleIv.setImageResource(R.mipmap.btbase_user_photo);
            if (isZh) {
                userNameTv.setText(resources.getString(R.string.btuser_user_login_zh));
            } else {
                userNameTv.setText(resources.getString(R.string.btuser_user_login_en));
            }
        } else {
            //TODO show user info which includes user name and user photo.
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        //if login status changed!
        if (isLogin != SPHelper.isLogin()) {
            isLogin = SPHelper.isLogin();
            setUserInfo();
        }
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.user_info) {
            Intent it = new Intent(BTUserCenterActivity.this, BTUserInfoActivity.class);
            startActivity(it);
            if (isLogin) {
                //TODO goto user info activity;
            } else {
                //TODO goto login activity
            }
        } else if (id == R.id.booking_list) {
            if (isLogin) {
                //TODO goto order info web page
            } else {
                //TODO goto login activity
            }
        } else if (id == R.id.account_safe) {
            if (isLogin) {
                //TODO goto account security activity
            } else {
                //TODO goto login activity
            }
        } else if (id == R.id.feed_back) {
            //TODO goto feed back activity
        } else if (id == R.id.app_setting) {
            //TODO goto setting activity
        }

    }


}
