package com.beatop.btopusercenter.ui;

import android.app.AlertDialog;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopusercenter.R;

/**
 * Created by Administrator on 2016/9/28.
 */
public class BTEditNameActivity extends BTBaseActivity {
    private TextView cancelTv;
    private TextView title;
    private TextView saveTv;

    private EditText nickNameEt;

    private String errorNote;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btuser_edit_activity);
        initView();
    }

    private void initView() {
        cancelTv = (TextView) findViewById(R.id.tv_cancel);
        cancelTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });

        title = (TextView) findViewById(R.id.title);

        saveTv = (TextView) findViewById(R.id.tv_save);
        saveTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //TODO change user's nickname
                if (TextUtils.isEmpty(nickNameEt.getText().toString())) {
                    Toast.makeText(BTEditNameActivity.this, errorNote, Toast.LENGTH_SHORT).show();
                } else {
                    Intent it = new Intent();
                    it.putExtra("nickname", nickNameEt.getText().toString());
                    setResult(RESULT_OK, it);
                    finish();
                }
            }
        });

        nickNameEt = (EditText) findViewById(R.id.et_nickname);
        setText();

    }

    private void setText() {
        if (isZh) {
            title.setText(resources.getString(R.string.btuser_edit_title_zh));
            cancelTv.setText(resources.getString(R.string.btuser_edit_cancel_zh));
            saveTv.setText(resources.getString(R.string.btuser_edit_save_zh));
            nickNameEt.setHint(R.string.btuser_edit_note_zh);
            errorNote = resources.getString(R.string.btuser_edit_error_note_zh);
        } else {
            title.setText(resources.getString(R.string.btuser_edit_title_en));
            cancelTv.setText(resources.getString(R.string.btuser_edit_cancel_en));
            saveTv.setText(resources.getString(R.string.btuser_edit_save_en));
            nickNameEt.setHint(R.string.btuser_edit_note_en);
            errorNote = resources.getString(R.string.btuser_edit_error_note_en);
        }
    }

    @Override
    protected void onLanguageChanged() {
        setText();
    }
}
