/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btoppay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.LogoutResultEntity;
import com.beatop.btoppay.R;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.paypal.android.sdk.payments.PayPalConfiguration;
import com.paypal.android.sdk.payments.PayPalPayment;
import com.paypal.android.sdk.payments.PayPalService;
import com.paypal.android.sdk.payments.PaymentActivity;
import com.paypal.android.sdk.payments.PaymentConfirmation;
import com.pingplusplus.android.Pingpp;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTPayActivity
extends BTBaseActivity {
    private static final String CHANNEL_WECHAT = "wx";
    private static final String CHANNEL_ALIPAY = "alipay";
    private static final String CHANNEL_PAYPAL = "payPal";
    private static String YOUR_URL = "http://218.244.151.190/demo/charge";
    private static String url = "http://api.cheesedu.com/v2/order/ping_charge?extra[success_url]=www.cheesedu.com";
    private static String success_url = "http://www.cheesedu.com/order/pay_success?oid=%1$s&_Akey=%2$s&_lang=%3$s";
    private String selectedChannel = "";
    private ImageView selectedIv;
    private TextView payTv;
    private TextView serviceTv;
    private TextView title;
    private ImageView back;
    private TextView amountKeyTv;
    private TextView amountValueTv;
    private TextView currencyTv;
    private TextView choiceNoteTv;
    private TextView aliPayTv;
    private TextView wxPayTv;
    private ImageView aliPayIv;
    private ImageView wxPayIv;
    private ImageView payPalIv;
    private RelativeLayout aliPay;
    private RelativeLayout wxPay;
    private RelativeLayout payPalPay;
    private String successNote;
    private String failNote;
    private String enableNote;
    private String order_id;
    private String currency = "NZD";
    private String amount = "200";
    Map<String, String> currencyMap;
    private static final String CONFIG_ENVIRONMENT = "sandbox";
    private static final int REQUEST_CODE_PAYMENT = 1;
    private static PayPalConfiguration config = new PayPalConfiguration().environment("sandbox").clientId(PAY_PAL_CLIENT_ID);

    protected void onLanguageChanged() {
        this.setText();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btpay_activity_pay);
        Intent intent = new Intent((Context)this, PayPalService.class);
        intent.putExtra("com.paypal.android.sdk.paypalConfiguration", (Parcelable)config);
        this.startService(intent);
        this.currencyMap = new HashMap<String, String>();
        this.currencyMap.put("CNY", this.resources.getString(R.string.CNY));
        this.currencyMap.put("CNH", this.resources.getString(R.string.CNH));
        this.currencyMap.put("EUR", this.resources.getString(R.string.EUR));
        this.currencyMap.put("NZD", this.resources.getString(R.string.NZD));
        this.currencyMap.put("PHP", this.resources.getString(R.string.PHP));
        this.currencyMap.put("USD", this.resources.getString(R.string.USD));
        this.currencyMap.put("AUD", this.resources.getString(R.string.AUD));
        this.currency = this.getIntent().getStringExtra("currency");
        String amount = this.getIntent().getStringExtra("amount");
        this.order_id = this.getIntent().getStringExtra("_id");
        this.amount = String.format("%1$s%2$s", this.currencyMap.get(this.currency), amount);
        this.initView();
    }

    private void initView() {
        this.payTv = (TextView)this.findViewById(R.id.tv_pay_confirm);
        this.payTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTPayActivity.this.pingxxPay();
            }
        });
        this.serviceTv = (TextView)this.findViewById(R.id.tv_contact_service);
        this.serviceTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent it = BTPayActivity.this.isZh ? new Intent("android.intent.action.CALL", Uri.parse((String)BTBaseActivity.ONLINE_SERVICE_ZH)) : new Intent("android.intent.action.CALL", Uri.parse((String)BTBaseActivity.ONLINE_SERVICE_EN));
                if (ActivityCompat.checkSelfPermission((Context)BTPayActivity.this, (String)"android.permission.CALL_PHONE") != 0) {
                    return;
                }
                BTPayActivity.this.startActivity(it);
            }
        });
        this.title = (TextView)this.findViewById(R.id.title);
        this.back = (ImageView)this.findViewById(R.id.back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTPayActivity.this.onBackPressed();
            }
        });
        this.amountKeyTv = (TextView)this.findViewById(R.id.tv_amount_key);
        this.amountValueTv = (TextView)this.findViewById(R.id.tv_amount_value);
        this.amountValueTv.setText((CharSequence)this.amount);
        this.currencyTv = (TextView)this.findViewById(R.id.tv_currency);
        this.currencyTv.setText((CharSequence)this.currency);
        this.choiceNoteTv = (TextView)this.findViewById(R.id.tv_pay_type);
        this.aliPayTv = (TextView)this.findViewById(R.id.tv_pay_alibaba);
        this.wxPayTv = (TextView)this.findViewById(R.id.tv_pay_wx);
        this.aliPayIv = (ImageView)this.findViewById(R.id.iv_pay_alibaba_selected);
        this.wxPayIv = (ImageView)this.findViewById(R.id.iv_pay_wx_selected);
        this.payPalIv = (ImageView)this.findViewById(R.id.iv_pay_paypal_selected);
        this.aliPay = (RelativeLayout)this.findViewById(R.id.ali_pay);
        this.aliPay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTPayActivity.this.selectPayType(BTPayActivity.CHANNEL_ALIPAY);
            }
        });
        this.wxPay = (RelativeLayout)this.findViewById(R.id.wx_pay);
        this.wxPay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTPayActivity.this.selectPayType(BTPayActivity.CHANNEL_WECHAT);
            }
        });
        this.payPalPay = (RelativeLayout)this.findViewById(R.id.paypay_pay);
        this.payPalPay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTPayActivity.this.selectPayType(BTPayActivity.CHANNEL_PAYPAL);
            }
        });
        this.setText();
    }

    private void setText() {
        if (this.isZh) {
            this.title.setText((CharSequence)this.resources.getString(R.string.btpay_pay_title_zh));
            this.amountKeyTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_amount_key_zh));
            this.choiceNoteTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_choice_note_zh));
            this.aliPayTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_ali_zh));
            this.wxPayTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_wx_zh));
            this.payTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_confirm_zh));
            this.serviceTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_contact_zh));
            this.successNote = this.resources.getString(R.string.btpay_pay_success_zh);
            this.failNote = this.resources.getString(R.string.btpay_pay_fail_zh);
            this.enableNote = this.resources.getString(R.string.btpay_pay_enable_zh);
        } else {
            this.title.setText((CharSequence)this.resources.getString(R.string.btpay_pay_title_en));
            this.amountKeyTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_amount_key_en));
            this.choiceNoteTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_choice_note_en));
            this.aliPayTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_ali_en));
            this.wxPayTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_wx_en));
            this.payTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_confirm_en));
            this.serviceTv.setText((CharSequence)this.resources.getString(R.string.btpay_pay_contact_en));
            this.successNote = this.resources.getString(R.string.btpay_pay_success_en);
            this.failNote = this.resources.getString(R.string.btpay_pay_fail_en);
            this.enableNote = this.resources.getString(R.string.btpay_pay_enable_en);
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    private void pingxxPay() {
        if (TextUtils.isEmpty((CharSequence)this.selectedChannel)) {
            this.showMsg(this.choiceNoteTv.getText().toString());
            return;
        }
        if (this.selectedChannel.equals(CHANNEL_PAYPAL)) {
            this.payPal();
        } else {
            netWorkServer.pingxxPay(userInfo.get_Akey(), this.order_id, this.selectedChannel, "", "").enqueue((Callback)new Callback<Object>(){

                public void onResponse(Call<Object> call, Response<Object> response) {
                    Gson g = new Gson();
                    JsonObject o = g.toJsonTree(response.body()).getAsJsonObject();
                    Log.d((String)BTPayActivity.this.TAG, (String)("onResponse: " + o.toString()));
                    Pingpp.createPayment((Activity)BTPayActivity.this, (String)o.toString());
                }

                public void onFailure(Call<Object> call, Throwable t) {
                    Log.d((String)BTPayActivity.this.TAG, (String)"onFailure: ");
                    BTPayActivity.this.showMsg(BTPayActivity.this.netErrorNote);
                }
            });
        }
    }

    private void payPal() {
        this.onBuyPressed();
    }

    public void onBuyPressed() {
        PayPalPayment thingToBuy = this.getThingToBuy("sale");
        Intent intent = new Intent((Context)this, PaymentActivity.class);
        intent.putExtra("com.paypal.android.sdk.paypalConfiguration", (Parcelable)config);
        intent.putExtra("com.paypal.android.sdk.payment", (Parcelable)thingToBuy);
        this.startActivityForResult(intent, 1);
    }

    private PayPalPayment getThingToBuy(String paymentIntent) {
        return new PayPalPayment(new BigDecimal(this.amount.substring(1)), this.currency, "BeaTop", paymentIntent);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == Pingpp.REQUEST_CODE_PAYMENT) {
            if (resultCode == -1) {
                String result = data.getExtras().getString("pay_result");
                if (result.equals("success")) {
                    Intent it = new Intent();
                    it.putExtra("_id", this.order_id);
                    it.putExtra("_Akey", userInfo.get_Akey());
                    it.putExtra("back", false);
                    this.setResult(-1, it);
                    this.finish();
                } else if (result.equals("fail")) {
                    this.showMsg(this.failNote);
                } else if (result.equals("invalid")) {
                    this.showMsg(this.enableNote);
                }
                String errorMsg = data.getExtras().getString("error_msg");
                String extraMsg = data.getExtras().getString("extra_msg");
                Log.d((String)this.TAG, (String)("onActivityResult: " + result + errorMsg + extraMsg));
            }
        } else if (requestCode == 1) {
            if (resultCode == -1) {
                PaymentConfirmation confirm = (PaymentConfirmation)data.getParcelableExtra("com.paypal.android.sdk.paymentConfirmation");
                if (confirm != null) {
                    Log.i((String)this.TAG, (String)confirm.toJSONObject().toString());
                    Log.i((String)this.TAG, (String)confirm.getPayment().toJSONObject().toString());
                    JSONObject o = confirm.toJSONObject();
                    JSONObject p = confirm.getPayment().toJSONObject();
                    try {
                        o.put("short_description", (Object)p.getString("short_description"));
                        o.put("amount", (Object)p.getString("amount"));
                        o.put("intent", (Object)p.getString("intent"));
                        o.put("currency_code", (Object)p.getString("currency_code"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    netWorkServer.savePayPalInfo(userInfo.get_Akey(), this.order_id, o.toString()).enqueue((Callback)new Callback<LogoutResultEntity>(){

                        public void onResponse(Call<LogoutResultEntity> call, Response<LogoutResultEntity> response) {
                            if (((LogoutResultEntity)response.body()).getError() != null) {
                                Log.d((String)BTPayActivity.this.TAG, (String)("onResponse: " + ((LogoutResultEntity)response.body()).getError().getMessage()));
                                BTPayActivity.this.showMsg(((LogoutResultEntity)response.body()).getError().getMessage());
                            } else {
                                Intent it = new Intent();
                                it.putExtra("_id", BTPayActivity.this.order_id);
                                it.putExtra("_Akey", userInfo.get_Akey());
                                it.putExtra("back", false);
                                BTPayActivity.this.setResult(-1, it);
                            }
                        }

                        public void onFailure(Call<LogoutResultEntity> call, Throwable t) {
                            BTPayActivity.this.showMsg(BTPayActivity.this.netErrorNote);
                        }
                    });
                    Log.d((String)this.TAG, (String)"onActivityResult: PaymentConfirmation info received from PayPal");
                }
            } else if (resultCode == 0) {
                Log.i((String)this.TAG, (String)"The user canceled.");
            } else if (resultCode == 2) {
                Log.i((String)this.TAG, (String)"An invalid Payment or PayPalConfiguration was submitted. Please see the docs.");
            }
        }
    }

    private void selectPayType(String type) {
        if (this.selectedChannel.equals(type)) {
            return;
        }
        if (this.selectedIv != null) {
            this.selectedIv.setImageResource(R.mipmap.btbase_item_unselected);
        }
        this.selectedChannel = type;
        switch (type) {
            case "alipay": {
                this.selectedIv = this.aliPayIv;
                break;
            }
            case "payPal": {
                this.selectedIv = this.payPalIv;
                break;
            }
            case "wx": {
                this.selectedIv = this.wxPayIv;
            }
        }
        this.selectedIv.setImageResource(R.mipmap.btbase_item_selected);
    }
}

