package com.beatop.btoppay;

import android.Manifest;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.LogoutResultEntity;
import com.beatop.btopbase.utils.Router;
import com.beatop.btopbase.utils.SPHelper;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.paypal.android.sdk.payments.PayPalConfiguration;
import com.paypal.android.sdk.payments.PayPalPayment;
import com.paypal.android.sdk.payments.PayPalService;
import com.paypal.android.sdk.payments.PaymentActivity;
import com.paypal.android.sdk.payments.PaymentConfirmation;
import com.pingplusplus.android.Pingpp;

import org.json.JSONException;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


/**
 * Created by Administrator on 2016/10/13.
 */
public class BTPayActivity extends BTBaseActivity {

    private static final String CHANNEL_WECHAT = "wx";
    private static final String CHANNEL_ALIPAY = "alipay";
    private static final String CHANNEL_PAYPAL = "payPal";
    private static String YOUR_URL = "http://218.244.151.190/demo/charge";
    private static String url = "http://api.cheesedu.com/v2/order/ping_charge?extra[success_url]=www.cheesedu.com";
    private static String success_url = "http://www.cheesedu.com/order/pay_success?oid=%1$s&_Akey=%2$s&_lang=%3$s";
    //   private static final String SERVICE_PHONE = "tel:00861866812121";
    //  private final String ORDER_URL = "http://www.cheesedu.com/my/order?_Akey=%1$s&_lang=%2$s";
    private String selectedChannel = "";
    private ImageView selectedIv;

    private TextView payTv;
    private TextView serviceTv;

    private TextView title;
    private ImageView back;

    private TextView amountKeyTv;
    private TextView amountValueTv;
    private TextView currencyTv;

    private TextView choiceNoteTv;
    private TextView aliPayTv;
    private TextView wxPayTv;


    private ImageView aliPayIv;
    private ImageView wxPayIv;
    private ImageView payPalIv;

    private RelativeLayout aliPay;
    private RelativeLayout wxPay;
    private RelativeLayout payPalPay;


    private String successNote;
    private String failNote;
    private String enableNote;
    private String order_id;

    private String currency = "NZD";
    private String amount = "200";
    //
    Map<String, String> currencyMap;

    private static final String CONFIG_ENVIRONMENT = PayPalConfiguration.ENVIRONMENT_SANDBOX;

    // note that these credentials will differ between live & sandbox environments.
    //AdF-Ty0E2uTsM_l8yWPgbz3c0Iy8vVuEz7f6JUEiqbI0stDrnV-MkJN48aHFCDGscLDbmRTDo6X7nsqs
    // private static final String CONFIG_CLIENT_ID = "AQ2jVdFVe7UiUtia-YUA4ZqXbAgWmZEUyla2vBBFFIo7eS0ZjPx6SdRUHIfDQSifaZoNd93EF3ZG2n6M";
    private static final int REQUEST_CODE_PAYMENT = 1;
    private static PayPalConfiguration config = new PayPalConfiguration()
            .environment(CONFIG_ENVIRONMENT)
            .clientId(PAY_PAL_CLIENT_ID);

    @Override
    protected void onLanguageChanged() {
        setText();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btpay_activity_pay);
        Intent intent = new Intent(this, PayPalService.class);
        intent.putExtra(PayPalService.EXTRA_PAYPAL_CONFIGURATION, config);
        startService(intent);
        currencyMap = new HashMap<>();
        currencyMap.put("CNY", resources.getString(R.string.CNY));
        currencyMap.put("CNH", resources.getString(R.string.CNH));
        currencyMap.put("EUR", resources.getString(R.string.EUR));
        currencyMap.put("NZD", resources.getString(R.string.NZD));
        currencyMap.put("PHP", resources.getString(R.string.PHP));
        currencyMap.put("USD", resources.getString(R.string.USD));
        currencyMap.put("AUD", resources.getString(R.string.AUD));
        currency = getIntent().getStringExtra("currency");
        String amount = getIntent().getStringExtra("amount");
        order_id = getIntent().getStringExtra("_id");
        this.amount = String.format("%1$s%2$s", currencyMap.get(currency), amount);
        initView();
    }

    private void initView() {
        payTv = (TextView) findViewById(R.id.tv_pay_confirm);

        payTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                pingxxPay();
            }
        });

        serviceTv = (TextView) findViewById(R.id.tv_contact_service);
        serviceTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent it;
                if (isZh) {
                    it = new Intent(Intent.ACTION_CALL, Uri.parse(ONLINE_SERVICE_ZH));
                } else {
                    it = new Intent(Intent.ACTION_CALL, Uri.parse(ONLINE_SERVICE_EN));
                }
                if (ActivityCompat.checkSelfPermission(BTPayActivity.this, Manifest.permission.CALL_PHONE) != PackageManager.PERMISSION_GRANTED) {
                    return;
                }
                startActivity(it);
            }
        });

        title = (TextView) findViewById(R.id.title);
        back = (ImageView) findViewById(R.id.back);
        back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });

        amountKeyTv = (TextView) findViewById(R.id.tv_amount_key);
        amountValueTv = (TextView) findViewById(R.id.tv_amount_value);
        amountValueTv.setText(amount);
        currencyTv = (TextView) findViewById(R.id.tv_currency);
        currencyTv.setText(currency);

        choiceNoteTv = (TextView) findViewById(R.id.tv_pay_type);
        aliPayTv = (TextView) findViewById(R.id.tv_pay_alibaba);
        wxPayTv = (TextView) findViewById(R.id.tv_pay_wx);

        aliPayIv = (ImageView) findViewById(R.id.iv_pay_alibaba_selected);
        wxPayIv = (ImageView) findViewById(R.id.iv_pay_wx_selected);
        payPalIv = (ImageView) findViewById(R.id.iv_pay_paypal_selected);

        aliPay = (RelativeLayout) findViewById(R.id.ali_pay);
        aliPay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectPayType(CHANNEL_ALIPAY);
            }
        });
        wxPay = (RelativeLayout) findViewById(R.id.wx_pay);
        wxPay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectPayType(CHANNEL_WECHAT);
            }
        });

        payPalPay = (RelativeLayout) findViewById(R.id.paypay_pay);
        payPalPay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectPayType(CHANNEL_PAYPAL);
            }
        });
        setText();

    }

    private void setText() {
        if (isZh) {
            title.setText(resources.getString(R.string.btpay_pay_title_zh));
            amountKeyTv.setText(resources.getString(R.string.btpay_pay_amount_key_zh));
            choiceNoteTv.setText(resources.getString(R.string.btpay_pay_choice_note_zh));
            aliPayTv.setText(resources.getString(R.string.btpay_pay_ali_zh));
            wxPayTv.setText(resources.getString(R.string.btpay_pay_wx_zh));
            payTv.setText(resources.getString(R.string.btpay_pay_confirm_zh));
            serviceTv.setText(resources.getString(R.string.btpay_pay_contact_zh));
            successNote = resources.getString(R.string.btpay_pay_success_zh);
            failNote = resources.getString(R.string.btpay_pay_fail_zh);
            enableNote = resources.getString(R.string.btpay_pay_enable_zh);

        } else {
            title.setText(resources.getString(R.string.btpay_pay_title_en));
            amountKeyTv.setText(resources.getString(R.string.btpay_pay_amount_key_en));
            choiceNoteTv.setText(resources.getString(R.string.btpay_pay_choice_note_en));
            aliPayTv.setText(resources.getString(R.string.btpay_pay_ali_en));
            wxPayTv.setText(resources.getString(R.string.btpay_pay_wx_en));
            payTv.setText(resources.getString(R.string.btpay_pay_confirm_en));
            serviceTv.setText(resources.getString(R.string.btpay_pay_contact_en));
            successNote = resources.getString(R.string.btpay_pay_success_en);
            failNote = resources.getString(R.string.btpay_pay_fail_en);
            enableNote = resources.getString(R.string.btpay_pay_enable_en);
        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
//        Bundle bundle = new Bundle();
//        bundle.putString("url", String.format(ORDER_URL, userInfo.get_Akey(), SPHelper.getLanguageSetting()));
//        Router.sharedRouter().open("btop://web/btTitleWebActivity", bundle);
    }

    private void pingxxPay() {
        if (TextUtils.isEmpty(selectedChannel)) {
            showMsg(choiceNoteTv.getText().toString());
            return;
        }
        if (selectedChannel.equals(CHANNEL_PAYPAL)) {
            payPal();
        } else {
            netWorkServer.pingxxPay(userInfo.get_Akey(), order_id, selectedChannel, "", "").enqueue(new Callback<Object>() {
                //    netWorkServer.pingxxPay("dev_Auser_434891_phone_66056025", "57ce52fe4272a64f050d4bd4", selectedChannel, "", "").enqueue(new Callback<Object>() {
                @Override
                public void onResponse(Call<Object> call, Response<Object> response) {
                    Gson g = new Gson();
                    JsonObject o = g.toJsonTree(response.body()).getAsJsonObject();
                    Log.d(TAG, "onResponse: " + o.toString());
                    Pingpp.createPayment(BTPayActivity.this, o.toString());
                }

                @Override
                public void onFailure(Call<Object> call, Throwable t) {
                    Log.d(TAG, "onFailure: ");
                    showMsg(netErrorNote);
                }
            });
        }
    }

    private void payPal() {
//        Intent it = new Intent(this, PayPalTest.class);
//        startActivity(it);
        onBuyPressed();
    }

    public void onBuyPressed() {
        /*
         * PAYMENT_INTENT_SALE will cause the payment to complete immediately.
         * Change PAYMENT_INTENT_SALE to
         *   - PAYMENT_INTENT_AUTHORIZE to only authorize payment and capture funds later.
         *   - PAYMENT_INTENT_ORDER to create a payment for authorization and capture
         *     later via calls from your server.
         *
         * Also, to include additional payment details and an item list, see getStuffToBuy() below.
         */
        PayPalPayment thingToBuy = getThingToBuy(PayPalPayment.PAYMENT_INTENT_SALE);

        /*
         * See getStuffToBuy(..) for examples of some available payment options.
         */

        Intent intent = new Intent(this, PaymentActivity.class);

        // send the same configuration for restart resiliency
        intent.putExtra(PayPalService.EXTRA_PAYPAL_CONFIGURATION, config);

        intent.putExtra(PaymentActivity.EXTRA_PAYMENT, thingToBuy);

        startActivityForResult(intent, REQUEST_CODE_PAYMENT);
    }

    private PayPalPayment getThingToBuy(String paymentIntent) {
        return new PayPalPayment(new BigDecimal(amount.substring(1)), currency, "BeaTop",
                paymentIntent);
    }


    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == Pingpp.REQUEST_CODE_PAYMENT) {
            if (resultCode == Activity.RESULT_OK) {
                String result = data.getExtras().getString("pay_result");
                if (result.equals("success")) {
//                    Bundle it = new Bundle();
//                    it.putBoolean("back", false);
//                    if (isZh) {
//                        it.putString("url", String.format(PAY_SUCCESS_URL, order_id, userInfo.get_Akey(), "zh"));
//                    } else {
//                        it.putString("url", String.format(PAY_SUCCESS_URL, order_id, userInfo.get_Akey(), "en"));
//                    }
                    //Router.sharedRouter().open("btop://web/btTitleWebActivity", it);
                    Intent it = new Intent();
                    it.putExtra("_id", order_id);
                    it.putExtra("_Akey", userInfo.get_Akey());
                    it.putExtra("back", false);
                    setResult(RESULT_OK, it);
                    finish();
                } else if (result.equals("fail")) {
                    showMsg(failNote);
                } else if (result.equals("invalid")) {
                    showMsg(enableNote);
                }
                /* handle result value
                 * "success" - payment succeed
                 * "fail"    - payment failed
                 * "cancel"  - user canceld
                 * "invalid" - payment plugin not installed
                 */
                String errorMsg = data.getExtras().getString("error_msg"); // error info
                String extraMsg = data.getExtras().getString("extra_msg"); // error info
                Log.d(TAG, "onActivityResult: " + result + errorMsg + extraMsg);
            }
        } else if (requestCode == REQUEST_CODE_PAYMENT) {
            if (resultCode == Activity.RESULT_OK) {
                PaymentConfirmation confirm =
                        data.getParcelableExtra(PaymentActivity.EXTRA_RESULT_CONFIRMATION);
                if (confirm != null) {
                    Log.i(TAG, confirm.toJSONObject().toString());
                    Log.i(TAG, confirm.getPayment().toJSONObject().toString());
                    JSONObject o = confirm.toJSONObject();
                    JSONObject p = confirm.getPayment().toJSONObject();
                    try {
                        o.put("short_description", p.getString("short_description"));
                        o.put("amount", p.getString("amount"));
                        o.put("intent", p.getString("intent"));
                        o.put("currency_code", p.getString("currency_code"));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    //   Log.d(TAG, "onActivityResult: " + o.toString());
                    /**
                     * or consent completion.
                     * See https://developer.paypal.com/webapps/developer/docs/integration/mobile/verify-mobile-payment/
                     * for more details.
                     *
                     * For sample mobile backend interactions, see
                     * https://github.com/paypal/rest-api-sdk-python/tree/master/samples/mobile_backend
                     */
                    // displayResultText("PaymentConfirmation info received from PayPal");
                    netWorkServer.savePayPalInfo(userInfo.get_Akey(), order_id, o.toString()).enqueue(new Callback<LogoutResultEntity>() {
                        //     netWorkServer.savePayPayInfo("dev_Auser_310851_android_98553576", "57ce52fe4272a64f050d4bd4", o.toString()).enqueue(new Callback<LogoutResultEntity>() {
                        @Override
                        public void onResponse(Call<LogoutResultEntity> call, Response<LogoutResultEntity> response) {
                            if (response.body().getError() != null) {
                                Log.d(TAG, "onResponse: " + response.body().getError().getMessage());
                                showMsg(response.body().getError().getMessage());
                            } else {
//                                Bundle it = new Bundle();
//                                it.putBoolean("back", false);
//                                if (isZh) {
//                                    it.putString("url", String.format(PAY_SUCCESS_URL, order_id, userInfo.get_Akey(), "zh"));
//                                } else {
//                                    it.putString("url", String.format(PAY_SUCCESS_URL, order_id, userInfo.get_Akey(), "en"));
//                                }
                                //   Router.sharedRouter().open("btop://web/btTitleWebActivity", it);
                                Intent it = new Intent();
                                it.putExtra("_id", order_id);
                                it.putExtra("_Akey", userInfo.get_Akey());
                                it.putExtra("back", false);
                                setResult(RESULT_OK, it);
                            }
                        }

                        @Override
                        public void onFailure(Call<LogoutResultEntity> call, Throwable t) {
                            showMsg(netErrorNote);
                        }
                    });
                    Log.d(TAG, "onActivityResult: PaymentConfirmation info received from PayPal");


                }
            } else if (resultCode == Activity.RESULT_CANCELED) {
                Log.i(TAG, "The user canceled.");
            } else if (resultCode == PaymentActivity.RESULT_EXTRAS_INVALID) {
                Log.i(
                        TAG,
                        "An invalid Payment or PayPalConfiguration was submitted. Please see the docs.");
            }
        }
    }

    private void selectPayType(String type) {
        if (selectedChannel.equals(type)) {
            return;
        }
        if (selectedIv != null) {
            selectedIv.setImageResource(R.mipmap.btbase_item_unselected);
        }

        selectedChannel = type;
        switch (type) {
            case CHANNEL_ALIPAY:
                selectedIv = aliPayIv;
                break;
            case CHANNEL_PAYPAL:
                selectedIv = payPalIv;
                break;
            case CHANNEL_WECHAT:
                selectedIv = wxPayIv;
                break;
        }
        selectedIv.setImageResource(R.mipmap.btbase_item_selected);
    }


}
