/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btoppay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.beatop.btoppay.R;
import com.paypal.android.sdk.payments.PayPalAuthorization;
import com.paypal.android.sdk.payments.PayPalConfiguration;
import com.paypal.android.sdk.payments.PayPalFuturePaymentActivity;
import com.paypal.android.sdk.payments.PayPalItem;
import com.paypal.android.sdk.payments.PayPalOAuthScopes;
import com.paypal.android.sdk.payments.PayPalPayment;
import com.paypal.android.sdk.payments.PayPalPaymentDetails;
import com.paypal.android.sdk.payments.PayPalProfileSharingActivity;
import com.paypal.android.sdk.payments.PayPalService;
import com.paypal.android.sdk.payments.PaymentActivity;
import com.paypal.android.sdk.payments.PaymentConfirmation;
import com.paypal.android.sdk.payments.ShippingAddress;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONException;

public class PayPalTest
extends Activity {
    private static final String TAG = "paymentExample";
    private static final String CONFIG_ENVIRONMENT = "sandbox";
    private static final String CONFIG_CLIENT_ID = "AQ2jVdFVe7UiUtia-YUA4ZqXbAgWmZEUyla2vBBFFIo7eS0ZjPx6SdRUHIfDQSifaZoNd93EF3ZG2n6M";
    private static final int REQUEST_CODE_PAYMENT = 1;
    private static final int REQUEST_CODE_FUTURE_PAYMENT = 2;
    private static final int REQUEST_CODE_PROFILE_SHARING = 3;
    private static PayPalConfiguration config = new PayPalConfiguration().environment("sandbox").clientId("AQ2jVdFVe7UiUtia-YUA4ZqXbAgWmZEUyla2vBBFFIo7eS0ZjPx6SdRUHIfDQSifaZoNd93EF3ZG2n6M");

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btpay_activity_main);
        Intent intent = new Intent((Context)this, PayPalService.class);
        intent.putExtra("com.paypal.android.sdk.paypalConfiguration", (Parcelable)config);
        this.startService(intent);
    }

    public void onBuyPressed(View pressed) {
        PayPalPayment thingToBuy = this.getThingToBuy("sale");
        Intent intent = new Intent((Context)this, PaymentActivity.class);
        intent.putExtra("com.paypal.android.sdk.paypalConfiguration", (Parcelable)config);
        intent.putExtra("com.paypal.android.sdk.payment", (Parcelable)thingToBuy);
        this.startActivityForResult(intent, 1);
    }

    private PayPalPayment getThingToBuy(String paymentIntent) {
        return new PayPalPayment(new BigDecimal("0.01"), "USD", "sample item", paymentIntent);
    }

    private PayPalPayment getStuffToBuy(String paymentIntent) {
        PayPalItem[] items = new PayPalItem[]{new PayPalItem("sample item #1", Integer.valueOf(2), new BigDecimal("87.50"), "USD", "sku-12345678"), new PayPalItem("free sample item #2", Integer.valueOf(1), new BigDecimal("0.00"), "USD", "sku-zero-price"), new PayPalItem("sample item #3 with a longer name", Integer.valueOf(6), new BigDecimal("37.99"), "USD", "sku-33333")};
        BigDecimal subtotal = PayPalItem.getItemTotal((PayPalItem[])items);
        BigDecimal shipping = new BigDecimal("7.21");
        BigDecimal tax = new BigDecimal("4.67");
        PayPalPaymentDetails paymentDetails = new PayPalPaymentDetails(shipping, subtotal, tax);
        BigDecimal amount = subtotal.add(shipping).add(tax);
        PayPalPayment payment = new PayPalPayment(amount, "USD", "sample item", paymentIntent);
        payment.items(items).paymentDetails(paymentDetails);
        payment.custom("This is text that will be associated with the payment that the app can use.");
        return payment;
    }

    private void addAppProvidedShippingAddress(PayPalPayment paypalPayment) {
        ShippingAddress shippingAddress = new ShippingAddress().recipientName("Mom Parker").line1("52 North Main St.").city("Austin").state("TX").postalCode("78729").countryCode("US");
        paypalPayment.providedShippingAddress(shippingAddress);
    }

    private void enableShippingAddressRetrieval(PayPalPayment paypalPayment, boolean enable) {
        paypalPayment.enablePayPalShippingAddressesRetrieval(enable);
    }

    public void onFuturePaymentPressed(View pressed) {
        Intent intent = new Intent((Context)this, PayPalFuturePaymentActivity.class);
        intent.putExtra("com.paypal.android.sdk.paypalConfiguration", (Parcelable)config);
        this.startActivityForResult(intent, 2);
    }

    public void onProfileSharingPressed(View pressed) {
        Intent intent = new Intent((Context)this, PayPalProfileSharingActivity.class);
        intent.putExtra("com.paypal.android.sdk.paypalConfiguration", (Parcelable)config);
        intent.putExtra("com.paypal.android.sdk.requested_scopes", (Parcelable)this.getOauthScopes());
        this.startActivityForResult(intent, 3);
    }

    private PayPalOAuthScopes getOauthScopes() {
        HashSet<String> scopes = new HashSet<String>(Arrays.asList(PayPalOAuthScopes.PAYPAL_SCOPE_EMAIL, PayPalOAuthScopes.PAYPAL_SCOPE_ADDRESS));
        return new PayPalOAuthScopes(scopes);
    }

    protected void displayResultText(String result) {
        ((TextView)this.findViewById(R.id.txtResult)).setText((CharSequence)("Result : " + result));
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)result, (int)1).show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1) {
            if (resultCode == -1) {
                PaymentConfirmation confirm = (PaymentConfirmation)data.getParcelableExtra("com.paypal.android.sdk.paymentConfirmation");
                if (confirm != null) {
                    try {
                        Log.i((String)TAG, (String)confirm.toJSONObject().toString(4));
                        Log.i((String)TAG, (String)confirm.getPayment().toJSONObject().toString(4));
                        this.displayResultText("PaymentConfirmation info received from PayPal");
                    }
                    catch (JSONException e) {
                        Log.e((String)TAG, (String)"an extremely unlikely failure occurred: ", (Throwable)e);
                    }
                }
            } else if (resultCode == 0) {
                Log.i((String)TAG, (String)"The user canceled.");
            } else if (resultCode == 2) {
                Log.i((String)TAG, (String)"An invalid Payment or PayPalConfiguration was submitted. Please see the docs.");
            }
        } else if (requestCode == 2) {
            if (resultCode == -1) {
                PayPalAuthorization auth = (PayPalAuthorization)data.getParcelableExtra("com.paypal.android.sdk.authorization");
                if (auth != null) {
                    try {
                        Log.i((String)"FuturePaymentExample", (String)auth.toJSONObject().toString(4));
                        String authorization_code = auth.getAuthorizationCode();
                        Log.i((String)"FuturePaymentExample", (String)authorization_code);
                        this.sendAuthorizationToServer(auth);
                        this.displayResultText("Future Payment code received from PayPal");
                    }
                    catch (JSONException e) {
                        Log.e((String)"FuturePaymentExample", (String)"an extremely unlikely failure occurred: ", (Throwable)e);
                    }
                }
            } else if (resultCode == 0) {
                Log.i((String)"FuturePaymentExample", (String)"The user canceled.");
            } else if (resultCode == 2) {
                Log.i((String)"FuturePaymentExample", (String)"Probably the attempt to previously start the PayPalService had an invalid PayPalConfiguration. Please see the docs.");
            }
        } else if (requestCode == 3) {
            if (resultCode == -1) {
                PayPalAuthorization auth = (PayPalAuthorization)data.getParcelableExtra("com.paypal.android.sdk.authorization");
                if (auth != null) {
                    try {
                        Log.i((String)"ProfileSharingExample", (String)auth.toJSONObject().toString(4));
                        String authorization_code = auth.getAuthorizationCode();
                        Log.i((String)"ProfileSharingExample", (String)authorization_code);
                        this.sendAuthorizationToServer(auth);
                        this.displayResultText("Profile Sharing code received from PayPal");
                    }
                    catch (JSONException e) {
                        Log.e((String)"ProfileSharingExample", (String)"an extremely unlikely failure occurred: ", (Throwable)e);
                    }
                }
            } else if (resultCode == 0) {
                Log.i((String)"ProfileSharingExample", (String)"The user canceled.");
            } else if (resultCode == 2) {
                Log.i((String)"ProfileSharingExample", (String)"Probably the attempt to previously start the PayPalService had an invalid PayPalConfiguration. Please see the docs.");
            }
        }
    }

    private void sendAuthorizationToServer(PayPalAuthorization authorization) {
    }

    public void onFuturePaymentPurchasePressed(View pressed) {
        String metadataId = PayPalConfiguration.getClientMetadataId((Context)this);
        Log.i((String)"FuturePaymentExample", (String)("Client Metadata ID: " + metadataId));
        this.displayResultText("Client Metadata Id received from SDK");
    }

    public void onDestroy() {
        this.stopService(new Intent((Context)this, PayPalService.class));
        super.onDestroy();
    }
}

