/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopbase.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class Router {
    private static final Router _router = new Router();
    private final Map<String, RouterOptions> _routes = new HashMap<String, RouterOptions>();
    private String _rootUrl = null;
    private final Map<String, RouterParams> _cachedRoutes = new HashMap<String, RouterParams>();
    private Context _context;

    public static Router sharedRouter() {
        return _router;
    }

    public Router() {
    }

    public Router(Context context) {
        this.setContext(context);
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public Context getContext() {
        return this._context;
    }

    public void map(String format, RouterCallback callback) {
        RouterOptions options = new RouterOptions();
        options.setCallback(callback);
        this.map(format, null, options);
    }

    public void map(String format, Class<? extends Activity> klass) {
        this.map(format, klass, null);
    }

    public void map(String format, Class<? extends Activity> klass, RouterOptions options) {
        if (options == null) {
            options = new RouterOptions();
        }
        options.setOpenClass(klass);
        this._routes.put(format, options);
    }

    public void setRootUrl(String rootUrl) {
        this._rootUrl = rootUrl;
    }

    public String getRootUrl() {
        return this._rootUrl;
    }

    public void openExternal(String url) {
        this.openExternal(url, this._context);
    }

    public void openExternal(String url, Context context) {
        this.openExternal(url, null, context);
    }

    public void openExternal(String url, Bundle extras) {
        this.openExternal(url, extras, this._context);
    }

    public void openExternal(String url, Bundle extras, Context context) {
        if (context == null) {
            throw new ContextNotProvided("You need to supply a context for Router " + this.toString());
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.addFlagsToIntent(intent, context);
        if (extras != null) {
            intent.putExtras(extras);
        }
        context.startActivity(intent);
    }

    public void open(String url) {
        this.open(url, this._context);
    }

    public void open(String url, Bundle extras) {
        this.open(url, extras, this._context);
    }

    public void open(String url, Context context) {
        this.open(url, null, context);
    }

    public void open(String url, Bundle extras, Context context) {
        if (context == null) {
            throw new ContextNotProvided("You need to supply a context for Router " + this.toString());
        }
        RouterParams params = this.paramsForUrl(url);
        RouterOptions options = params.routerOptions;
        if (options.getCallback() != null) {
            RouteContext routeContext = new RouteContext(params.openParams, extras, context);
            options.getCallback().run(routeContext);
            return;
        }
        Intent intent = this.intentFor(context, params);
        if (intent == null) {
            return;
        }
        if (extras != null) {
            intent.putExtras(extras);
        }
        context.startActivity(intent);
    }

    public void openForResult(String url, int requestCode, Activity context) {
        this.openForResult(url, requestCode, null, context);
    }

    public void openForResult(String url, int requestCode, Bundle extras, Activity context) {
        if (context == null) {
            throw new ContextNotProvided("You need to supply a context for Router " + this.toString());
        }
        RouterParams params = this.paramsForUrl(url);
        RouterOptions options = params.routerOptions;
        if (options.getCallback() != null) {
            RouteContext routeContext = new RouteContext(params.openParams, extras, (Context)context);
            options.getCallback().run(routeContext);
            return;
        }
        Intent intent = this.intentFor((Context)context, params);
        if (intent == null) {
            return;
        }
        if (extras != null) {
            intent.putExtras(extras);
        }
        context.startActivityForResult(intent, requestCode);
    }

    private void addFlagsToIntent(Intent intent, Context context) {
        if (context == this._context) {
            intent.addFlags(0x10000000);
        }
    }

    public Intent intentFor(String url) {
        RouterParams params = this.paramsForUrl(url);
        return this.intentFor(params);
    }

    private Intent intentFor(RouterParams params) {
        RouterOptions options = params.routerOptions;
        Intent intent = new Intent();
        if (options.getDefaultParams() != null) {
            for (Map.Entry<String, String> entry : options.getDefaultParams().entrySet()) {
                intent.putExtra(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<String, String> entry : params.openParams.entrySet()) {
            intent.putExtra(entry.getKey(), entry.getValue());
        }
        return intent;
    }

    public boolean isCallbackUrl(String url) {
        RouterParams params = this.paramsForUrl(url);
        RouterOptions options = params.routerOptions;
        return options.getCallback() != null;
    }

    public Intent intentFor(Context context, String url) {
        RouterParams params = this.paramsForUrl(url);
        return this.intentFor(context, params);
    }

    private Intent intentFor(Context context, RouterParams params) {
        RouterOptions options = params.routerOptions;
        if (options.getCallback() != null) {
            return null;
        }
        Intent intent = this.intentFor(params);
        intent.setClass(context, options.getOpenClass());
        this.addFlagsToIntent(intent, context);
        return intent;
    }

    private RouterParams paramsForUrl(String url) {
        String cleanedUrl = this.cleanUrl(url);
        URI parsedUri = URI.create("http://tempuri.org/" + cleanedUrl);
        String urlPath = parsedUri.getPath().substring(1);
        if (this._cachedRoutes.get(cleanedUrl) != null) {
            return this._cachedRoutes.get(cleanedUrl);
        }
        String[] givenParts = urlPath.split("/");
        RouterParams routerParams = null;
        for (Map.Entry<String, RouterOptions> entry : this._routes.entrySet()) {
            Map<String, String> givenParams;
            String routerUrl = this.cleanUrl(entry.getKey());
            RouterOptions routerOptions = entry.getValue();
            String[] routerParts = routerUrl.split("/");
            if (routerParts.length != givenParts.length || (givenParams = this.urlToParamsMap(givenParts, routerParts)) == null) continue;
            routerParams = new RouterParams();
            routerParams.openParams = givenParams;
            routerParams.routerOptions = routerOptions;
            break;
        }
        if (routerParams == null) {
            throw new RouteNotFoundException("No route found for url " + url);
        }
        List query = URLEncodedUtils.parse((URI)parsedUri, (String)"utf-8");
        for (NameValuePair pair : query) {
            routerParams.openParams.put(pair.getName(), pair.getValue());
        }
        this._cachedRoutes.put(cleanedUrl, routerParams);
        return routerParams;
    }

    private Map<String, String> urlToParamsMap(String[] givenUrlSegments, String[] routerUrlSegments) {
        HashMap<String, String> formatParams = new HashMap<String, String>();
        for (int index = 0; index < routerUrlSegments.length; ++index) {
            String routerPart = routerUrlSegments[index];
            String givenPart = givenUrlSegments[index];
            if (!TextUtils.isEmpty((CharSequence)routerPart) && routerPart.charAt(0) == ':') {
                String key = routerPart.substring(1, routerPart.length());
                formatParams.put(key, givenPart);
                continue;
            }
            if (routerPart.equals(givenPart)) continue;
            return null;
        }
        return formatParams;
    }

    private String cleanUrl(String url) {
        if (url.startsWith("/")) {
            return url.substring(1, url.length());
        }
        return url;
    }

    public static class ContextNotProvided
    extends RuntimeException {
        private static final long serialVersionUID = -1381427067387547157L;

        public ContextNotProvided(String message) {
            super(message);
        }
    }

    public static class RouteNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = -2278644339983544651L;

        public RouteNotFoundException(String message) {
            super(message);
        }
    }

    private static class RouterParams {
        public RouterOptions routerOptions;
        public Map<String, String> openParams;

        private RouterParams() {
        }
    }

    public static class RouterOptions {
        Class<? extends Activity> _klass;
        RouterCallback _callback;
        Map<String, String> _defaultParams;

        public RouterOptions() {
        }

        public RouterOptions(Class<? extends Activity> klass) {
            this.setOpenClass(klass);
        }

        public RouterOptions(Map<String, String> defaultParams) {
            this.setDefaultParams(defaultParams);
        }

        public RouterOptions(Map<String, String> defaultParams, Class<? extends Activity> klass) {
            this.setDefaultParams(defaultParams);
            this.setOpenClass(klass);
        }

        public void setOpenClass(Class<? extends Activity> klass) {
            this._klass = klass;
        }

        public Class<? extends Activity> getOpenClass() {
            return this._klass;
        }

        public RouterCallback getCallback() {
            return this._callback;
        }

        public void setCallback(RouterCallback callback) {
            this._callback = callback;
        }

        public void setDefaultParams(Map<String, String> defaultParams) {
            this._defaultParams = defaultParams;
        }

        public Map<String, String> getDefaultParams() {
            return this._defaultParams;
        }
    }

    public class RouteContext {
        Map<String, String> _params;
        Bundle _extras;
        Context _context;

        public RouteContext(Map<String, String> params, Bundle extras, Context context) {
            this._params = params;
            this._extras = extras;
            this._context = context;
        }

        public Map<String, String> getParams() {
            return this._params;
        }

        public Bundle getExtras() {
            return this._extras;
        }

        public Context getContext() {
            return this._context;
        }
    }

    public static abstract class RouterCallback {
        public abstract void run(RouteContext var1);
    }
}

