/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopbase.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    private static final String TAG = "BeaTop::BitmapUtils";

    @TargetApi(value=19)
    public static String getImageAbsolutePath(Activity context, Uri imageUri) {
        if (context == null || imageUri == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)imageUri)) {
            if (BitmapUtils.isExternalStorageDocument(imageUri)) {
                String docId = DocumentsContract.getDocumentId((Uri)imageUri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (BitmapUtils.isDownloadsDocument(imageUri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)imageUri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return BitmapUtils.getDataColumn((Context)context, contentUri, null, null);
                }
                if (BitmapUtils.isMediaDocument(imageUri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)imageUri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return BitmapUtils.getDataColumn((Context)context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(imageUri.getScheme())) {
                if (BitmapUtils.isGooglePhotosUri(imageUri)) {
                    return imageUri.getLastPathSegment();
                }
                return BitmapUtils.getDataColumn((Context)context, imageUri, null, null);
            }
            if ("file".equalsIgnoreCase(imageUri.getScheme())) {
                return imageUri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{column};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow(column);
                String string2 = cursor.getString(index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public static String getThumbnailPath(Context context, Uri uri) {
        ContentResolver cr = context.getContentResolver();
        String[] projection = new String[]{"_id", "image_id", "_data"};
        String docId = DocumentsContract.getDocumentId((Uri)uri);
        String[] split = docId.split(":");
        String type = split[0];
        String _id = split[1];
        String selection = "image_id=?";
        String[] selectionArgs = new String[]{split[1]};
        try (Cursor cursor = cr.query(MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, projection, selection, selectionArgs, null);){
            if (cursor != null && cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndex("_data"));
                return string2;
            }
        }
        return null;
    }

    public static String compressAndSave(String srcPath, String targetPath, Context context) {
        String name = srcPath.substring(srcPath.lastIndexOf("/") + 1);
        String simpleName = System.currentTimeMillis() + "compressed";
        ByteArrayOutputStream baos = BitmapUtils.getCompressStream(srcPath, context);
        if (baos == null) {
            return srcPath;
        }
        File dir = new File(targetPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            File target = new File(targetPath + "/" + simpleName + ".jpeg");
            FileOutputStream fos = new FileOutputStream(target);
            name = target.getAbsolutePath();
            baos.writeTo(fos);
            fos.close();
            baos.flush();
            baos.close();
            return name;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ByteArrayOutputStream getCompressStream(String srcPath, Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager manager = (WindowManager)context.getSystemService("window");
        manager.getDefaultDisplay().getMetrics(dm);
        float hh = dm.heightPixels;
        float ww = dm.widthPixels;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)opts);
        opts.inJustDecodeBounds = false;
        int w = opts.outWidth;
        int h = opts.outHeight;
        int size = 0;
        if ((float)w <= ww && (float)h <= hh) {
            size = 1;
        } else {
            double scale = w >= h ? (double)((float)w / ww) : (double)((float)h / hh);
            double log = Math.log(scale) / Math.log(2.0);
            double logCeil = Math.ceil(log);
            size = (int)Math.pow(2.0, logCeil);
        }
        opts.inSampleSize = size;
        bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)opts);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int quality = 100;
        bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
        if (baos.toByteArray().length < 102400) {
            bitmap.recycle();
            try {
                baos.flush();
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Log.d((String)TAG, (String)"getCompressStream: do not need compressed");
            return null;
        }
        while (baos.toByteArray().length > 102400) {
            baos.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
            if ((quality -= 20) >= 0) continue;
            quality = 1;
        }
        try {
            bitmap.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baos;
    }

    public static Bitmap compress(String srcPath, Context context) {
        ByteArrayOutputStream baos = BitmapUtils.getCompressStream(srcPath, context);
        if (baos == null) {
            return BitmapFactory.decodeFile((String)srcPath);
        }
        Bitmap bit = BitmapFactory.decodeStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        try {
            baos.flush();
            baos.close();
        }
        catch (Exception e) {
            e.toString();
        }
        return bit;
    }
}

