/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopbase;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.beatop.btopbase.R;
import com.beatop.btopbase.module.CountryEntity;
import com.beatop.btopbase.utils.PinyinUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CountryListAdapter
extends BaseAdapter {
    private boolean isZh;
    private Context context;
    private List<CountryEntity> countryEntities;
    private OnItemClick onItemClick;

    public CountryListAdapter(Context context, List<CountryEntity> countryEntities, boolean isZh, OnItemClick onItemClick) {
        this.context = context;
        this.countryEntities = countryEntities;
        this.isZh = isZh;
        this.onItemClick = onItemClick;
        if (isZh) {
            Collections.sort(this.countryEntities, new Comparator<CountryEntity>(){

                @Override
                public int compare(CountryEntity lhs, CountryEntity rhs) {
                    return PinyinUtils.getPingYin(lhs.getZh()).compareToIgnoreCase(PinyinUtils.getPingYin(rhs.getZh()));
                }
            });
        } else {
            Collections.sort(this.countryEntities, new Comparator<CountryEntity>(){

                @Override
                public int compare(CountryEntity lhs, CountryEntity rhs) {
                    return lhs.getEn().compareToIgnoreCase(rhs.getEn());
                }
            });
        }
    }

    public void update(boolean isZh, List<CountryEntity> countries) {
        if (this.isZh == isZh && this.countryEntities == countries) {
            return;
        }
        this.isZh = isZh;
        this.countryEntities = countries;
        if (isZh) {
            Collections.sort(this.countryEntities, new Comparator<CountryEntity>(){

                @Override
                public int compare(CountryEntity lhs, CountryEntity rhs) {
                    return PinyinUtils.getPingYin(lhs.getZh()).compareToIgnoreCase(PinyinUtils.getPingYin(rhs.getZh()));
                }
            });
        } else {
            Collections.sort(this.countryEntities, new Comparator<CountryEntity>(){

                @Override
                public int compare(CountryEntity lhs, CountryEntity rhs) {
                    return lhs.getEn().compareToIgnoreCase(rhs.getEn());
                }
            });
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.countryEntities.size();
    }

    public Object getItem(int position) {
        return this.countryEntities.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        final CountryEntity country = this.countryEntities.get(position);
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.btbase_list_countrylist_value, null);
            holder.firstLetterTv = (TextView)convertView.findViewById(R.id.tv_key);
            holder.areaCodeTv = (TextView)convertView.findViewById(R.id.tv_area_code);
            holder.countryNameTv = (TextView)convertView.findViewById(R.id.tv_country);
            holder.dividerView = convertView.findViewById(R.id.view_divider);
            holder.valueAreaRl = (RelativeLayout)convertView.findViewById(R.id.rl_value);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.valueAreaRl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CountryListAdapter.this.onItemClick.onItemSelected(country);
            }
        });
        if (this.isZh) {
            if (position == 0) {
                holder.firstLetterTv.setText((CharSequence)PinyinUtils.getFirstSpell(country.getZh()).toUpperCase().substring(0, 1));
                holder.firstLetterTv.setVisibility(0);
            } else if (PinyinUtils.getFirstSpell(country.getZh()).substring(0, 1).equals(PinyinUtils.getFirstSpell(this.countryEntities.get(position - 1).getZh()).substring(0, 1))) {
                holder.firstLetterTv.setVisibility(8);
            } else {
                holder.firstLetterTv.setText((CharSequence)PinyinUtils.getFirstSpell(country.getZh()).toUpperCase().substring(0, 1));
                holder.firstLetterTv.setVisibility(0);
            }
            holder.areaCodeTv.setText((CharSequence)("+" + country.getArea_code()));
            holder.countryNameTv.setText((CharSequence)country.getZh());
            if (position == this.getCount() - 1) {
                holder.dividerView.setVisibility(8);
            } else if (PinyinUtils.getFirstSpell(country.getZh()).substring(0, 1).equals(PinyinUtils.getFirstSpell(this.countryEntities.get(position + 1).getZh()).substring(0, 1))) {
                holder.dividerView.setVisibility(0);
            } else {
                holder.dividerView.setVisibility(8);
            }
        } else {
            holder.areaCodeTv.setText((CharSequence)("+" + country.getArea_code()));
            holder.countryNameTv.setText((CharSequence)country.getEn());
            if (position == 0) {
                holder.firstLetterTv.setText((CharSequence)country.getCode().substring(0, 1));
                holder.firstLetterTv.setVisibility(0);
            } else if (country.getCode().substring(0, 1).equals(this.countryEntities.get(position - 1).getCode().substring(0, 1))) {
                holder.firstLetterTv.setVisibility(8);
            } else {
                holder.firstLetterTv.setText((CharSequence)country.getCode().substring(0, 1));
                holder.firstLetterTv.setVisibility(0);
            }
            if (position == this.getCount() - 1) {
                holder.dividerView.setVisibility(8);
            } else if (country.getCode().substring(0, 1).equals(this.countryEntities.get(position + 1).getCode().substring(0, 1))) {
                holder.dividerView.setVisibility(0);
            } else {
                holder.dividerView.setVisibility(8);
            }
        }
        return convertView;
    }

    public static interface OnItemClick {
        public void onItemSelected(CountryEntity var1);
    }

    private class ViewHolder {
        public TextView firstLetterTv;
        public TextView countryNameTv;
        public TextView areaCodeTv;
        public View dividerView;
        public RelativeLayout valueAreaRl;

        private ViewHolder() {
        }
    }
}

