/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopbase;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.beatop.btopbase.BTApplication;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.CountryListAdapter;
import com.beatop.btopbase.R;
import com.beatop.btopbase.module.CountryEntity;
import com.beatop.btopbase.module.CountryListEntity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class BTCountryListActivity
extends BTBaseActivity {
    private TextView title;
    private ImageView back;
    private EditText searchEt;
    private ListView countryListLv;
    private CountryListAdapter adapter;
    private List<CountryEntity> countries;

    @Override
    protected void onLanguageChanged() {
        this.setText();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btbase_activity_countrycode);
        this.initView();
    }

    private void initView() {
        Method[] methods;
        this.title = (TextView)this.findViewById(R.id.title);
        this.back = (ImageView)this.findViewById(R.id.back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTCountryListActivity.this.onBackPressed();
            }
        });
        this.title.requestFocus();
        this.searchEt = (EditText)this.findViewById(R.id.et_search);
        this.searchEt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ArrayList<CountryEntity> result = new ArrayList<CountryEntity>();
                for (int i = 0; i < BTCountryListActivity.this.countries.size(); ++i) {
                    if (!((CountryEntity)BTCountryListActivity.this.countries.get(i)).getEn().contains(s.toString()) && !((CountryEntity)BTCountryListActivity.this.countries.get(i)).getZh().contains(s.toString())) continue;
                    result.add((CountryEntity)BTCountryListActivity.this.countries.get(i));
                }
                if (result.size() == 0) {
                    BTCountryListActivity.this.adapter.update(BTCountryListActivity.this.isZh, BTCountryListActivity.this.countries);
                } else {
                    BTCountryListActivity.this.adapter.update(BTCountryListActivity.this.isZh, result);
                }
            }
        });
        this.countryListLv = (ListView)this.findViewById(R.id.lv_country);
        this.countries = new ArrayList<CountryEntity>();
        for (Method method : methods = CountryListEntity.class.getMethods()) {
            if (!method.getName().contains("get") || method.getName().contains("error")) continue;
            try {
                this.countries.addAll((List)method.invoke((Object)BTApplication.countryListEntity, new Object[0]));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.adapter = new CountryListAdapter((Context)this, this.countries, this.isZh, new CountryListAdapter.OnItemClick(){

            @Override
            public void onItemSelected(CountryEntity countryEntity) {
                BTCountryListActivity.this.setResult(-1, new Intent().putExtra("area_code", "+" + countryEntity.getArea_code()));
                BTCountryListActivity.this.finish();
            }
        });
        this.countryListLv.setAdapter((ListAdapter)this.adapter);
        this.setText();
    }

    private void setText() {
        if (this.isZh) {
            this.title.setText((CharSequence)this.resources.getString(R.string.btbase_area_code_title_zh));
            this.searchEt.setHint(R.string.btbase_area_code_search_zh);
        } else {
            this.title.setText((CharSequence)this.resources.getString(R.string.btbase_area_code_title_en));
            this.searchEt.setHint(R.string.btbase_area_code_search_en);
        }
        this.adapter.update(this.isZh, this.countries);
    }
}

