/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopbase;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.widget.Toast;
import com.beatop.btopbase.R;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopbase.network.NetWorkServer;
import com.beatop.btopbase.network.NetWorkUtils;
import com.beatop.btopbase.utils.SPHelper;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.disc.impl.UnlimitedDiskCache;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.cache.memory.impl.LruMemoryCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;
import com.nostra13.universalimageloader.utils.StorageUtils;
import java.io.File;

public abstract class BTBaseActivity
extends Activity {
    protected final String TAG = "BTop::" + ((Object)((Object)this)).getClass().getSimpleName();
    protected final String LANGUAGE_CHANGE_BROADCAST = "change_language_broadcast";
    protected boolean isZh = true;
    protected Resources resources;
    protected LanguageChangeReceiver receiver;
    protected static NetWorkServer netWorkServer;
    protected static UserInfoEntity userInfo;
    protected static ImageLoader imageLoader;
    protected static DisplayImageOptions options;
    protected String netErrorNote;
    public static boolean isFirstLaunched;
    public static boolean isFirstLaunchedDay;
    public static String ORDER_URL;
    public static String BOOKING_URL;
    public static String OVERSEAS_STUDY_URL;
    public static String PRIVACY_URL;
    public static String ABOUT_US_URL;
    public static String PAY_SUCCESS_URL;
    public static String PAY_PAL_CLIENT_ID;
    public static String ONLINE_SERVICE_ZH;
    public static String ONLINE_SERVICE_EN;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.resources = this.getResources();
        this.receiver = new LanguageChangeReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("change_language_broadcast");
        this.registerReceiver(this.receiver, filter);
        if (SPHelper.getLanguageSetting().equals("zh")) {
            this.isZh = true;
            this.netErrorNote = this.resources.getString(R.string.btbase_net_error_note_zh);
        } else {
            this.isZh = false;
            this.netErrorNote = this.resources.getString(R.string.btbase_net_error_note_en);
        }
        netWorkServer = NetWorkUtils.getInstance().getNetWorkServer();
        if (SPHelper.isLogin()) {
            userInfo = SPHelper.getUserInfo();
        }
        if (options == null) {
            this.initImageLoader();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.receiver);
    }

    protected abstract void onLanguageChanged();

    protected void showMsg(String msg) {
        Toast toast = Toast.makeText((Context)this, (CharSequence)msg, (int)0);
        toast.setGravity(17, 0, 0);
        toast.show();
    }

    private void initImageLoader() {
        File cacheDir = StorageUtils.getOwnCacheDirectory((Context)this.getApplicationContext(), (String)"banner/cache");
        imageLoader = ImageLoader.getInstance();
        options = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisk(true).bitmapConfig(Bitmap.Config.RGB_565).imageScaleType(ImageScaleType.EXACTLY).build();
        DisplayImageOptions defaultOptions = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisk(true).build();
        ImageLoaderConfiguration configuration = new ImageLoaderConfiguration.Builder((Context)this).defaultDisplayImageOptions(defaultOptions).memoryCache((MemoryCache)new LruMemoryCache(0x400000)).diskCacheSize(0x2000000).memoryCacheSize(0x400000).diskCacheSize(0x1700000).diskCache((DiskCache)new UnlimitedDiskCache(cacheDir)).threadPriority(3).tasksProcessingOrder(QueueProcessingType.LIFO).build();
        imageLoader.init(configuration);
    }

    protected class LanguageChangeReceiver
    extends BroadcastReceiver {
        protected LanguageChangeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("change_language_broadcast")) {
                BTBaseActivity.this.isZh = SPHelper.getLanguageSetting().equals("zh");
                BTBaseActivity.this.onLanguageChanged();
            }
        }
    }
}

