package com.beatop.btopbase.utils;

import android.content.Context;
import android.content.SharedPreferences;

import com.beatop.btopbase.module.BannerEntity;
import com.beatop.btopbase.module.BannerList;
import com.beatop.btopbase.module.UserInfoEntity;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by Administrator on 2016/9/26.
 */
public class SPHelper {
    private static SharedPreferences sp;
    private static SharedPreferences.Editor editor;

    public static void initSPHelper(Context context, String name) {
        if (sp == null) {
            sp = context.getSharedPreferences(name, Context.MODE_PRIVATE);
            editor = sp.edit();
        }
    }

    public static void saveLanguageSetting(String language) {
        editor.putString("language", language);
        editor.commit();
    }

    public static String getLanguageSetting() {
        return sp.getString("language", "def");
    }


    /*
        private String _id;
    private String uid;
    private String realname;
    private String nickname;
    private String email;
    private String mobile;
    private String area_code;
    private String birthday;
    private int gender;
    private Profile profile;
    private NetError error;
    private String _Akey;
    private Verify verified;

     */
    public static void saveUserInfo(UserInfoEntity userInfoEntity) {
        editor.putString("_Akey", userInfoEntity.get_Akey());
        editor.putString("_id", userInfoEntity.get_id());
        editor.putString("uid", userInfoEntity.getUid());
        editor.putString("realname", userInfoEntity.getRealname());
        editor.putString("nickname", userInfoEntity.getNickname());
        editor.putString("mobile", userInfoEntity.getMobile());
        editor.putString("email", userInfoEntity.getEmail());
        editor.putString("area_code", userInfoEntity.getArea_code());
        editor.putString("birthday", userInfoEntity.getBirthday());
        editor.putInt("gender", userInfoEntity.getGender());
        if (userInfoEntity.getProfile() != null) {
            editor.putString("profile.avatar", userInfoEntity.getProfile().getAvatar());
        }
        if (userInfoEntity.getVerified() != null) {
            editor.putInt("verify.mobile", userInfoEntity.getVerified().getMobile());
            editor.putInt("verify.email", userInfoEntity.getVerified().getEmail());
        }
        editor.commit();
    }

    public static UserInfoEntity getUserInfo() {
        UserInfoEntity userInfoEntity = new UserInfoEntity();
        UserInfoEntity.Profile profile = new UserInfoEntity.Profile();
        UserInfoEntity.Verify verify = new UserInfoEntity.Verify();
        profile.setAvatar(sp.getString("profile.avatar", ""));
        verify.setEmail(sp.getInt("verify.email", 0));
        verify.setMobile(sp.getInt("verify.mobile", 0));


        userInfoEntity.set_id(sp.getString("_id", ""));
        userInfoEntity.setProfile(profile);
        userInfoEntity.setVerified(verify);
        userInfoEntity.setMobile(sp.getString("mobile", ""));
        userInfoEntity.setArea_code(sp.getString("area_code", ""));
        userInfoEntity.setEmail(sp.getString("email", ""));
        userInfoEntity.setRealname(sp.getString("realname", ""));
        userInfoEntity.setNickname(sp.getString("nickname", ""));
        userInfoEntity.set_Akey(sp.getString("_Akey", ""));
        userInfoEntity.setUid(sp.getString("uid", ""));
        userInfoEntity.setBirthday(sp.getString("birthday", ""));
        userInfoEntity.setGender(sp.getInt("gender", 0));


        return userInfoEntity;
    }

    public static String get_Akey() {
        return sp.getString("_Akey", "");
    }

    public static String get_id() {
        return sp.getString("_id", "");
    }


    public static boolean isFirstLaunched() {
        boolean result = sp.getBoolean("firstLaunched", true);
        if (result) {
            setFirstLaunched(false);
        }
        return result;
    }

    public static void setFirstLaunched(boolean firstLaunched) {
        editor.putBoolean("firstLaunched", firstLaunched);
        editor.commit();
    }

    public static void saveLoginStatus(boolean isLogin) {
        editor.putBoolean("isLogin", isLogin);
        editor.commit();

    }

    public static void saveBannerList(BannerList list) {
        editor.putInt("banner_list_size", list.getVal().getEn().size());
        for (int i = 0; i < list.getVal().getEn().size(); i++) {
            editor.putString("title_zh_" + i, list.getVal().getZh().get(i).getTitle());
            editor.putString("title_en_" + i, list.getVal().getEn().get(i).getTitle());

            editor.putString("path_zh_" + i, list.getVal().getZh().get(i).getPath());
            editor.putString("path_en_" + i, list.getVal().getEn().get(i).getPath());

            editor.putString("url_zh_" + i, list.getVal().getZh().get(i).getUrl());
            editor.putString("url_en_" + i, list.getVal().getEn().get(i).getUrl());
        }
        editor.commit();
    }

    public static BannerList getBannerList() {
        ArrayList<BannerEntity> en = new ArrayList<>();
        ArrayList<BannerEntity> zh = new ArrayList<>();
        for (int i = 0; i < sp.getInt("banner_list_size", 0); i++) {
            BannerEntity bZh = new BannerEntity();
            BannerEntity bEn = new BannerEntity();
            bZh.setUrl(sp.getString("url_zh_" + i, ""));
            bZh.setPath(sp.getString("path_zh_" + i, ""));
            bZh.setTitle(sp.getString("title_zh_" + i, ""));
            zh.add(bZh);

            bEn.setTitle(sp.getString("title_en_" + i, ""));
            bEn.setPath(sp.getString("path_en_" + i, ""));
            bEn.setUrl(sp.getString("url_en_" + i, ""));
            en.add(bEn);

        }
        BannerList bList = new BannerList();
        BannerList.Val val = new BannerList.Val();
        val.setEn(en);
        val.setZh(zh);
        bList.setVal(val);
        return bList;

    }

    public static boolean isLogin() {
        return sp.getBoolean("isLogin", false);
    }

    /**
     * @return
     */
    public static boolean isFirstLaunchedDaily() {
        Calendar calendar = Calendar.getInstance();
        int currentDay = calendar.get(Calendar.DAY_OF_YEAR);
        int currentYear = calendar.get(Calendar.YEAR);
        Long lastLaunchedTime = sp.getLong("lastLaunchedTime", 0);
        calendar.setTimeInMillis(lastLaunchedTime);
        int lastDay = calendar.get(Calendar.DAY_OF_YEAR);
        int lastYear = calendar.get(Calendar.YEAR);
        saveLastLaunchedTime();
        return currentDay != lastDay || currentYear != lastYear;
    }

    public static void saveLastLaunchedTime() {
        editor.putLong("lastLaunchedTime", System.currentTimeMillis());
        editor.commit();

    }


}
