package com.beatop.btopbase.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.beatop.btopbase.BTApplication;
import com.google.gson.GsonBuilder;

import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;


/**
 * Created by Administrator on 2016/5/3.
 */
public class NetWorkUtils {
    private static Retrofit retrofit;
    private static NetWorkUtils netWork;
    private static NetWorkServer netWorkServer;
    //  private static final String BASE_URL = "http:api.cheesedu.com/v2/";//test url
    //private static final String BASE_URL = "http:api.cheese7.com/v2/";//real url

    private NetWorkUtils() {
        if (retrofit == null) {
            retrofit = new Retrofit.Builder().baseUrl(BTApplication.BASE_URL).addConverterFactory(GsonConverterFactory.create(new GsonBuilder().create())).build();
            netWork = this;
            netWorkServer = retrofit.create(NetWorkServer.class);
        }
    }

    public static synchronized NetWorkUtils getInstance() {
        if (retrofit == null) {
            new NetWorkUtils();
        }
        return netWork;
    }

    public synchronized NetWorkServer getNetWorkServer() {
        return netWorkServer;
    }


    public static boolean isNetConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.isConnectedOrConnecting();
    }


    public int getNetworkType(Context context) {
        int netType = 0;
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return netType;
        }
        return networkInfo.getType();
//        if (nType == ConnectivityManager.TYPE_MOBILE) {
//            String extraInfo = networkInfo.getExtraInfo();
//            if(!TextUtils.isEmpty(extraInfo)){
//                if (extraInfo.toLowerCase().equals("cmnet")) {
//                    netType = NETTYPE_CMNET;
//                } else {
//                    netType = NETTYPE_CMWAP;
//                }
//            }
//        } else if (nType == ConnectivityManager.TYPE_WIFI) {
//            netType = NETTYPE_WIFI;
//        }
//        return netType;
    }


}
