package com.beatop.btopbase.network;

import android.support.annotation.Nullable;

import com.beatop.btopbase.module.BannerList;
import com.beatop.btopbase.module.CaptchaResultEntity;
import com.beatop.btopbase.module.ChangePhoneResultEntity;
import com.beatop.btopbase.module.CheckMobileResultEntity;
import com.beatop.btopbase.module.CountryListEntity;
import com.beatop.btopbase.module.FeedbackResultEntity;
import com.beatop.btopbase.module.LogoutResultEntity;
import com.beatop.btopbase.module.SetLanguageResultEntity;
import com.beatop.btopbase.module.SocialLoginResultEntity;
import com.beatop.btopbase.module.UpdateResultEntity;
import com.beatop.btopbase.module.UserInfoEntity;

import java.util.ArrayList;

import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Created by Administrator on 2016/9/26.
 */
public interface NetWorkServer {

    @GET("conf/getVal")
    Call<BannerList> updateBanner(@Query("key") String key);

    @GET("member/info")
    Call<UserInfoEntity> getUserInfo(@Query("_Akey") String _Akey);


    @FormUrlEncoded
    @POST("order/paypal_payment")
    Call<LogoutResultEntity> savePayPalInfo(@Field("_Akey") String _Akey, @Field("_id") String _id, @Field("payment") String payment);


    // app update api
    @GET("config/checkup")
    Call<UpdateResultEntity> checkUpdate(@Query("id") String id, @Query("os") String os, @Query("version") String version, @Query("_lang") String _lang);

    @GET("account/login")
    Call<UserInfoEntity> login(@Query("account") String account, @Query("password") String password, @Query("app") String app, @Query("device.uuid") String uuid,
                               @Query("device.os") String os, @Query("device.token") String token, @Query("device.country") String contry);

    @GET("account/logout")
    Call<LogoutResultEntity> logout(@Query("_Akey") String _Akey);


    @GET("account/captcha")
    Call<CaptchaResultEntity> getCaptcha(@Query("area_code") String area_code, @Query("mobile") String mobile, @Query("use") String use);

    @GET("account/signup")
    Call<UserInfoEntity> signup(@Query("area_code") String area_code, @Query("mobile") String mobile, @Query("email") String email,
                                @Query("password") String password, @Query("captcha") String captcha, @Query("nickname") String nickname,
                                @Query("profile") String profile);

    @FormUrlEncoded
    @POST("account/password")
    Call<UserInfoEntity> changePwd(@Field("_Akey") String _Akey, @Field("old") String old, @Field("password") String password, @Field("use") String use);

    @GET("account/forget")
    Call<UserInfoEntity> forgetPwd(@Query("area_code") String area_code, @Query("mobile") String mobile, @Query("account") String account,
                                   @Query("email") String email, @Query("password") String password, @Query("captcha") String captcha);

    @GET("account/mobile_auth")
    Call<UserInfoEntity> bindingMobile(@Query("area_code") String area_code, @Query("mobile") String mobile, @Query("captcha") String captcha,
                                       @Query("_Akey") String _Akey);

    @FormUrlEncoded
    @POST("account/update_mobile")
    Call<ChangePhoneResultEntity> changeMobile(@Field("_Akey") String _AKey, @Field("area_code") String area_code, @Field("mobile") String mobile);

    @FormUrlEncoded
    @POST("account/update_email")
    Call<ChangePhoneResultEntity> changeEmail(@Field("_Akey") String _AKey, @Field("email") String email);

//    @GET("account/check_mobile")
//    Call<CheckMobileResultEntity> checkMobile(@Query("area_code") String area_code, @Query("mobile") String mobile, @Query("code") String code);

    // update user info api
    @FormUrlEncoded
    @POST("account/update")
    Call<UserInfoEntity> updateUserInfo(@Field("_Akey") String _Akey, @Field("nickname") String nickname, @Field("gender") int gender,
                                        @Field("birthday") String birthday, @Field("profile.avatar") String avatar);

    /**
     * @param _Akey
     * @param _lang {en,zh}
     * @return
     */
    @GET("lang/set")
    Call<SetLanguageResultEntity> changeLanguage(@Query("_Akey") String _Akey, @Query("_lang") String _lang);

    // social login api
    @GET("account/slogin")
    Call<SocialLoginResultEntity> socialLogin(@Query("tp") String tp, @Query("token") String token, @Query("openid") String openid);

    @GET("feedback/add")
    Call<FeedbackResultEntity> feedback(@Query("contact") String contact, @Query("type") String type, @Query("note") String note, @Query("pic") @Nullable ArrayList<String> pic);

    /**
     * get country list
     */
    @GET("dist/list")
    Call<CountryListEntity> getCountryList();

    //&extra[success_url]=www.cheesedu.com"
    @GET("order/ping_charge?f=android")
    Call<Object> pingxxPay(@Query("_Akey") String _Akey, @Query("_id") String _id, @Query("channel") String channel,
                           @Query("order_no") String order_no, @Query("amount") String amount);


}
