package com.beatop.btopbase;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beatop.btopbase.module.CountryEntity;
import com.beatop.btopbase.utils.PinyinUtils;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * Created by Administrator on 2016/10/11.
 */
public class CountryListAdapter extends BaseAdapter {
    private boolean isZh;
    private Context context;
    private List<CountryEntity> countryEntities;
    private OnItemClick onItemClick;

    public CountryListAdapter(Context context, List<CountryEntity> countryEntities, boolean isZh, OnItemClick onItemClick) {
        this.context = context;
        this.countryEntities = countryEntities;
        this.isZh = isZh;
        this.onItemClick = onItemClick;
        if (isZh) {
            Collections.sort(this.countryEntities, new Comparator<CountryEntity>() {
                @Override
                public int compare(CountryEntity lhs, CountryEntity rhs) {
                    return PinyinUtils.getPingYin(lhs.getZh()).compareToIgnoreCase(PinyinUtils.getPingYin(rhs.getZh()));
                }
            });
        } else {
            Collections.sort(this.countryEntities, new Comparator<CountryEntity>() {
                @Override
                public int compare(CountryEntity lhs, CountryEntity rhs) {
                    return lhs.getEn().compareToIgnoreCase(rhs.getEn());
                }
            });
        }
    }


    public void update(boolean isZh, List<CountryEntity> countries) {
        if (this.isZh == isZh && this.countryEntities == countries) {
            return;
        }
        this.isZh = isZh;
        this.countryEntities = countries;
        if (isZh) {
            Collections.sort(this.countryEntities, new Comparator<CountryEntity>() {
                @Override
                public int compare(CountryEntity lhs, CountryEntity rhs) {
                    return PinyinUtils.getPingYin(lhs.getZh()).compareToIgnoreCase(PinyinUtils.getPingYin(rhs.getZh()));
                }
            });
        } else {
            Collections.sort(this.countryEntities, new Comparator<CountryEntity>() {
                @Override
                public int compare(CountryEntity lhs, CountryEntity rhs) {
                    return lhs.getEn().compareToIgnoreCase(rhs.getEn());
                }
            });
        }
        notifyDataSetChanged();
    }

    @Override
    public int getCount() {

        return countryEntities.size();
    }

    @Override
    public Object getItem(int position) {
        return countryEntities.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        final CountryEntity country = countryEntities.get(position);
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from(context).inflate(R.layout.btbase_list_countrylist_value, null);
            holder.firstLetterTv = (TextView) convertView.findViewById(R.id.tv_key);
            holder.areaCodeTv = (TextView) convertView.findViewById(R.id.tv_area_code);
            holder.countryNameTv = (TextView) convertView.findViewById(R.id.tv_country);
            holder.dividerView = convertView.findViewById(R.id.view_divider);
            holder.valueAreaRl = (RelativeLayout) convertView.findViewById(R.id.rl_value);

            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        holder.valueAreaRl.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onItemClick.onItemSelected(country);
            }
        });
        if (isZh) {

            if (position == 0) {
                holder.firstLetterTv.setText(PinyinUtils.getFirstSpell(country.getZh()).toUpperCase().substring(0, 1));
                holder.firstLetterTv.setVisibility(View.VISIBLE);
            } else {
                if (PinyinUtils.getFirstSpell(country.getZh()).substring(0, 1).equals(PinyinUtils.getFirstSpell(countryEntities.get(position - 1).getZh()).substring(0, 1))) {
                    holder.firstLetterTv.setVisibility(View.GONE);
                } else {
                    holder.firstLetterTv.setText(PinyinUtils.getFirstSpell(country.getZh()).toUpperCase().substring(0, 1));
                    holder.firstLetterTv.setVisibility(View.VISIBLE);
                }
            }
            holder.areaCodeTv.setText("+" + country.getArea_code());
            holder.countryNameTv.setText(country.getZh());
            if (position == getCount() - 1) {
                holder.dividerView.setVisibility(View.GONE);
            } else {
                if (PinyinUtils.getFirstSpell(country.getZh()).substring(0, 1).equals(PinyinUtils.getFirstSpell(countryEntities.get(position + 1).getZh()).substring(0, 1))) {
                    holder.dividerView.setVisibility(View.VISIBLE);
                } else {
                    holder.dividerView.setVisibility(View.GONE);
                }
            }

        } else {


            holder.areaCodeTv.setText("+" + country.getArea_code());
            holder.countryNameTv.setText(country.getEn());

            if (position == 0) {
                holder.firstLetterTv.setText(country.getCode().substring(0, 1));
                holder.firstLetterTv.setVisibility(View.VISIBLE);
            } else {
                if (country.getCode().substring(0, 1).equals(countryEntities.get(position - 1).getCode().substring(0, 1))) {
                    holder.firstLetterTv.setVisibility(View.GONE);
                } else {
                    holder.firstLetterTv.setText(country.getCode().substring(0, 1));
                    holder.firstLetterTv.setVisibility(View.VISIBLE);
                }
            }
            if (position == getCount() - 1) {
                holder.dividerView.setVisibility(View.GONE);
            } else {
                if (country.getCode().substring(0, 1).equals(countryEntities.get(position + 1).getCode().substring(0, 1))) {
                    holder.dividerView.setVisibility(View.VISIBLE);
                } else {
                    holder.dividerView.setVisibility(View.GONE);
                }
            }

        }

        return convertView;
    }

    private class ViewHolder {
        public TextView firstLetterTv;
        public TextView countryNameTv;
        public TextView areaCodeTv;
        public View dividerView;
        public RelativeLayout valueAreaRl;
    }

    public interface OnItemClick {
        public void onItemSelected(CountryEntity countryEntity);
    }

}
