package com.beatop.btopbase;

import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import com.beatop.btopbase.module.CountryEntity;
import com.beatop.btopbase.module.CountryListEntity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2016/10/10.
 */
public class BTCountryListActivity extends BTBaseActivity {
    private TextView title;
    private ImageView back;
    private EditText searchEt;
    private ListView countryListLv;
    private CountryListAdapter adapter;
    private List<CountryEntity> countries;
    //  private List<CountryEntity> countryListEn;

    @Override
    protected void onLanguageChanged() {
        setText();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.btbase_activity_countrycode);
        initView();
    }

    private void initView() {
        title = (TextView) findViewById(R.id.title);
        back = (ImageView) findViewById(R.id.back);
        back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        title.requestFocus();//防止自动弹出键盘
        searchEt = (EditText) findViewById(R.id.et_search);
        searchEt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                List<CountryEntity> result = new ArrayList<CountryEntity>();
                for (int i = 0; i < countries.size(); i++) {
                    if (countries.get(i).getEn().contains(s.toString()) || countries.get(i).getZh().contains(s.toString())) {
                        result.add(countries.get(i));
                    }
                }
                if(result.size()==0){
                    adapter.update(isZh,countries);
                }else{
                    adapter.update(isZh,result);
                }
            }
        });
        countryListLv = (ListView) findViewById(R.id.lv_country);
        countries = new ArrayList<>();
        Method[] methods = CountryListEntity.class.getMethods();
        for (Method method : methods) {
            if (method.getName().contains("get") && !method.getName().contains("error")) {
                try {
                    countries.addAll((List<CountryEntity>) method.invoke(BTApplication.countryListEntity));
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        adapter = new CountryListAdapter(this, countries, isZh, new CountryListAdapter.OnItemClick() {
            @Override
            public void onItemSelected(CountryEntity countryEntity) {
                //  showMsg(countryEntity.getZh());
                setResult(RESULT_OK, new Intent().putExtra("area_code", "+" + countryEntity.getArea_code()));
                finish();
            }
        });
        countryListLv.setAdapter(adapter);
        setText();
    }

    private void setText() {
        if (isZh) {
            title.setText(resources.getString(R.string.btbase_area_code_title_zh));
            searchEt.setHint(R.string.btbase_area_code_search_zh);
        } else {
            title.setText(resources.getString(R.string.btbase_area_code_title_en));
            searchEt.setHint(R.string.btbase_area_code_search_en);
        }
        adapter.update(isZh, countries);
    }

}
