package com.beatop.btopbase;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.widget.Toast;

import com.beatop.btopbase.module.CheckMobileResultEntity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopbase.network.NetWorkServer;
import com.beatop.btopbase.network.NetWorkUtils;
import com.beatop.btopbase.utils.SPHelper;
import com.nostra13.universalimageloader.cache.disc.impl.UnlimitedDiskCache;
import com.nostra13.universalimageloader.cache.memory.impl.LruMemoryCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;

import java.io.File;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Administrator on 2016/9/26.
 */
public abstract class BTBaseActivity extends Activity {
    protected final String TAG = "BTop::" + getClass().getSimpleName();
    protected final String LANGUAGE_CHANGE_BROADCAST = "change_language_broadcast";
    protected boolean isZh = true;
    protected Resources resources;
    protected LanguageChangeReceiver receiver;
    protected static NetWorkServer netWorkServer;
    protected static UserInfoEntity userInfo;
    protected static ImageLoader imageLoader;
    protected static DisplayImageOptions options;
    protected String netErrorNote;


    public static boolean isFirstLaunched;
    public static boolean isFirstLaunchedDay;
    public static String ORDER_URL;
    public static String BOOKING_URL;
    public static String OVERSEAS_STUDY_URL;
    public static String PRIVACY_URL;
    public static String ABOUT_US_URL;
    public static String PAY_SUCCESS_URL;
    public static String PAY_PAL_CLIENT_ID;
    public static String ONLINE_SERVICE_ZH;
    public static String ONLINE_SERVICE_EN;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        resources = getResources();
        receiver = new LanguageChangeReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(LANGUAGE_CHANGE_BROADCAST);
        registerReceiver(receiver, filter);
        if (SPHelper.getLanguageSetting().equals("zh")) {
            isZh = true;
            netErrorNote = resources.getString(R.string.btbase_net_error_note_zh);
        } else {
            isZh = false;
            netErrorNote = resources.getString(R.string.btbase_net_error_note_en);
        }
        netWorkServer = NetWorkUtils.getInstance().getNetWorkServer();
        if (SPHelper.isLogin()) {
            userInfo = SPHelper.getUserInfo();
        }
        if (options == null) {
            initImageLoader();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        unregisterReceiver(receiver);
    }

    protected abstract void onLanguageChanged();

    protected class LanguageChangeReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(LANGUAGE_CHANGE_BROADCAST)) {
                if (SPHelper.getLanguageSetting().equals("zh")) {
                    isZh = true;
                } else {
                    isZh = false;
                }
                onLanguageChanged();
            }
        }
    }

    protected void showMsg(String msg) {
        Toast toast = Toast.makeText(this, msg, Toast.LENGTH_SHORT);
        toast.setGravity(Gravity.CENTER, 0, 0);
        toast.show();
    }

    private void initImageLoader() {
        File cacheDir = com.nostra13.universalimageloader.utils.StorageUtils
                .getOwnCacheDirectory(getApplicationContext(),
                        "banner/cache");
        imageLoader = ImageLoader.getInstance();
        options = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisk(true)
                .bitmapConfig(Bitmap.Config.RGB_565).imageScaleType(ImageScaleType.EXACTLY).build();
        DisplayImageOptions defaultOptions = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisk(true).build();
        ImageLoaderConfiguration configuration = new ImageLoaderConfiguration.Builder(this).defaultDisplayImageOptions(defaultOptions)
                .memoryCache(new LruMemoryCache(4 * 1024 * 1024)).diskCacheSize(32 * 1024 * 1024)
                .memoryCacheSize(4 * 1024 * 1024).diskCacheSize(23 * 1024 * 1024).diskCache(new UnlimitedDiskCache(cacheDir))
                .threadPriority(Thread.NORM_PRIORITY - 2)
                .tasksProcessingOrder(QueueProcessingType.LIFO).build();
        imageLoader.init(configuration);
    }
}
