package com.beatop.btopbase;

import android.app.Application;

import com.beatop.btopbase.module.CountryListEntity;
import com.beatop.btopbase.network.NetWorkUtils;
import com.beatop.btopbase.utils.SPHelper;
import com.tencent.bugly.crashreport.CrashReport;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by Administrator on 2016/9/26.
 */
public abstract class BTApplication extends Application {
    private final static String TAG = "Main::BTApplication";
    public static String BASE_URL;
    public static CountryListEntity countryListEntity;
    public boolean isTest = true;
    //   public static UserInfoEntity userInfo;


    @Override
    public void onCreate() {
        super.onCreate();
        isTest = setEnvironment();
        BASE_URL = setBaseUrL();
        setApplicationInfo();
        CrashReport.initCrashReport(this, setBuglyAPPId(), false);
        SPHelper.initSPHelper(this, setSPName());
        if (SPHelper.getLanguageSetting().equals("def")) {
            SPHelper.saveLanguageSetting(getResources().getConfiguration().locale.getLanguage());
        }
        BTBaseActivity.isFirstLaunched = SPHelper.isFirstLaunched();
        BTBaseActivity.isFirstLaunchedDay = SPHelper.isFirstLaunchedDaily();
        getCountryList();

    }

    private void getCountryList() {
        NetWorkUtils.getInstance().getNetWorkServer().getCountryList().enqueue(new Callback<CountryListEntity>() {
            @Override
            public void onResponse(Call<CountryListEntity> call, Response<CountryListEntity> response) {
                if (response.body().getError() == null) {
                    countryListEntity = response.body();
                }
            }

            @Override
            public void onFailure(Call<CountryListEntity> call, Throwable t) {

            }
        });
    }

    protected abstract String setSPName();

    protected abstract String setBuglyAPPId();

    protected abstract String setBaseUrL();

    protected abstract boolean setEnvironment();

    protected abstract void setApplicationInfo();
}
